/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.util;

import fr.ifremer.tutti.TuttiConfiguration;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jdbcs {
    private static final Log log = LogFactory.getLog(Jdbcs.class);

    public static void closeSilently(Statement statement) {
        block7: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(ResultSet statement) {
        block7: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static Connection createConnection(Properties connectionProperties) throws SQLException {
        return Jdbcs.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    public static String getUrl(Properties connectionProperties) {
        return connectionProperties.getProperty("hibernate.connection.url");
    }

    public static Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    public static void fillConnectionProperties(Properties p, String url, String username, String password) {
        p.put("hibernate.connection.url", url);
        p.put("hibernate.connection.username", username);
        p.put("hibernate.connection.password", password);
    }

    public static String getJdbcUrl(File directory, String dbName) {
        return "jdbc:hsqldb:file:" + directory.getAbsolutePath() + "/" + dbName;
    }

    public static void shutdown(TuttiConfiguration configuration) throws SQLException {
        String jdbcUrl = configuration.getJdbcUrl();
        String jdbcUsername = configuration.getJdbcUsername();
        String jdbcPassword = configuration.getJdbcPassword();
        try (Connection connection = Jdbcs.createConnection(jdbcUrl, jdbcUsername, jdbcPassword);
             PreparedStatement pStmt = connection.prepareStatement("SHUTDOWN");){
            pStmt.execute();
        }
    }

    public static void shutdownCompact(TuttiConfiguration configuration) throws SQLException {
        String jdbcUrl = configuration.getJdbcUrl();
        String jdbcUsername = configuration.getJdbcUsername();
        String jdbcPassword = configuration.getJdbcPassword();
        try (Connection connection = Jdbcs.createConnection(jdbcUrl, jdbcUsername, jdbcPassword);
             PreparedStatement pStmt = connection.prepareStatement("SHUTDOWN COMPACT");){
            pStmt.execute();
        }
    }
}

