/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import com.ibm.icu.text.Collator;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.aggregate.IAggregateFunction;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.internal.datafeed.GroupKey;
import org.eclipse.birt.chart.internal.datafeed.GroupingLookupHelper;
import org.eclipse.birt.chart.internal.datafeed.GroupingUtil;
import org.eclipse.birt.chart.internal.datafeed.ResultSetDataSet;
import org.eclipse.birt.chart.internal.datafeed.TupleComparator;
import org.eclipse.birt.chart.internal.datafeed.VSResultSetDataSet;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.attribute.GroupingUnitType;
import org.eclipse.birt.chart.model.attribute.SortOption;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.NumberDataElement;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.SeriesGrouping;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.emf.common.util.EList;

public final class ResultSetWrapper {
    final List rawResultSet;
    final List workingResultSet;
    final String[] saExpressionKeys;
    final int[] iaDataTypes;
    private static final int[] NO_GROUP_BREAKS = new int[0];
    private int[] iaGroupBreaks = NO_GROUP_BREAKS;
    private final GroupingLookupHelper htLookup;
    private final GroupKey[] oaGroupKeys;
    private static final double BASE_START_INTERVAL_VALUE = 0.0;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/datafeed");

    public ResultSetWrapper(GroupingLookupHelper hmLookup, List liResultSet, GroupKey[] groupKeys) {
        this(hmLookup, liResultSet, groupKeys, NO_GROUP_BREAKS);
    }

    public ResultSetWrapper(GroupingLookupHelper hmLookup, List liResultSet, GroupKey[] groupKeys, int[] groupBreaks) {
        this.htLookup = hmLookup;
        this.rawResultSet = liResultSet;
        this.workingResultSet = new ArrayList();
        this.workingResultSet.addAll(this.rawResultSet);
        List<String> stExpressionKeys = hmLookup.getExpressions();
        this.saExpressionKeys = stExpressionKeys.toArray(new String[stExpressionKeys.size()]);
        this.iaDataTypes = new int[this.saExpressionKeys.length];
        this.oaGroupKeys = groupKeys;
        this.iaGroupBreaks = groupBreaks;
        this.initializeMeta();
    }

    public void applyWholeSeriesSortingNGrouping(SeriesDefinition sdBase, SeriesDefinition sdValue, String[] aggregationExp, String[] saExpressionKeys) throws ChartException {
        this.applyValueSeriesGroupingNSorting(sdValue, aggregationExp, saExpressionKeys);
        this.applyBaseSeriesSortingAndGrouping(sdBase, aggregationExp, saExpressionKeys);
    }

    public void applyValueSeriesGroupingNSorting(SeriesDefinition sdValue, String[] aggregationExp, String[] saExpressionKeys) throws ChartException {
        this.generateGroupBreaks(sdValue);
        this.sortYGrouping(sdValue, aggregationExp, saExpressionKeys);
    }

    public void generateGroupBreaks(SeriesDefinition sdValue) {
        this.iaGroupBreaks = this.findGroupBreaks(this.workingResultSet, this.oaGroupKeys != null && this.oaGroupKeys.length > 0 ? this.oaGroupKeys[0] : null, sdValue.getQuery());
    }

    GroupingLookupHelper getLookupHelper() {
        return this.htLookup;
    }

    private void sortYGrouping(SeriesDefinition sdValue, String[] aggregationExp, String[] saExpressionKeys) throws ChartException {
        if (this.iaGroupBreaks == null || this.iaGroupBreaks.length == 0 || !sdValue.isSetSorting() || sdValue.getQuery() == null) {
            return;
        }
        if (sdValue.getSortKey() == null || sdValue.getSortKey().getDefinition() == null) {
            return;
        }
        int ySortExprIndex = this.getLookupHelper().getYSortExprIndex();
        if (ySortExprIndex < 0) {
            return;
        }
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        int[] iaColumnIndexes = new int[iOrthogonalSeriesCount];
        int i = 0;
        while (i < iOrthogonalSeriesCount) {
            iaColumnIndexes[i] = this.getLookupHelper().findIndex(saExpressionKeys[i], aggregationExp[i]);
            ++i;
        }
        int relativeIndex = 0;
        int i2 = 0;
        while (i2 < iaColumnIndexes.length) {
            if (ySortExprIndex == iaColumnIndexes[i2]) {
                relativeIndex = i2;
                break;
            }
            ++i2;
        }
        IAggregateFunction iafa = null;
        try {
            iafa = PluginSettings.instance().getAggregateFunction(aggregationExp[relativeIndex]);
        }
        catch (Exception exception) {}
        if (iafa == null) {
            iafa = PluginSettings.instance().getAggregateFunction("Sum");
        }
        ArrayList<Object[]> sortGroupsList = new ArrayList<Object[]>();
        int i3 = 0;
        while (i3 <= this.iaGroupBreaks.length) {
            int startIndex = -1;
            int endIndex = -1;
            if (i3 == 0) {
                startIndex = 0;
                endIndex = this.iaGroupBreaks[i3];
            } else if (i3 == this.iaGroupBreaks.length) {
                startIndex = this.iaGroupBreaks[i3 - 1];
                endIndex = this.workingResultSet.size();
            } else {
                startIndex = this.iaGroupBreaks[i3 - 1];
                endIndex = this.iaGroupBreaks[i3];
            }
            Object[] sortValue = new Object[3];
            sortValue[0] = startIndex;
            sortValue[1] = endIndex;
            try {
                iafa.initialize();
                int j = startIndex;
                while (j < endIndex) {
                    Object[] oaTuple = (Object[])this.workingResultSet.get(j);
                    iafa.accumulate(oaTuple[ySortExprIndex]);
                    ++j;
                }
                sortValue[2] = iafa.getAggregatedValue();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Object[] oaTuple = (Object[])this.workingResultSet.get(startIndex);
                sortValue[2] = oaTuple[ySortExprIndex];
            }
            sortGroupsList.add(sortValue);
            ++i3;
        }
        YGroupingSorter ygs = new YGroupingSorter();
        ygs.sort(sortGroupsList, sdValue.getSorting(), this.createCollator(sdValue));
        ArrayList newResultSet = new ArrayList();
        int[] newGroupBreaks = new int[sortGroupsList.size() - 1];
        int j = 0;
        for (Object[] sortValue : sortGroupsList) {
            int startIndex = (Integer)sortValue[0];
            int endIndex = (Integer)sortValue[1];
            int i4 = startIndex;
            while (i4 < endIndex) {
                newResultSet.add(this.workingResultSet.get(i4));
                ++i4;
            }
            if (j >= sortGroupsList.size() - 1) continue;
            newGroupBreaks[j++] = newResultSet.size();
        }
        this.workingResultSet.clear();
        this.workingResultSet.addAll(newResultSet);
        this.iaGroupBreaks = newGroupBreaks;
    }

    private void initializeMeta() {
        Iterator it = this.workingResultSet.iterator();
        int iColumnCount = this.iaDataTypes.length;
        boolean[] boaFound = new boolean[iColumnCount];
        while (it.hasNext()) {
            Object[] oaTuple = (Object[])it.next();
            int i = 0;
            while (i < iColumnCount) {
                boolean bAllDone = true;
                if (oaTuple[i] != null) {
                    boaFound[i] = true;
                    if (oaTuple[i] instanceof Number) {
                        this.iaDataTypes[i] = 1;
                    } else if (oaTuple[i] instanceof String) {
                        this.iaDataTypes[i] = 16;
                    } else if (oaTuple[i] instanceof Date || oaTuple[i] instanceof Calendar) {
                        this.iaDataTypes[i] = 8;
                    } else if (oaTuple[i] instanceof Boolean) {
                        this.iaDataTypes[i] = 17;
                    }
                    int j = 0;
                    while (j < iColumnCount) {
                        if (!boaFound[j]) {
                            bAllDone = false;
                            break;
                        }
                        ++j;
                    }
                    if (bAllDone) {
                        return;
                    }
                }
                ++i;
            }
        }
        logger.log(2, Messages.getString("exception.resultset.data.type.retrieval.failed"));
    }

    public void applyBaseSeriesSortingAndGrouping(SeriesDefinition sdBase, String[] aggregationExp, String[] saExpressionKeys) throws ChartException {
        boolean needBaseGrouping = true;
        boolean needBaseSorting = true;
        SeriesGrouping sg = sdBase.getGrouping();
        if (sg == null || !sg.isEnabled()) {
            needBaseGrouping = false;
        }
        if (this.htLookup.getBaseSortExprIndex() < 0) {
            needBaseSorting = false;
        }
        if (needBaseSorting) {
            if (!needBaseGrouping) {
                this.doBaseSorting(sdBase);
                return;
            }
        } else if (!needBaseGrouping) {
            return;
        }
        Series seBaseDesignTime = sdBase.getDesignTimeSeries();
        Query q = (Query)seBaseDesignTime.getDataDefinition().get(0);
        int iSortColumnIndex = this.htLookup.findIndexOfBaseSeries(q.getDefinition());
        SortOption so = null;
        if (!sdBase.isSetSorting()) {
            if (needBaseGrouping) {
                logger.log(2, Messages.getString("warn.unspecified.sorting", new Object[]{sdBase}, ULocale.getDefault()));
                so = SortOption.ASCENDING_LITERAL;
            }
        } else {
            so = sdBase.getSorting();
        }
        GroupingSorter gs = new GroupingSorter();
        gs.sort(this.workingResultSet, iSortColumnIndex, so, this.iaGroupBreaks, this.createCollator(sdBase));
        int iOrthogonalSeriesCount = saExpressionKeys.length;
        IAggregateFunction[] iafa = new IAggregateFunction[iOrthogonalSeriesCount];
        try {
            int i = 0;
            while (i < iOrthogonalSeriesCount) {
                iafa[i] = PluginSettings.instance().getAggregateFunction(aggregationExp[i]);
                iafa[i].initialize();
                ++i;
            }
        }
        catch (ChartException pex) {
            throw new ChartException("org.eclipse.birt.chart.engine", 19, (Throwable)pex);
        }
        int[] iaColumnIndexes = new int[iOrthogonalSeriesCount];
        int i = 0;
        while (i < iOrthogonalSeriesCount) {
            iaColumnIndexes[i] = this.getLookupHelper().findIndex(saExpressionKeys[i], aggregationExp[i]);
            ++i;
        }
        DataType dtGrouping = sg.getGroupType();
        if (dtGrouping == DataType.NUMERIC_LITERAL) {
            this.groupNumerically(this.workingResultSet, iSortColumnIndex, iaColumnIndexes, this.iaGroupBreaks, null, sg.getGroupingInterval(), iafa);
        } else if (dtGrouping == DataType.DATE_TIME_LITERAL) {
            this.groupDateTime(this.workingResultSet, iSortColumnIndex, iaColumnIndexes, this.iaGroupBreaks, null, (long)sg.getGroupingInterval(), sg.getGroupingUnit(), iafa);
        } else if (dtGrouping == DataType.TEXT_LITERAL) {
            this.groupTextually(this.workingResultSet, iSortColumnIndex, iaColumnIndexes, this.iaGroupBreaks, null, (long)sg.getGroupingInterval(), sg.getGroupingUnit(), iafa);
        }
        this.doBaseSorting(sdBase);
        this.initializeMeta();
    }

    private void doBaseSorting(SeriesDefinition sd) {
        int iBaseSortColumnIndex = this.htLookup.getBaseSortExprIndex();
        if (iBaseSortColumnIndex >= 0) {
            GroupingSorter gs = new GroupingSorter();
            gs.sort(this.workingResultSet, iBaseSortColumnIndex, sd.getSorting(), this.iaGroupBreaks, this.createCollator(sd));
        }
    }

    private void groupNumerically(List resultSet, int iBaseColumnIndex, int[] iaColumnIndexes, int[] iaBreaks, NumberDataElement ndeBaseReference, double iGroupingInterval, IAggregateFunction[] iafa) throws ChartException {
        int iOrthogonalSeriesCount = iaColumnIndexes.length;
        int iStartIndex = 0;
        int totalGroupCount = iaBreaks == null ? 1 : iaBreaks.length + 1;
        int totalRowCount = resultSet.size();
        int k = 0;
        while (k < totalGroupCount) {
            int i;
            int iEndIndex = k == totalGroupCount - 1 ? totalRowCount : iaBreaks[k];
            NumberDataElement baseReference = ndeBaseReference;
            if (baseReference == null) {
                Number obj = (Number)((Object[])resultSet.get(iStartIndex))[iBaseColumnIndex];
                baseReference = NumberDataElementImpl.create(obj == null ? 0.0 : obj.doubleValue());
            }
            Object[] oaSummarizedTuple = null;
            int iGroupIndex = 0;
            int iLastGroupIndex = 0;
            boolean bFirst = true;
            boolean bGroupBreak = false;
            double dBaseReference = 0.0;
            ArrayList<Integer> trashList = new ArrayList<Integer>();
            double dLastReference = dBaseReference;
            int j = iStartIndex;
            while (j < iEndIndex) {
                int i2;
                Object[] oaTuple = (Object[])resultSet.get(j);
                if (oaTuple[iBaseColumnIndex] != null) {
                    if (iGroupingInterval == 0.0) {
                        if (((Number)oaTuple[iBaseColumnIndex]).doubleValue() != dLastReference) {
                            ++iGroupIndex;
                        }
                    } else {
                        iGroupIndex = (int)Math.floor(Math.abs((((Number)oaTuple[iBaseColumnIndex]).doubleValue() - dBaseReference) / iGroupingInterval));
                    }
                    dLastReference = ((Number)oaTuple[iBaseColumnIndex]).doubleValue();
                } else {
                    if (iGroupingInterval == 0.0) {
                        if (!Double.isNaN(dLastReference)) {
                            ++iGroupIndex;
                        }
                    } else {
                        iGroupIndex = (int)Math.floor(Math.abs(dBaseReference / iGroupingInterval));
                    }
                    dLastReference = Double.NaN;
                }
                if (!bFirst) {
                    boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
                }
                if (bGroupBreak || bFirst) {
                    if (oaSummarizedTuple != null) {
                        i2 = 0;
                        while (i2 < iOrthogonalSeriesCount) {
                            oaSummarizedTuple[iaColumnIndexes[i2]] = iafa[i2].getAggregatedValue();
                            iafa[i2].initialize();
                            ++i2;
                        }
                        Number obj = (Number)oaTuple[iBaseColumnIndex];
                        baseReference = NumberDataElementImpl.create(obj == null ? 0.0 : obj.doubleValue());
                        dLastReference = baseReference.getValue();
                    } else {
                        bFirst = false;
                    }
                    oaSummarizedTuple = oaTuple;
                } else {
                    trashList.add(j);
                }
                i2 = 0;
                while (i2 < iOrthogonalSeriesCount) {
                    try {
                        iafa[i2].accumulate(oaTuple[iaColumnIndexes[i2]]);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)uiex);
                    }
                    ++i2;
                }
                iLastGroupIndex = iGroupIndex;
                ++j;
            }
            if (oaSummarizedTuple != null) {
                i = 0;
                while (i < iOrthogonalSeriesCount) {
                    oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
                    iafa[i].initialize();
                    ++i;
                }
            }
            i = 0;
            while (i < trashList.size()) {
                resultSet.remove((Integer)trashList.get(i) - i);
                ++i;
            }
            int groupChange = trashList.size();
            trashList.clear();
            if (iaBreaks != null && iaBreaks.length > 0 && groupChange > 0) {
                int j2 = k;
                while (j2 < iaBreaks.length) {
                    int n = j2++;
                    iaBreaks[n] = iaBreaks[n] - groupChange;
                }
            }
            iStartIndex = iEndIndex - groupChange;
            totalRowCount -= groupChange;
            ++k;
        }
    }

    private void groupDateTime(List resultSet, int iBaseColumnIndex, int[] iaColumnIndexes, int[] iaBreaks, CDateTime ndeBaseReference, long iGroupingInterval, GroupingUnitType groupingUnit, IAggregateFunction[] iafa) throws ChartException {
        int iOrthogonalSeriesCount = iaColumnIndexes.length;
        int cunit = GroupingUtil.groupingUnit2CDateUnit(groupingUnit);
        int iStartIndex = 0;
        int totalGroupCount = iaBreaks == null ? 1 : iaBreaks.length + 1;
        int totalRowCount = resultSet.size();
        int k = 0;
        while (k < totalGroupCount) {
            int i;
            int iEndIndex = k == totalGroupCount - 1 ? totalRowCount : iaBreaks[k];
            CDateTime baseReference = ndeBaseReference;
            if (baseReference == null) {
                Object obj = ((Object[])resultSet.get(iStartIndex))[iBaseColumnIndex];
                baseReference = obj instanceof CDateTime ? (CDateTime)((Object)obj) : new CDateTime(0L);
            }
            baseReference.clearBelow(cunit);
            Object[] oaSummarizedTuple = null;
            int iGroupIndex = 0;
            int iLastGroupIndex = 0;
            boolean bFirst = true;
            boolean bGroupBreak = false;
            ArrayList<Integer> trashList = new ArrayList<Integer>();
            int j = iStartIndex;
            while (j < iEndIndex) {
                int i2;
                Object[] oaTuple = (Object[])resultSet.get(j);
                CDateTime dCurrentValue = null;
                if (oaTuple[iBaseColumnIndex] != null) {
                    Object obj = oaTuple[iBaseColumnIndex];
                    dCurrentValue = obj instanceof CDateTime ? (CDateTime)((Object)obj) : new CDateTime(0L);
                    dCurrentValue.clearBelow(cunit);
                } else {
                    dCurrentValue = new CDateTime(0L);
                }
                oaTuple[iBaseColumnIndex] = dCurrentValue;
                double diff = CDateTime.computeDifference(dCurrentValue, baseReference, cunit, true);
                if (diff != 0.0) {
                    int n = iGroupIndex = iGroupingInterval == 0L ? iGroupIndex + 1 : (int)Math.floor(Math.abs(diff / (double)iGroupingInterval));
                }
                if (!bFirst) {
                    boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
                }
                if (bGroupBreak || bFirst) {
                    if (oaSummarizedTuple != null) {
                        i2 = 0;
                        while (i2 < iOrthogonalSeriesCount) {
                            oaSummarizedTuple[iaColumnIndexes[i2]] = iafa[i2].getAggregatedValue();
                            iafa[i2].initialize();
                            ++i2;
                        }
                        Object obj = oaTuple[iBaseColumnIndex];
                        baseReference = obj instanceof CDateTime ? (CDateTime)((Object)obj) : new CDateTime(0L);
                        baseReference.clearBelow(cunit);
                        iGroupIndex = 0;
                    } else {
                        bFirst = false;
                    }
                    oaSummarizedTuple = oaTuple;
                } else {
                    trashList.add(j);
                }
                i2 = 0;
                while (i2 < iOrthogonalSeriesCount) {
                    try {
                        iafa[i2].accumulate(oaTuple[iaColumnIndexes[i2]]);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)uiex);
                    }
                    ++i2;
                }
                iLastGroupIndex = iGroupIndex;
                ++j;
            }
            if (oaSummarizedTuple != null) {
                i = 0;
                while (i < iOrthogonalSeriesCount) {
                    oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
                    iafa[i].initialize();
                    ++i;
                }
            }
            i = 0;
            while (i < trashList.size()) {
                resultSet.remove((Integer)trashList.get(i) - i);
                ++i;
            }
            int groupChange = trashList.size();
            trashList.clear();
            if (iaBreaks != null && iaBreaks.length > 0 && groupChange > 0) {
                int j2 = k;
                while (j2 < iaBreaks.length) {
                    int n = j2++;
                    iaBreaks[n] = iaBreaks[n] - groupChange;
                }
            }
            iStartIndex = iEndIndex - groupChange;
            totalRowCount -= groupChange;
            ++k;
        }
    }

    private void groupTextually(List resultSet, int iBaseColumnIndex, int[] iaColumnIndexes, int[] iaBreaks, String ndeBaseReference, long iGroupingInterval, GroupingUnitType groupingUnit, IAggregateFunction[] iafa) throws ChartException {
        int iOrthogonalSeriesCount = iaColumnIndexes.length;
        int iStartIndex = 0;
        int totalGroupCount = iaBreaks == null ? 1 : iaBreaks.length + 1;
        int totalRowCount = resultSet.size();
        int k = 0;
        while (k < totalGroupCount) {
            int i;
            int iEndIndex = k == totalGroupCount - 1 ? totalRowCount : iaBreaks[k];
            String baseReference = ndeBaseReference;
            if (baseReference == null) {
                baseReference = ChartUtil.stringValue(((Object[])resultSet.get(iStartIndex))[iBaseColumnIndex]);
            }
            Object[] oaSummarizedTuple = null;
            int iGroupIndex = 0;
            int iLastGroupIndex = 0;
            int iGroupCounter = 0;
            boolean bFirst = true;
            boolean bGroupBreak = false;
            ArrayList<Integer> trashList = new ArrayList<Integer>();
            int j = iStartIndex;
            while (j < iEndIndex) {
                Object[] oaTuple = (Object[])resultSet.get(j);
                if (oaTuple[iBaseColumnIndex] != null) {
                    String dBaseValue = String.valueOf(oaTuple[iBaseColumnIndex]);
                    if (!GroupingUtil.isMatchedGroupingString(dBaseValue, baseReference, groupingUnit, (int)iGroupingInterval)) {
                        ++iGroupCounter;
                        baseReference = dBaseValue;
                        if (groupingUnit == GroupingUnitType.STRING_PREFIX_LITERAL) {
                            ++iGroupIndex;
                        }
                    }
                    if (groupingUnit != GroupingUnitType.STRING_PREFIX_LITERAL && (long)iGroupCounter > iGroupingInterval) {
                        ++iGroupIndex;
                    }
                } else {
                    if (baseReference != null) {
                        ++iGroupCounter;
                        baseReference = null;
                    }
                    if ((long)iGroupCounter > iGroupingInterval) {
                        ++iGroupIndex;
                    }
                }
                if (!bFirst) {
                    boolean bl = bGroupBreak = iLastGroupIndex != iGroupIndex;
                }
                if (bGroupBreak) {
                    iGroupCounter = 0;
                }
                if (bGroupBreak || bFirst) {
                    if (oaSummarizedTuple != null) {
                        int i2 = 0;
                        while (i2 < iOrthogonalSeriesCount) {
                            oaSummarizedTuple[iaColumnIndexes[i2]] = iafa[i2].getAggregatedValue();
                            iafa[i2].initialize();
                            ++i2;
                        }
                        baseReference = ChartUtil.stringValue(oaTuple[iBaseColumnIndex]);
                        iGroupIndex = 0;
                    } else {
                        bFirst = false;
                    }
                    oaSummarizedTuple = oaTuple;
                } else {
                    trashList.add(j);
                }
                int i3 = 0;
                while (i3 < iOrthogonalSeriesCount) {
                    try {
                        iafa[i3].accumulate(oaTuple[iaColumnIndexes[i3]]);
                    }
                    catch (IllegalArgumentException uiex) {
                        throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)uiex);
                    }
                    ++i3;
                }
                iLastGroupIndex = iGroupIndex;
                ++j;
            }
            if (oaSummarizedTuple != null) {
                i = 0;
                while (i < iOrthogonalSeriesCount) {
                    oaSummarizedTuple[iaColumnIndexes[i]] = iafa[i].getAggregatedValue();
                    iafa[i].initialize();
                    ++i;
                }
            }
            i = 0;
            while (i < trashList.size()) {
                resultSet.remove((Integer)trashList.get(i) - i);
                ++i;
            }
            int groupChange = trashList.size();
            trashList.clear();
            if (iaBreaks != null && iaBreaks.length > 0 && groupChange > 0) {
                int j2 = k;
                while (j2 < iaBreaks.length) {
                    int n = j2++;
                    iaBreaks[n] = iaBreaks[n] - groupChange;
                }
            }
            iStartIndex = iEndIndex - groupChange;
            totalRowCount -= groupChange;
            ++k;
        }
    }

    public int getGroupCount() {
        if (this.iaGroupBreaks == null) {
            return 1;
        }
        return this.iaGroupBreaks.length + 1;
    }

    public int getGroupRowCount(int iGroupIndex) {
        int startRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        int endRow = iGroupIndex > this.iaGroupBreaks.length - 1 ? this.getRowCount() : this.iaGroupBreaks[iGroupIndex];
        return endRow - startRow;
    }

    public int getColumnCount() {
        return this.saExpressionKeys.length;
    }

    public int getRowCount() {
        return this.workingResultSet.size();
    }

    public Object getGroupKey(int iGroupIndex, String sExpressionKey, String aggExp) {
        int iRow;
        int iColumnIndex = this.htLookup.findIndex(sExpressionKey, aggExp);
        if (iColumnIndex < 0) {
            return "";
        }
        int n = iRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        if (iRow >= 0 && iRow < this.workingResultSet.size()) {
            return ((Object[])this.workingResultSet.get(iRow))[iColumnIndex];
        }
        return null;
    }

    public Object getGroupKey(int iGroupIndex, int iColumnIndex) {
        int iRow;
        int n = iRow = iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1];
        if (iRow >= 0 && iRow < this.workingResultSet.size()) {
            return ((Object[])this.workingResultSet.get(iRow))[iColumnIndex];
        }
        return null;
    }

    public ResultSetDataSet getSubset(int iGroupIndex, String sExpressionKey, String aggExp) {
        return new ResultSetDataSet(this, new int[]{this.htLookup.findIndex(sExpressionKey, aggExp)}, iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex >= this.iaGroupBreaks.length - 1 ? this.getRowCount() : this.iaGroupBreaks[iGroupIndex]);
    }

    public ResultSetDataSet getSubset(int iGroupIndex, EList elExpressionKeys, String aggExp) {
        int n = elExpressionKeys.size();
        String[] sExpressionKey = new String[n];
        int i = 0;
        while (i < n) {
            sExpressionKey[i] = ((Query)elExpressionKeys.get(i)).getDefinition();
            ++i;
        }
        int[] iaColumnIndexes = this.htLookup.findBatchIndex(sExpressionKey, aggExp);
        return new ResultSetDataSet(this, iaColumnIndexes, iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex > this.iaGroupBreaks.length - 1 ? this.getRowCount() : this.iaGroupBreaks[iGroupIndex]);
    }

    public ResultSetDataSet getSubset(int iGroupIndex, String[] sExpressionKeys, String aggExp, boolean isValueSeries) {
        if (sExpressionKeys == null) {
            return null;
        }
        int[] iaColumnIndexes = this.htLookup.findBatchIndex(sExpressionKeys, aggExp);
        if (isValueSeries) {
            return new VSResultSetDataSet(this, iaColumnIndexes, iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex > this.iaGroupBreaks.length - 1 ? this.getRowCount() : this.iaGroupBreaks[iGroupIndex]);
        }
        return new ResultSetDataSet(this, iaColumnIndexes, iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex > this.iaGroupBreaks.length - 1 ? this.getRowCount() : this.iaGroupBreaks[iGroupIndex]);
    }

    public ResultSetDataSet getSubset(int iGroupIndex, int iColumnIndex) {
        return new ResultSetDataSet(this, new int[]{iColumnIndex}, iGroupIndex <= 0 ? 0 : this.iaGroupBreaks[iGroupIndex - 1], iGroupIndex >= this.iaGroupBreaks.length ? this.getRowCount() : this.iaGroupBreaks[iGroupIndex]);
    }

    public ResultSetDataSet getSubset(EList elExpressions, String aggExp) throws ChartException {
        int n = elExpressions.size();
        String[] sExpression = new String[n];
        int i = 0;
        while (i < n) {
            sExpression[i] = ((Query)elExpressions.get(i)).getDefinition();
            ++i;
        }
        int[] iaColumnIndexes = this.htLookup.findBatchIndex(sExpression, aggExp);
        return new ResultSetDataSet(this, iaColumnIndexes, 0L, this.getRowCount());
    }

    public ResultSetDataSet getSubset(String sExpressionKey, String aggExp) {
        return new ResultSetDataSet(this, new int[]{this.htLookup.findIndex(sExpressionKey, aggExp)}, 0L, this.getRowCount());
    }

    public ResultSetDataSet getSubset(String[] sExpressionKeys, String aggExp, boolean isValueSeries) throws ChartException {
        if (sExpressionKeys == null) {
            return null;
        }
        int[] iaColumnIndexes = this.htLookup.findBatchIndex(sExpressionKeys, aggExp);
        if (isValueSeries) {
            return new VSResultSetDataSet(this, iaColumnIndexes, 0L, this.getRowCount());
        }
        return new ResultSetDataSet(this, iaColumnIndexes, 0L, this.getRowCount());
    }

    public ResultSetDataSet getSubset(int iColumnIndex) {
        return new ResultSetDataSet(this, new int[]{iColumnIndex}, 0L, this.getRowCount());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public Object[] getMergedGroupingBaseValues(int iColumnIndex, SortOption sorting, boolean isCategory) {
        groupCount = this.getGroupCount();
        idxList = new ArrayList<ArrayList<E>>(groupCount);
        baseValue = new ArrayList<Object>();
        k = 0;
        while (k < groupCount) {
            block21: {
                rsd = this.getSubset(k, iColumnIndex);
                idx = new ArrayList<Integer>();
                if (k != 0) ** GOTO lbl73
                i = 0;
                while (rsd.hasNext()) {
                    oValue = rsd.next()[0];
                    baseValue.add(oValue);
                    idx.add(i++);
                }
                break block21;
lbl-1000:
                // 1 sources

                {
                    oValue = rsd.next()[0];
                    matched = false;
                    insertPoint = -1;
                    size = sorting != null || isCategory != false ? baseValue.size() : 0;
                    j = 0;
                    while (j < size) {
                        ov = baseValue.get(j);
                        cprt = ResultSetWrapper.compareObjects(oValue, ov);
                        if (cprt == 0) {
                            if (!idx.contains(j)) {
                                idx.add(j);
                                matched = true;
                                break;
                            }
                            if (sorting != null) {
                                insertPoint = j + 1;
                            }
                        } else if (cprt < 0) {
                            if (sorting == SortOption.DESCENDING_LITERAL) {
                                insertPoint = j + 1;
                            }
                        } else if (cprt > 0 && sorting == SortOption.ASCENDING_LITERAL) {
                            insertPoint = j + 1;
                        }
                        ++j;
                    }
                    if (matched) continue;
                    if (sorting != null && insertPoint == -1) {
                        insertPoint = 0;
                    }
                    if (insertPoint == -1 || insertPoint >= baseValue.size()) {
                        baseValue.add(oValue);
                        idx.add(baseValue.size() - 1);
                        continue;
                    }
                    baseValue.add(insertPoint, oValue);
                    i = 0;
                    while (i < idx.size()) {
                        x = (Integer)idx.get(i);
                        if (x >= insertPoint) {
                            idx.set(i, x + 1);
                        }
                        ++i;
                    }
                    idx.add(insertPoint);
                    for (List gidx : idxList) {
                        i = 0;
                        while (i < gidx.size()) {
                            x = (Integer)gidx.get(i);
                            if (x >= insertPoint) {
                                gidx.set(i, x + 1);
                            }
                            ++i;
                        }
                    }
lbl73:
                    // 4 sources

                    ** while (rsd.hasNext())
                }
            }
            idxList.add(idx);
            ++k;
        }
        maxLen = baseValue.size();
        for (List lst : idxList) {
            if (lst.size() >= maxLen) continue;
            inc = maxLen - lst.size();
            i = 0;
            while (i < inc) {
                lst.add(-1);
                ++i;
            }
        }
        return new Object[]{baseValue, idxList};
    }

    public int getColumnDataType(int iColumnIndex) {
        return this.iaDataTypes[iColumnIndex];
    }

    public Iterator iterator() {
        if (this.workingResultSet != null) {
            return this.workingResultSet.iterator();
        }
        return null;
    }

    private int[] findGroupBreaks(List resultSet, GroupKey groupKey, Query query) {
        Object oValue;
        if (groupKey == null || groupKey.getKey() == null) {
            return NO_GROUP_BREAKS;
        }
        boolean groupingIntervalEnabled = false;
        if (query != null && query.getGrouping() != null) {
            groupingIntervalEnabled = true;
        }
        GroupKey newGroupKey = groupKey;
        if (groupingIntervalEnabled && groupKey.getDirection() == null) {
            newGroupKey = new GroupKey(groupKey.getKey(), SortOption.ASCENDING_LITERAL);
            newGroupKey.setKeyIndex(groupKey.getKeyIndex());
        }
        Collections.sort(resultSet, new TupleComparator(new GroupKey[]{newGroupKey}));
        int iColumnIndex = newGroupKey.getKeyIndex();
        ArrayList<Integer> alBreaks = new ArrayList<Integer>(8);
        boolean bFirst = true;
        Object oPreviousValue = null;
        int iRowIndex = 0;
        if (groupingIntervalEnabled && query != null) {
            SeriesGrouping seriesGrouping = query.getGrouping();
            this.resetGroupedData(resultSet, iColumnIndex, seriesGrouping);
            Iterator it = resultSet.iterator();
            int intervalCount = 0;
            int lastGroupIndex = 0;
            double groupInterval = seriesGrouping.getGroupingInterval();
            while (it.hasNext()) {
                oValue = ((Object[])it.next())[iColumnIndex];
                if (oValue == null) continue;
                ++iRowIndex;
                if (bFirst) {
                    bFirst = false;
                    oPreviousValue = oValue;
                    if (seriesGrouping.getGroupType() != DataType.NUMERIC_LITERAL) continue;
                    lastGroupIndex = (int)Math.floor(Math.abs((((Number)oValue).doubleValue() - 0.0) / groupInterval));
                    continue;
                }
                if (ResultSetWrapper.compareObjects(oPreviousValue, oValue, seriesGrouping) != 0) {
                    if (seriesGrouping.getGroupType() == DataType.NUMERIC_LITERAL) {
                        if (groupInterval == 0.0) {
                            alBreaks.add(iRowIndex - 1);
                        } else {
                            int groupIndex = (int)Math.floor(Math.abs((((Number)oValue).doubleValue() - 0.0) / groupInterval));
                            if (lastGroupIndex != groupIndex) {
                                alBreaks.add(iRowIndex - 1);
                            }
                            lastGroupIndex = groupIndex;
                        }
                    } else if (seriesGrouping.getGroupType() == DataType.DATE_TIME_LITERAL) {
                        int cunit = GroupingUtil.groupingUnit2CDateUnit(seriesGrouping.getGroupingUnit());
                        double diff = CDateTime.computeDifference(((CDateTime)((Object)oValue)).getUnitStart(cunit), ((CDateTime)((Object)oPreviousValue)).getUnitStart(cunit), cunit, true);
                        if (diff != 0.0) {
                            int groupingInterval = (int)seriesGrouping.getGroupingInterval();
                            if (groupingInterval == 0) {
                                alBreaks.add(iRowIndex - 1);
                            } else if ((int)Math.floor(Math.abs(diff / (double)groupingInterval)) > 0) {
                                alBreaks.add(iRowIndex - 1);
                            }
                        }
                    } else if (seriesGrouping.getGroupingUnit() == GroupingUnitType.STRING_PREFIX_LITERAL) {
                        alBreaks.add(iRowIndex - 1);
                    } else if (intervalCount == (int)seriesGrouping.getGroupingInterval()) {
                        alBreaks.add(iRowIndex - 1);
                        intervalCount = 0;
                    } else {
                        ++intervalCount;
                    }
                }
                oPreviousValue = oValue;
            }
        } else {
            Iterator it = resultSet.iterator();
            while (it.hasNext()) {
                oValue = ((Object[])it.next())[iColumnIndex];
                ++iRowIndex;
                if (bFirst) {
                    bFirst = false;
                    oPreviousValue = oValue;
                    continue;
                }
                if (ResultSetWrapper.compareObjects(oPreviousValue, oValue) != 0) {
                    alBreaks.add(iRowIndex - 1);
                }
                oPreviousValue = oValue;
            }
        }
        int[] ia = new int[alBreaks.size()];
        int i = 0;
        while (i < alBreaks.size()) {
            ia[i] = (Integer)alBreaks.get(i);
            ++i;
        }
        return ia;
    }

    private void resetGroupedData(List resultSet, int columnIndex, SeriesGrouping seriesGrouping) {
        if (seriesGrouping.getGroupType() == DataType.DATE_TIME_LITERAL) {
            CDateTime baseReference = null;
            for (Object[] oaTuple : resultSet) {
                Object obj = oaTuple[columnIndex];
                baseReference = obj instanceof CDateTime ? (CDateTime)((Object)obj) : new CDateTime(0L);
                oaTuple[columnIndex] = baseReference;
            }
        }
    }

    public static int compareObjects(Object obja, Object objb, SeriesGrouping sg) {
        Object a = obja;
        Object b = objb;
        if (a == null && b == null) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        DataType type = sg.getGroupType();
        if (type == DataType.TEXT_LITERAL) {
            a = GroupingUtil.getGroupedString((String)a, sg.getGroupingUnit(), (int)sg.getGroupingInterval());
            b = GroupingUtil.getGroupedString((String)b, sg.getGroupingUnit(), (int)sg.getGroupingInterval());
        }
        if (a instanceof String) {
            int iC = a.toString().compareTo(b.toString());
            if (iC != 0) {
                iC = iC < 0 ? -1 : 1;
            }
            return iC;
        }
        if (a instanceof Number) {
            double d2;
            double d1 = ((Number)a).doubleValue();
            return d1 == (d2 = ((Number)b).doubleValue()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Date) {
            long d2;
            long d1 = ((Date)a).getTime();
            return d1 == (d2 = ((Date)b).getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Calendar) {
            long d2;
            long d1 = ((Calendar)a).getTime().getTime();
            return d1 == (d2 = ((Calendar)b).getTime().getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        return ResultSetWrapper.compareObjects(a.toString(), b.toString());
    }

    public static int compareObjects(Object a, Object b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a != null && b == null) {
            return 1;
        }
        if (a instanceof String) {
            int iC = a.toString().compareTo(b.toString());
            if (iC != 0) {
                iC = iC < 0 ? -1 : 1;
            }
            return iC;
        }
        if (a instanceof Number) {
            double d2;
            double d1 = ((Number)a).doubleValue();
            return d1 == (d2 = ((Number)b).doubleValue()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Date) {
            long d2;
            long d1 = ((Date)a).getTime();
            return d1 == (d2 = ((Date)b).getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        if (a instanceof Calendar) {
            long d2;
            long d1 = ((Calendar)a).getTime().getTime();
            return d1 == (d2 = ((Calendar)b).getTime().getTime()) ? 0 : (d1 < d2 ? -1 : 1);
        }
        return ResultSetWrapper.compareObjects(a.toString(), b.toString());
    }

    private Collator createCollator(SeriesDefinition sd) {
        if (sd.isSetSortStrength() && sd.getSortStrength() < 0) {
            return null;
        }
        Collator c = null;
        c = sd.getSortLocale() != null ? Collator.getInstance((ULocale)new ULocale(sd.getSortLocale())) : Collator.getInstance();
        if (sd.isSetSortStrength()) {
            c.setStrength(sd.getSortStrength());
        }
        return c;
    }

    static final class GroupingSorter
    implements Comparator {
        private int iSortIndex;
        private boolean ascending;
        private Collator collator;

        GroupingSorter() {
        }

        void sort(List resultSet, int iSortIndex, SortOption so, int[] groupBreaks, Collator collator) {
            if (so == null) {
                return;
            }
            this.iSortIndex = iSortIndex;
            this.ascending = so == SortOption.ASCENDING_LITERAL;
            this.collator = collator;
            if (groupBreaks == null || groupBreaks.length == 0) {
                Collections.sort(resultSet, this);
            } else {
                int totalCount = resultSet.size();
                int startGroupIndex = 0;
                ArrayList tmpList = new ArrayList();
                int i = 0;
                while (i <= groupBreaks.length) {
                    int endGroupIndex = i == groupBreaks.length ? totalCount : groupBreaks[i];
                    tmpList.clear();
                    int j = startGroupIndex;
                    while (j < endGroupIndex) {
                        tmpList.add(resultSet.get(j));
                        ++j;
                    }
                    Collections.sort(tmpList, this);
                    int k = 0;
                    while (k < tmpList.size()) {
                        resultSet.set(startGroupIndex + k, tmpList.get(k));
                        ++k;
                    }
                    startGroupIndex = endGroupIndex;
                    ++i;
                }
            }
        }

        public final int compare(Object o1, Object o2) {
            Object[] oaTuple1 = (Object[])o1;
            Object[] oaTuple2 = (Object[])o2;
            Object oC1 = oaTuple1[this.iSortIndex];
            Object oC2 = oaTuple2[this.iSortIndex];
            if (oC1 == null && oC2 == null) {
                return 0;
            }
            if (oC1 == null && oC2 != null) {
                return this.ascending ? -1 : 1;
            }
            if (oC1 != null && oC2 == null) {
                return this.ascending ? 1 : -1;
            }
            int ct = oC1 instanceof String ? (this.collator == null ? ((String)oC1).compareTo((String)oC2) : this.collator.compare(oC1.toString(), oC2.toString())) : ((Comparable)oC1).compareTo(oC2);
            return this.ascending ? ct : -ct;
        }
    }

    private static class YGroupingSorter
    implements Comparator {
        private boolean ascending;
        private Collator collator;

        private YGroupingSorter() {
        }

        void sort(List aggregateData, SortOption so, Collator collator) {
            if (so == null) {
                return;
            }
            this.ascending = so == SortOption.ASCENDING_LITERAL;
            this.collator = collator;
            Collections.sort(aggregateData, this);
        }

        public final int compare(Object o1, Object o2) {
            Object obj1 = ((Object[])o1)[2];
            Object obj2 = ((Object[])o2)[2];
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return this.ascending ? -1 : 1;
            }
            if (obj1 != null && obj2 == null) {
                return this.ascending ? 1 : -1;
            }
            int ct = obj1 instanceof String ? (this.collator == null ? ((String)obj1).compareTo((String)obj2) : this.collator.compare(obj1.toString(), obj2.toString())) : ((Comparable)obj1).compareTo(obj2);
            return this.ascending ? ct : -ct;
        }
    }
}

