/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Persons;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.GearModel;
import fr.ifremer.tutti.service.referential.GearRow;
import fr.ifremer.tutti.service.referential.PersonModel;
import fr.ifremer.tutti.service.referential.PersonRow;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.SpeciesModel;
import fr.ifremer.tutti.service.referential.SpeciesRow;
import fr.ifremer.tutti.service.referential.VesselModel;
import fr.ifremer.tutti.service.referential.VesselRow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialImportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialImportService.class);
    protected PersistenceService persistenceService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferentialImportResult<Species> importTemporarySpecies(File file) throws IOException {
        ReferentialImportResult<Species> result = new ReferentialImportResult<Species>();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import species from file: " + file));
        }
        List<Species> allSpecies = this.persistenceService.getAllSpecies();
        HashSet existingSpeciesNames = Sets.newHashSet((Iterable)Iterables.transform(allSpecies, (Function)new Function<Species, String>(){

            public String apply(Species input) {
                return input.getName();
            }
        }));
        Map existingSpeciesById = TuttiEntities.splitByIdAsInt(allSpecies);
        HashSet existingSpeciesIds = new HashSet(existingSpeciesById.keySet());
        ArrayList toAdd = Lists.newArrayList();
        ArrayList toUpdate = Lists.newArrayList();
        ArrayList toDelete = Lists.newArrayList();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        SpeciesModel csvModel = new SpeciesModel(this.getCsvSeparator());
        try {
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (SpeciesRow bean : importer) {
                    Integer id = bean.getIdAsInt();
                    String name = bean.getName();
                    Species species = (Species)existingSpeciesById.get(id);
                    boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
                    if (id != null && existingSpeciesIds.add(id)) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.notExistingId.error", (Object[])new Object[]{id}));
                    }
                    if (StringUtils.isBlank((CharSequence)name)) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.noName.error", (Object[])new Object[]{id}));
                    }
                    if (!(delete || existingSpeciesNames.add(name) || id != null && (species == null || species.getName().equals(name)))) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.existingName.error", (Object[])new Object[]{name}));
                    }
                    if (delete) {
                        if (id == null) {
                            throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.cannotDeleteWithoutId.error", (Object[])new Object[0]));
                        }
                        if (this.persistenceService.isTemporarySpeciesUsed(id)) {
                            throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.species.used.error", (Object[])new Object[]{id}));
                        }
                        toDelete.add(species.getReferenceTaxonId());
                        existingSpeciesNames.remove(name);
                        continue;
                    }
                    if (bean.getId() == null) {
                        toAdd.add(bean);
                        continue;
                    }
                    bean.setReferenceTaxonId(species.getReferenceTaxonId());
                    toUpdate.add(bean);
                }
                importer.close();
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw new IOException(I18n.t((String)"tutti.service.referential.import.species.error", (Object[])new Object[]{file}), e);
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        this.persistenceService.deleteTemporarySpecies(toDelete, true);
        result.setNbRefDeleted(toDelete.size());
        result.addAllRefsAdded(this.persistenceService.importTemporarySpecies(toAdd));
        result.addAllRefsUpdated(this.persistenceService.importTemporarySpecies(toUpdate));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferentialImportResult<Vessel> importTemporaryVessel(File file) throws IOException {
        ReferentialImportResult<Vessel> result = new ReferentialImportResult<Vessel>();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import vessels from file: " + file));
        }
        ArrayList existingVessels = Lists.newArrayList(this.persistenceService.getAllFishingVessel());
        existingVessels.addAll(this.persistenceService.getAllScientificVessel());
        HashSet existingVesselInternationalRegistrationCodes = Sets.newHashSet((Iterable)Iterables.transform((Iterable)existingVessels, (Function)new Function<Vessel, String>(){

            public String apply(Vessel input) {
                return input.getInternationalRegistrationCode();
            }
        }));
        Map existingVesselsById = TuttiEntities.splitById((Iterable)existingVessels);
        HashSet existingVesselIds = new HashSet(existingVesselsById.keySet());
        ArrayList toAdd = Lists.newArrayList();
        ArrayList toUpdate = Lists.newArrayList();
        ArrayList toDelete = Lists.newArrayList();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        VesselModel csvModel = new VesselModel(this.getCsvSeparator());
        try {
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (VesselRow bean : importer) {
                    String id = StringUtils.trimToNull((String)bean.getId());
                    String internationalRegistrationCode = bean.getInternationalRegistrationCode();
                    Vessel vessel = (Vessel)existingVesselsById.get(id);
                    boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
                    if (id != null && existingVesselIds.add(id)) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.notExistingId.error", (Object[])new Object[]{id}));
                    }
                    if (StringUtils.isBlank((CharSequence)internationalRegistrationCode)) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.noInternationalRegistrationCode.error", (Object[])new Object[]{id}));
                    }
                    if (!(delete || existingVesselInternationalRegistrationCodes.add(internationalRegistrationCode) || id != null && (vessel == null || vessel.getRegistrationCode().equals(internationalRegistrationCode)))) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.existingInternationalRegistrationCode.error", (Object[])new Object[]{internationalRegistrationCode}));
                    }
                    if (delete) {
                        if (id == null) {
                            throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.cannotDeleteWithoutId.error", (Object[])new Object[0]));
                        }
                        if (this.persistenceService.isTemporaryVesselUsed(id)) {
                            throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.vessel.used.error", (Object[])new Object[]{id}));
                        }
                        toDelete.add(id);
                        existingVesselInternationalRegistrationCodes.remove(internationalRegistrationCode);
                        continue;
                    }
                    if (id == null) {
                        toAdd.add(bean);
                        continue;
                    }
                    toUpdate.add(bean);
                }
                importer.close();
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw new IOException(I18n.t((String)"tutti.service.referential.import.vessels.error", (Object[])new Object[]{file}), e);
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        this.persistenceService.deleteTemporaryVessels(toDelete, true);
        result.setNbRefDeleted(toDelete.size());
        result.addAllRefsAdded(this.persistenceService.importTemporaryVessel(toAdd));
        result.addAllRefsUpdated(this.persistenceService.importTemporaryVessel(toUpdate));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferentialImportResult<Person> importTemporaryPerson(File file) throws IOException {
        ReferentialImportResult<Person> result = new ReferentialImportResult<Person>();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import persons from file: " + file));
        }
        List<Person> allPersons = this.persistenceService.getAllPerson();
        HashSet existingPersonFullNames = Sets.newHashSet((Iterable)Iterables.transform(allPersons, (Function)new Function<Person, String>(){

            public String apply(Person input) {
                return ReferentialImportService.this.getPersonFullName(input);
            }
        }));
        Map existingPersonsById = TuttiEntities.splitByIdAsInt(allPersons);
        HashSet existingPersonIds = new HashSet(existingPersonsById.keySet());
        ArrayList toAdd = Lists.newArrayList();
        ArrayList toUpdate = Lists.newArrayList();
        ArrayList toDelete = Lists.newArrayList();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        PersonModel csvModel = new PersonModel(this.getCsvSeparator());
        try {
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (PersonRow bean : importer) {
                    Integer id = bean.getIdAsInt();
                    Person person = (Person)existingPersonsById.get(id);
                    String name = this.getPersonFullName((Person)bean);
                    boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
                    if (id != null && existingPersonIds.add(id)) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.notExistingId.error", (Object[])new Object[]{id}));
                    }
                    if (StringUtils.isBlank((CharSequence)name)) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.noName.error", (Object[])new Object[]{id}));
                    }
                    if (!(delete || existingPersonFullNames.add(name) || id != null && (person == null || person.getName().equals(name)))) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.existingName.error", (Object[])new Object[]{name}));
                    }
                    if (delete) {
                        if (id == null) {
                            throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.cannotDeleteWithoutId.error", (Object[])new Object[0]));
                        }
                        if (this.persistenceService.isTemporaryPersonUsed(id)) {
                            throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.person.used.error", (Object[])new Object[]{id}));
                        }
                        toDelete.add(id);
                        existingPersonFullNames.remove(name);
                        continue;
                    }
                    if (bean.getId() == null) {
                        toAdd.add(bean);
                        continue;
                    }
                    toUpdate.add(bean);
                }
                importer.close();
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw new IOException(I18n.t((String)"tutti.service.referential.import.persons.error", (Object[])new Object[]{file}), e);
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        this.persistenceService.deleteTemporaryPersons(toDelete, true);
        result.setNbRefDeleted(toDelete.size());
        result.addAllRefsAdded(this.persistenceService.importTemporaryPerson(toAdd));
        result.addAllRefsUpdated(this.persistenceService.importTemporaryPerson(toUpdate));
        return result;
    }

    protected String getPersonFullName(Person person) {
        return StringUtils.lowerCase((String)(StringUtils.trimToEmpty((String)person.getFirstName()) + StringUtils.trimToEmpty((String)person.getLastName())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReferentialImportResult<Gear> importTemporaryGear(File file) throws IOException {
        ReferentialImportResult<Gear> result = new ReferentialImportResult<Gear>();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import gears from file: " + file));
        }
        ArrayList<Gear> allGears = new ArrayList<Gear>(this.persistenceService.getAllFishingGear());
        allGears.addAll(this.persistenceService.getAllScientificGear());
        HashSet existingGearNames = Sets.newHashSet((Iterable)Iterables.transform(allGears, (Function)new Function<Gear, String>(){

            public String apply(Gear input) {
                return input.getName();
            }
        }));
        Map existingGearsById = TuttiEntities.splitByIdAsInt(allGears);
        HashSet existingGearIds = new HashSet(existingGearsById.keySet());
        ArrayList toAdd = Lists.newArrayList();
        ArrayList toUpdate = Lists.newArrayList();
        ArrayList toDelete = Lists.newArrayList();
        BufferedReader reader = Files.newReader((File)file, (Charset)Charsets.UTF_8);
        GearModel csvModel = new GearModel(this.getCsvSeparator());
        try {
            Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
            try {
                for (GearRow bean : importer) {
                    Integer id = bean.getIdAsInt();
                    Gear gear = (Gear)existingGearsById.get(id);
                    String name = bean.getName();
                    boolean delete = BooleanUtils.isTrue((Boolean)bean.getToDelete());
                    if (id != null && existingGearIds.add(id)) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.notExistingId.error", (Object[])new Object[]{id}));
                    }
                    if (StringUtils.isBlank((CharSequence)name)) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.noName.error", (Object[])new Object[]{id}));
                    }
                    if (!(delete || existingGearNames.add(name) || id != null && (gear == null || gear.getName().equals(name)))) {
                        throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.existingName.error", (Object[])new Object[]{name}));
                    }
                    if (delete) {
                        if (id == null) {
                            throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.cannotDeleteWithoutId.error", (Object[])new Object[0]));
                        }
                        if (this.persistenceService.isTemporaryGearUsed(id)) {
                            throw new IllegalArgumentException(I18n.t((String)"tutti.service.referential.import.gear.used.error", (Object[])new Object[]{id}));
                        }
                        toDelete.add(id);
                        existingGearNames.remove(name);
                        continue;
                    }
                    if (bean.getId() == null) {
                        toAdd.add(bean);
                        continue;
                    }
                    toUpdate.add(bean);
                }
                importer.close();
            }
            finally {
                IOUtils.closeQuietly((Closeable)importer);
            }
            ((Reader)reader).close();
        }
        catch (IOException e) {
            throw new IOException(I18n.t((String)"tutti.service.referential.import.gears.error", (Object[])new Object[]{file}), e);
        }
        catch (ImportRuntimeException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new ApplicationTechnicalException(message, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        this.persistenceService.deleteTemporaryGears(toDelete, true);
        result.setNbRefDeleted(toDelete.size());
        result.addAllRefsAdded(this.persistenceService.importTemporaryGear(toAdd));
        result.addAllRefsUpdated(this.persistenceService.importTemporaryGear(toUpdate));
        return result;
    }

    public void exportExistingTemporarySpecies(File file) throws IOException {
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllReferentSpecies());
        List<Species> toExport = this.persistenceService.retainTemporarySpeciesList(targetList);
        this.exportTemporarySpecies(file, toExport);
    }

    public void exportTemporarySpeciesExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Species s = Speciess.newSpecies();
        s.setName("Temporary Species name 1");
        toExport.add(s);
        s = Speciess.newSpecies();
        s.setName("Temporary Species name 2");
        toExport.add(s);
        s = Speciess.newSpecies();
        s.setName("Temporary Species name 3");
        toExport.add(s);
        this.exportTemporarySpecies(file, toExport);
    }

    protected void exportTemporarySpecies(File file, List<Species> toExport) throws IOException {
        SpeciesModel csvModel = new SpeciesModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Species, SpeciesRow>(){

            public SpeciesRow apply(Species species) {
                return new SpeciesRow(species);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.species.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportExistingTemporaryVessel(File file) throws IOException {
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllFishingVessel());
        targetList.addAll(this.persistenceService.getAllScientificVessel());
        List<Vessel> toExport = this.persistenceService.retainTemporaryVesselList(targetList);
        this.exportTemporaryVessel(file, toExport);
    }

    public void exportTemporaryVesselExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Vessel v = Vessels.newVessel();
        v.setName("Temporary fishing vessel name 1");
        v.setInternationalRegistrationCode("International registration code F1");
        v.setScientificVessel(false);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setName("Temporary fishing vessel name 2");
        v.setInternationalRegistrationCode("International registration code F2");
        v.setScientificVessel(false);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setName("Temporary scientific vessel name 3");
        v.setInternationalRegistrationCode("International registration code S3");
        v.setScientificVessel(true);
        toExport.add(v);
        v = Vessels.newVessel();
        v.setName("Temporary scientific vessel name 4");
        v.setInternationalRegistrationCode("International registration code S4");
        v.setScientificVessel(true);
        toExport.add(v);
        this.exportTemporaryVessel(file, toExport);
    }

    protected void exportTemporaryVessel(File file, List<Vessel> toExport) throws IOException {
        VesselModel csvModel = new VesselModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Vessel, VesselRow>(){

            public VesselRow apply(Vessel vessel) {
                return new VesselRow(vessel);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.vessel.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportExistingTemporaryPerson(File file) throws IOException {
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllPerson());
        List<Person> toExport = this.persistenceService.retainTemporaryPersonList(targetList);
        this.exportTemporaryPerson(file, toExport);
    }

    public void exportTemporaryPersonExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Person p = Persons.newPerson();
        p.setFirstName("First name 1");
        p.setLastName("Last name 1");
        toExport.add(p);
        p = Persons.newPerson();
        p.setFirstName("First name 2");
        p.setLastName("Last name 2");
        toExport.add(p);
        p = Persons.newPerson();
        p.setFirstName("First name 3");
        p.setLastName("Last name 3");
        toExport.add(p);
        this.exportTemporaryPerson(file, toExport);
    }

    protected void exportTemporaryPerson(File file, List<Person> toExport) throws IOException {
        PersonModel csvModel = new PersonModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Person, PersonRow>(){

            public PersonRow apply(Person person) {
                return new PersonRow(person);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.person.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    public void exportExistingTemporaryGear(File file) throws IOException {
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllFishingGear());
        targetList.addAll(this.persistenceService.getAllScientificGear());
        List<Gear> toExport = this.persistenceService.retainTemporaryGearList(targetList);
        this.exportTemporaryGear(file, toExport);
    }

    public void exportTemporaryGearExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Gear g = Gears.newGear();
        g.setName("Gear fishing name 1");
        g.setLabel("Gear fishing label 1");
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear fishing name 2");
        g.setLabel("Gear fishing label 2");
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear scientific name 3");
        g.setLabel("Gear scientific label 3");
        g.setScientificGear(true);
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear scientific name 4");
        g.setLabel("Gear scientific label 4");
        g.setScientificGear(true);
        toExport.add(g);
        this.exportTemporaryGear(file, toExport);
    }

    protected void exportTemporaryGear(File file, List<Gear> toExport) throws IOException {
        GearModel csvModel = new GearModel(this.getCsvSeparator());
        BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);
        List toExportRows = Lists.transform(toExport, (Function)new Function<Gear, GearRow>(){

            public GearRow apply(Gear gear) {
                return new GearRow(gear);
            }
        });
        try {
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)toExportRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.gear.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }
}

