/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import org.hibernate.internal.jaxb.mapping.orm.JaxbAccessType;
import org.hibernate.internal.jaxb.mapping.orm.JaxbOneToOne;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.PropertyMocker;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

class OneToOneMocker
extends PropertyMocker {
    private JaxbOneToOne oneToOne;

    OneToOneMocker(IndexBuilder indexBuilder, ClassInfo classInfo, EntityMappingsMocker.Default defaults, JaxbOneToOne oneToOne) {
        super(indexBuilder, classInfo, defaults);
        this.oneToOne = oneToOne;
    }

    @Override
    protected String getFieldName() {
        return this.oneToOne.getName();
    }

    @Override
    protected void processExtra() {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.classValue("targetEntity", this.oneToOne.getTargetEntity(), annotationValueList, this.indexBuilder.getServiceRegistry());
        MockHelper.enumValue("fetch", FETCH_TYPE, this.oneToOne.getFetch(), annotationValueList);
        MockHelper.booleanValue("optional", this.oneToOne.isOptional(), annotationValueList);
        MockHelper.booleanValue("orphanRemoval", this.oneToOne.isOrphanRemoval(), annotationValueList);
        MockHelper.stringValue("mappedBy", this.oneToOne.getMappedBy(), annotationValueList);
        MockHelper.cascadeValue("cascade", this.oneToOne.getCascade(), this.isDefaultCascadePersist(), annotationValueList);
        this.create(ONE_TO_ONE, annotationValueList);
        this.parserPrimaryKeyJoinColumnList(this.oneToOne.getPrimaryKeyJoinColumn(), this.getTarget());
        this.parserJoinColumnList(this.oneToOne.getJoinColumn(), this.getTarget());
        this.parserJoinTable(this.oneToOne.getJoinTable(), this.getTarget());
        if (this.oneToOne.getMapsId() != null) {
            this.create(MAPS_ID, MockHelper.stringValueArray("value", this.oneToOne.getMapsId()));
        }
        if (this.oneToOne.isId() != null && this.oneToOne.isId().booleanValue()) {
            this.create(ID);
        }
    }

    @Override
    protected JaxbAccessType getAccessType() {
        return this.oneToOne.getAccess();
    }

    @Override
    protected void setAccessType(JaxbAccessType accessType) {
        this.oneToOne.setAccess(accessType);
    }
}

