/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.vessel.VesselExtendDao;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.VesselTypeId;
import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationLabel;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.persistence.service.referential.ReferentialPersistenceServiceSupport;
import fr.ifremer.tutti.persistence.service.referential.VesselPersistenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.DateType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.springframework.cache.Cache;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service(value="vesselPersistenceService")
public class VesselPersistenceServiceImpl
extends ReferentialPersistenceServiceSupport
implements VesselPersistenceService {
    private static final Log log = LogFactory.getLog(VesselPersistenceServiceImpl.class);
    @Resource(name="vesselExtendDao")
    protected VesselExtendDao vesselExtendDao;
    @Resource(name="locationDao")
    protected LocationExtendDao locationDao;

    @Override
    public List<Vessel> getAllScientificVessel() {
        Iterator<Object[]> list = this.queryListWithStatus("allVessels", "refDate", DateType.INSTANCE, new Date(), "vesselTypeId", IntegerType.INSTANCE, VesselTypeId.SCIENTIFIC_RESEARCH_VESSEL.getValue());
        ArrayList result = Lists.newArrayList();
        Cache vesselByCodeCache = this.cacheService.getCache("vesselByCode");
        while (list.hasNext()) {
            Object[] source = list.next();
            Vessel target = this.loadVessel(source, true);
            result.add(target);
            vesselByCodeCache.put((Object)target.getId(), (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        Iterator<Object[]> list = this.queryListWithStatus("allVessels", "refDate", DateType.INSTANCE, new Date(), "vesselTypeId", IntegerType.INSTANCE, VesselTypeId.FISHING_VESSEL.getValue());
        ArrayList result = Lists.newArrayList();
        Cache vesselByCodeCache = this.cacheService.getCache("vesselByCode");
        while (list.hasNext()) {
            Object[] source = list.next();
            Vessel target = this.loadVessel(source, true);
            target.setScientificVessel(false);
            result.add(target);
            vesselByCodeCache.put((Object)target.getId(), (Object)target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        Iterator<Object[]> source;
        if (log.isDebugEnabled()) {
            log.debug((Object)("get vessel: " + vesselCode));
        }
        Vessel result = (source = this.queryListWithStatus("vessel", "vesselCode", StringType.INSTANCE, vesselCode, "refDate", DateType.INSTANCE, new Date())).hasNext() ? this.loadVessel(source.next(), false) : null;
        return result;
    }

    @Override
    public boolean isTemporaryVesselUsed(String code) {
        boolean result;
        Long count = (Long)this.queryUniqueTyped("countVesselInCruise", "id", StringType.INSTANCE, code);
        boolean bl = result = count > 0L;
        if (!result) {
            count = (Long)this.queryUniqueTyped("countVesselInFishingOperation", "id", StringType.INSTANCE, code);
            boolean bl2 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countVesselInOperationVesselAssociation", "id", StringType.INSTANCE, code);
            boolean bl3 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countVesselInDailyActivityCalendar", "id", StringType.INSTANCE, code);
            boolean bl4 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countVesselInLanding", "id", StringType.INSTANCE, code);
            boolean bl5 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countVesselInFishingtrip", "id", StringType.INSTANCE, code);
            boolean bl6 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countVesselInVesselUseFeatures", "id", StringType.INSTANCE, code);
            boolean bl7 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countVesselInGearUseFeatures", "id", StringType.INSTANCE, code);
            boolean bl8 = result = count > 0L;
        }
        if (!result) {
            count = (Long)this.queryUniqueTyped("countVesselInGearPhysicalFeatures", "id", StringType.INSTANCE, code);
            result = count > 0L;
        }
        return result;
    }

    @Override
    public List<Vessel> importTemporaryVessel(List<Vessel> vessels) {
        ArrayList result = Lists.newArrayList();
        Status status = this.statusDao.load(StatusCode.TEMPORARY.getValue());
        Integer countryLocationId = this.locationDao.getLocationIdByLabelAndLocationLevel(LocationLabel.FRANCE.getValue(), new Integer[]{LocationLevelId.PAYS_ISO3.getValue()});
        if (countryLocationId == null) {
            throw new DataIntegrityViolationException("Default country location not found, with label=" + LocationLabel.FRANCE.getValue());
        }
        for (Vessel source : vessels) {
            source = this.importTemporaryVessel(source, countryLocationId, status);
            result.add(source);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void replaceVessel(Vessel source, Vessel target, boolean delete) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((boolean)Vessels.isTemporary(source));
        Preconditions.checkState((!Vessels.isTemporary(target) ? 1 : 0) != 0);
        String sourceId = source.getId();
        String targetId = target.getId();
        this.queryUpdate("replaceVesselInCruise", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInFishingOperation", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInOperationVesselAssociation", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInDailyActivityCalendar", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInLanding", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInFishingtrip", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInVesselUseFeatures", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInGearUseFeatures", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        this.queryUpdate("replaceVesselInGearPhysicalFeatures", "sourceId", StringType.INSTANCE, sourceId, "targetId", StringType.INSTANCE, targetId);
        if (delete) {
            this.deleteTemporaryVessel(sourceId, false);
        }
    }

    @Override
    public void deleteTemporaryVessels(Collection<String> codes, boolean checkIfUsed) {
        for (String code : codes) {
            this.deleteTemporaryVessel(code, checkIfUsed);
        }
    }

    @Override
    public void deleteTemporaryVessel(String code, boolean checkIfUsed) {
        Preconditions.checkNotNull((Object)code);
        if (!code.startsWith("#TEMP\u00bf")) {
            throw new ApplicationBusinessException(String.format("Can't delete a Vessel with a code %s not beginning with %s.", code, "#TEMP\u00bf"));
        }
        Vessel vessel = this.getVessel(code);
        if (vessel == null) {
            throw new ApplicationBusinessException(String.format("Vessel with code %s does not exists", code));
        }
        this.vesselExtendDao.removeTemporaryVessel(code);
    }

    protected Vessel importTemporaryVessel(Vessel source, Integer registrationLocationId, Status status) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkNotNull((Object)source.getInternationalRegistrationCode());
        Integer vesselTypeId = source.isScientificVessel() ? VesselTypeId.SCIENTIFIC_RESEARCH_VESSEL.getValue() : VesselTypeId.FISHING_VESSEL.getValue();
        fr.ifremer.adagio.core.dao.data.vessel.Vessel target = this.vesselExtendDao.createAsTemporary(null, source.getInternationalRegistrationCode(), registrationLocationId, source.getName(), vesselTypeId, false);
        Vessel result = Vessels.newVessel();
        result.setId(target.getCode());
        result.setName(source.getName());
        result.setRegistrationCode(source.getRegistrationCode());
        result.setInternationalRegistrationCode(source.getInternationalRegistrationCode());
        result.setScientificVessel(source.isScientificVessel());
        this.setStatus(status, result);
        return result;
    }

    protected Vessel loadVessel(Object[] source, boolean scientificVessel) {
        Vessel target = Vessels.newVessel();
        target.setId((String)source[0]);
        target.setRegistrationCode((String)source[1]);
        target.setInternationalRegistrationCode((String)source[2]);
        target.setName((String)source[3]);
        target.setScientificVessel(scientificVessel);
        this.setStatus((Status)source[4], target);
        return target;
    }
}

