/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.MethodUtilities;
import freemarker.ext.beans.OverloadedFixArgMethods;
import freemarker.ext.beans.OverloadedMethodsSubset;
import freemarker.ext.beans.OverloadedVarargMethods;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.util.Iterator;
import java.util.List;

final class OverloadedMethods {
    private final BeansWrapper wrapper;
    private final OverloadedMethodsSubset fixArgMethods = new OverloadedFixArgMethods();
    private OverloadedMethodsSubset varargMethods;

    OverloadedMethods(BeansWrapper wrapper) {
        this.wrapper = wrapper;
    }

    BeansWrapper getWrapper() {
        return this.wrapper;
    }

    void addMember(Member member) {
        this.fixArgMethods.addMember(member);
        if (MethodUtilities.isVarArgs(member)) {
            if (this.varargMethods == null) {
                this.varargMethods = new OverloadedVarargMethods();
            }
            this.varargMethods.addMember(member);
        }
    }

    MemberAndArguments getMemberAndArguments(List tmArgs) throws TemplateModelException {
        Object memberAndArguments = this.fixArgMethods.getMemberAndArguments(tmArgs, this.wrapper);
        if (memberAndArguments == OverloadedMethodsSubset.NO_SUCH_METHOD) {
            if (this.varargMethods != null) {
                memberAndArguments = this.varargMethods.getMemberAndArguments(tmArgs, this.wrapper);
            }
            if (memberAndArguments == OverloadedMethodsSubset.NO_SUCH_METHOD) {
                throw new TemplateModelException("No compatible overloaded variation was found for the signature deducated from the actual parameter values:\n" + this.getDeducedCallSignature(tmArgs) + "\nThe available overloaded variations are:\n" + this.memberListToString());
            }
        }
        if (memberAndArguments == OverloadedMethodsSubset.AMBIGUOUS_METHOD) {
            throw new TemplateModelException("Multiple compatible overloaded variation was found for the signature deducated from the actual parameter values:\n" + this.getDeducedCallSignature(tmArgs) + "\nThe available overloaded variations are (including non-matching):\n" + this.memberListToString());
        }
        return (MemberAndArguments)memberAndArguments;
    }

    private String memberListToString() {
        boolean hasMethods;
        Iterator fixArgMethodsIter = this.fixArgMethods.getMembers();
        Iterator varargMethodsIter = this.varargMethods != null ? this.varargMethods.getMembers() : null;
        boolean bl = hasMethods = fixArgMethodsIter.hasNext() || varargMethodsIter != null && varargMethodsIter.hasNext();
        if (hasMethods) {
            StringBuffer sb = new StringBuffer();
            while (fixArgMethodsIter.hasNext()) {
                if (sb.length() != 0) {
                    sb.append(",\n");
                }
                sb.append("    ");
                sb.append(this.methodOrConstructorToString((Member)fixArgMethodsIter.next()));
            }
            if (varargMethodsIter != null) {
                while (varargMethodsIter.hasNext()) {
                    if (sb.length() != 0) {
                        sb.append(",\n");
                    }
                    sb.append(this.methodOrConstructorToString((Member)varargMethodsIter.next()));
                }
            }
            return sb.toString();
        }
        return "No members";
    }

    private String getDeducedCallSignature(List arguments) {
        Member firstMember;
        Iterator fixArgMethodsIter = this.fixArgMethods.getMembers();
        if (fixArgMethodsIter.hasNext()) {
            firstMember = (Member)fixArgMethodsIter.next();
        } else {
            Iterator varArgMethods = this.varargMethods != null ? this.varargMethods.getMembers() : null;
            firstMember = varArgMethods != null && varArgMethods.hasNext() ? (Member)varArgMethods.next() : null;
        }
        StringBuffer sb = new StringBuffer();
        if (firstMember != null) {
            if (firstMember instanceof Constructor) {
                sb.append("constructor ");
            } else {
                sb.append("method ");
            }
            sb.append(firstMember.getName());
        } else {
            sb.append("???");
        }
        sb.append('(');
        for (int i = 0; i < arguments.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(ClassUtil.getFTLTypeDescription((TemplateModel)arguments.get(i)));
        }
        sb.append(')');
        return sb.toString();
    }

    private String methodOrConstructorToString(Member member) {
        StringBuffer sb = new StringBuffer();
        String className = ClassUtil.getShortClassName(member.getDeclaringClass());
        if (className != null) {
            sb.append(className);
            sb.append('.');
        }
        sb.append(member.getName());
        sb.append('(');
        Class[] paramTypes = MethodUtilities.getParameterTypes(member);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(ClassUtil.getShortClassName(paramTypes[i]));
        }
        sb.append(')');
        return sb.toString();
    }
}

