/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtil {
    public static String getLocalHostAddress() throws UnknownHostException, SocketException {
        String osName = System.getProperty("os.name");
        if (osName != null && osName.toLowerCase().contains("windows")) {
            return InetAddress.getLocalHost().getHostAddress();
        }
        InetAddress lch = null;
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface i = e.nextElement();
            Enumeration<InetAddress> ie = i.getInetAddresses();
            if (!ie.hasMoreElements() || !(lch = ie.nextElement()).isLoopbackAddress()) break;
        }
        return lch == null ? null : lch.getHostAddress();
    }

    public static String getLocalHostName() throws UnknownHostException, SocketException {
        return InetAddress.getLocalHost().getHostName();
    }
}

