/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;

public final class ODAExtensionElementDefn
extends ExtensionElementDefn {
    private List<IElementPropertyDefn> hidePrivateProps = null;

    public ODAExtensionElementDefn(IElementDefn baseElementDefn) {
        assert (baseElementDefn != null);
        this.name = baseElementDefn.getName();
        this.displayNameKey = (String)baseElementDefn.getDisplayNameKey();
        this.nameConfig.nameOption = 2;
        this.allowExtend = baseElementDefn.canExtend();
        this.extendsFrom = baseElementDefn.getName();
    }

    @Override
    protected void build() throws MetaDataException {
        if (this.isBuilt) {
            return;
        }
        this.buildDefn();
        this.buildProperties();
        this.buildPrivateDriverProperties();
        this.buildPropertiesVisibility();
        this.buildContainerProperties();
        this.buildXmlName();
        this.buildTriggerDefnSet();
        this.isBuilt = true;
    }

    @Override
    protected void buildXmlName() {
        String tmpXmlName = null;
        ElementDefn tmpDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("OdaDataSet");
        if (this.isKindOf(tmpDefn)) {
            tmpXmlName = tmpDefn.getXmlName();
        } else {
            tmpDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement("OdaDataSource");
            if (this.isKindOf(tmpDefn)) {
                tmpXmlName = tmpDefn.getXmlName();
            }
        }
        this.setXmlName(tmpXmlName);
    }

    private void buildPrivateDriverProperties() {
        if (this.propVisibilites == null) {
            return;
        }
        for (String propName : this.propVisibilites.keySet()) {
            Integer visibility;
            IElementPropertyDefn propDefn = (IElementPropertyDefn)this.cachedProperties.get(propName);
            if (propDefn.getValueType() != 4 || ((visibility = (Integer)this.propVisibilites.get(propName)) & 1) == 0) continue;
            if (this.hidePrivateProps == null) {
                this.hidePrivateProps = new ArrayList<IElementPropertyDefn>();
            }
            this.hidePrivateProps.add((IElementPropertyDefn)this.cachedProperties.get(propName));
            this.cachedProperties.remove(propName);
            this.properties.remove(propName);
        }
        if (this.hidePrivateProps != null) {
            int i = 0;
            while (i < this.hidePrivateProps.size()) {
                String propName = this.hidePrivateProps.get(i).getName();
                this.propVisibilites.remove(propName);
                ++i;
            }
        }
    }

    public List<String> getODAPrivateDriverPropertyNames() {
        if (this.hidePrivateProps == null) {
            return Collections.emptyList();
        }
        ArrayList<String> retList = new ArrayList<String>();
        int i = 0;
        while (i < this.hidePrivateProps.size()) {
            IElementPropertyDefn propDefn = this.hidePrivateProps.get(i);
            retList.add(propDefn.getName());
            ++i;
        }
        return Collections.unmodifiableList(retList);
    }
}

