/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import org.eclipse.birt.report.engine.internal.document.ExtensionSegment;

public class DocumentExtension {
    long index = -1L;
    long parent = -1L;
    long firstChild = -1L;
    long lastChild = -1L;
    long previous = -1L;
    long next = -1L;
    long contentId = -1L;
    long firstChildId;
    long lastChildId;
    ExtensionSegment head = null;
    ExtensionSegment latest = null;

    public DocumentExtension(long index) {
        this.index = index;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public long getFirstChild() {
        return this.firstChild;
    }

    public void setFirstChild(long firstChild) {
        this.firstChild = firstChild;
    }

    public long getNext() {
        return this.next;
    }

    public void setNext(long next) {
        this.next = next;
    }

    public long getParent() {
        return this.parent;
    }

    public void setParent(long parent) {
        this.parent = parent;
    }

    public long getPrevious() {
        return this.previous;
    }

    public void setPrevious(long previous) {
        this.previous = previous;
    }

    public long getContentId() {
        return this.contentId;
    }

    public void setContentId(long contentId) {
        this.contentId = contentId;
    }

    public void add(DocumentExtension ext) {
        ext.setParent(this.index);
        if (this.firstChild == -1L) {
            this.updateFirstChild(ext);
            this.lastChild = this.firstChild;
            this.lastChildId = this.firstChildId;
            return;
        }
        if (this.head == null) {
            if (ext.contentId == this.lastChildId + 1L) {
                ext.setPrevious(this.lastChild);
                ext.setNext(-1L);
                this.lastChild = ext.index;
                this.lastChildId = ext.contentId;
            } else {
                this.head = new ExtensionSegment(this.firstChildId, this.firstChild, this.lastChildId, this.lastChild);
                this.insert(ext);
            }
        } else if (this.latest != null && ext.contentId == this.latest.endId + 1L) {
            ext.setPrevious(this.latest.endIndex);
            if (this.latest.next != null) {
                ext.setNext(this.latest.next.startIndex);
            } else {
                ext.setNext(-1L);
            }
            this.latest.endId = ext.contentId;
            this.latest.endIndex = ext.index;
        } else {
            this.insert(ext);
        }
    }

    private void updateFirstChild(DocumentExtension ext) {
        this.firstChild = ext.index;
        this.firstChildId = ext.contentId;
    }

    private void insert(DocumentExtension ext) {
        ExtensionSegment newSeg;
        ExtensionSegment current = this.head;
        while (true) {
            if (ext.contentId < current.startId - 1L) {
                ExtensionSegment newSeg2 = new ExtensionSegment(ext);
                newSeg2.next = current;
                newSeg2.prev = current.prev;
                if (current.prev != null) {
                    current.prev.next = newSeg2;
                } else {
                    this.head = newSeg2;
                }
                current.prev = newSeg2;
                if (newSeg2.prev != null) {
                    ext.setPrevious(newSeg2.prev.endIndex);
                    ext.setNext(current.startIndex);
                } else {
                    ext.setPrevious(-1L);
                    ext.setNext(this.firstChild);
                    this.updateFirstChild(ext);
                }
                this.latest = newSeg2;
                return;
            }
            if (ext.contentId == current.startId - 1L) {
                if (current.prev != null) {
                    ext.setPrevious(current.prev.endIndex);
                    ext.setNext(current.startIndex);
                } else {
                    ext.setPrevious(-1L);
                    ext.setNext(this.firstChild);
                    this.updateFirstChild(ext);
                }
                current.appendBefore(ext);
                return;
            }
            if (ext.contentId == current.endId + 1L) {
                ext.setPrevious(current.endIndex);
                if (current.next != null) {
                    ext.setNext(current.next.startIndex);
                } else {
                    ext.setNext(-1L);
                }
                current.appendAfter(ext);
                this.latest = current;
                return;
            }
            if (current.next == null) break;
            current = current.next;
        }
        assert (ext.contentId > current.endId + 1L);
        ext.setPrevious(current.endIndex);
        ext.setNext(-1L);
        current.next = newSeg = new ExtensionSegment(ext);
        newSeg.next = null;
        newSeg.prev = current;
        this.latest = newSeg;
    }
}

