/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.ehcache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.DiskStoreConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class EhCacheManagerFactoryBean
implements FactoryBean<CacheManager>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String diskStorePath = null;
    private Resource configLocation;
    private boolean shared = false;
    private String cacheManagerName;
    private CacheManager cacheManager;

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public void setDiskStorePath(String diskStorePath) {
        this.diskStorePath = diskStorePath;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public void afterPropertiesSet() throws IOException, CacheException {
        File diskStore;
        boolean noDiskStoreConfiguration;
        Configuration config = this.configLocation != null ? ConfigurationFactory.parseConfiguration((InputStream)this.configLocation.getInputStream()) : ConfigurationFactory.parseConfiguration();
        DiskStoreConfiguration diskStoreConfiguration = config.getDiskStoreConfiguration();
        boolean bl = noDiskStoreConfiguration = diskStoreConfiguration == null;
        if (noDiskStoreConfiguration) {
            diskStoreConfiguration = new DiskStoreConfiguration();
        }
        if (!(diskStore = new File(this.getDiskStorePath())).isDirectory() || !diskStore.exists()) {
            this.logger.info((Object)("Using EHCache disk store at " + this.getDiskStorePath() + " - directory not exists yet"));
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using EHCache disk store at " + this.getDiskStorePath() + " (replace old config: " + diskStoreConfiguration.getOriginalPath() + ")"));
        }
        diskStoreConfiguration.setPath(this.getDiskStorePath());
        if (noDiskStoreConfiguration) {
            config.addDiskStore(diskStoreConfiguration);
        }
        if (this.cacheManagerName != null) {
            config.setName(this.cacheManagerName);
        }
        this.cacheManager = this.shared ? CacheManager.create((Configuration)config) : new CacheManager(config);
    }

    public CacheManager getObject() {
        return this.cacheManager;
    }

    public Class<? extends CacheManager> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Shutting down EHCache CacheManager");
        this.cacheManager.shutdown();
    }
}

