/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.util.ArrayList;
import java.util.List;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.driver.IEdgeAxis;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.BirtDimensionView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;

public class BirtEdgeView {
    private EdgeCursor edgeCursor;
    private BirtCubeView cubeView;
    private List dimensionViewList;
    private String name;
    private IEdgeDefinition edgeDefn;
    private int pageEndingPosition;
    private int type;
    private IEdgeAxis edgeAxis;
    private static final String CALCULATED_MEMBER = "CALCULATED_MEMBER";

    public BirtEdgeView(BirtCubeView cubeView, IEdgeDefinition edgeDefn, int type) {
        this.cubeView = cubeView;
        this.dimensionViewList = new ArrayList();
        this.edgeDefn = edgeDefn;
        this.pageEndingPosition = -1;
        this.type = type;
        this.populateDimensionView(edgeDefn, cubeView);
        if (edgeDefn != null) {
            this.name = edgeDefn.getName();
        }
    }

    public BirtEdgeView(CalculatedMember calculatedMember) {
        this.pageEndingPosition = -1;
        this.name = CALCULATED_MEMBER + calculatedMember.getRsID();
    }

    private void populateDimensionView(IEdgeDefinition edgeDefn, BirtCubeView cubeView) {
        if (edgeDefn == null) {
            return;
        }
        if (cubeView.getPageEdgeView() != null && this.type != 3) {
            this.dimensionViewList.clear();
            this.dimensionViewList.addAll(cubeView.getPageEdgeView().getDimensionViews());
            this.pageEndingPosition = this.dimensionViewList.size() - 1;
        }
        for (IDimensionDefinition defn : edgeDefn.getDimensions()) {
            this.dimensionViewList.add(new BirtDimensionView(defn));
        }
    }

    public EdgeCursor getEdgeCursor() {
        return this.edgeCursor;
    }

    public List getDimensionViews() {
        return this.dimensionViewList;
    }

    public void setEdgeCursor(EdgeCursor edgeCursor) {
        this.edgeCursor = edgeCursor;
    }

    public void setEdgeAxis(IEdgeAxis edgeAxis) {
        this.edgeAxis = edgeAxis;
    }

    public IEdgeAxis getEdgeAxis() {
        return this.edgeAxis;
    }

    public BirtCubeView getOrdinateOwner() {
        return this.cubeView;
    }

    public IEdgeDefinition getEdgeDefinition() {
        return this.edgeDefn;
    }

    public String getName() {
        return this.name;
    }

    public int getPageEndingIndex() {
        return this.pageEndingPosition;
    }

    public int getEdgeType() {
        return this.type;
    }
}

