/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.export.sumatra.CatchesSumatraExportService;
import fr.ifremer.tutti.service.export.sumatra.SumatraExportResult;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import java.io.File;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;

public class ExportFishingOperationForSumatraAction
extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    private static final Log log = LogFactory.getLog(ExportFishingOperationForSumatraAction.class);
    protected File file;
    protected SumatraExportResult sumatraExportResult;

    public ExportFishingOperationForSumatraAction(EditCatchesUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (((EditCatchesUIModel)this.getModel()).isModify()) {
            this.displayWarningMessage(I18n.t((String)"tutti.exportFishingOperationCsv.title.model.modified", (Object[])new Object[0]), I18n.t((String)"tutti.exportFishingOperationCsv.message.model.modified", (Object[])new Object[0]));
            doAction = false;
        }
        if (doAction && !this.getDataContext().isProtocolFilled()) {
            this.displayWarningMessage(I18n.t((String)"tutti.exportFishingOperationCsv.title.missing.protocol", (Object[])new Object[0]), I18n.t((String)"tutti.exportFishingOperationCsv.message.missing.protocol", (Object[])new Object[0]));
        }
        if (doAction) {
            FishingOperation fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
            String date = DateUtil.formatDate((Date)new Date(), (String)"dd-MM-yyyy");
            this.file = this.saveFile(String.format("sumatra_%s_%s_%s", this.getDataContext().getCruise().getName(), fishingOperation.getId(), date), "csv", I18n.t((String)"tutti.exportFishingOperationCsv.title.choose.exportFile", (Object[])new Object[0]), I18n.t((String)"tutti.exportFishingOperationCsv.action.chooseFile", (Object[])new Object[0]), new String[]{"^.+\\.csv$", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        this.sumatraExportResult = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = this.getDataContext().getCruise();
        FishingOperation fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export fishingOperation " + cruise.getId() + "-" + fishingOperation.getStationNumber() + " to file: " + this.file));
        }
        ProgressionModel pm = new ProgressionModel();
        pm.setTotal(3);
        this.setProgressionModel(pm);
        CatchesSumatraExportService service = this.getContext().getCatchesSumatraExportService();
        this.sumatraExportResult = service.exportFishingOperationForSumatra(this.file, cruise.getId(), fishingOperation.getId(), pm);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        if (this.sumatraExportResult.withBadSpecies()) {
            StringBuilder badSpeciesList = new StringBuilder();
            for (String s : this.sumatraExportResult.getBadSpecies()) {
                badSpeciesList.append("<li>").append(s);
            }
            this.displayWarningMessage(I18n.t((String)"tutti.exportFishingOperationCsv.title.badSpecies", (Object[])new Object[0]), I18n.t((String)"tutti.exportFishingOperationCsv.message.badSpecies", (Object[])new Object[]{badSpeciesList.toString()}));
        }
        if (this.sumatraExportResult.withBadBenthos()) {
            StringBuilder badBenthosList = new StringBuilder();
            for (String s : this.sumatraExportResult.getBadBenthos()) {
                badBenthosList.append("<li>").append(s);
            }
            this.displayWarningMessage(I18n.t((String)"tutti.exportFishingOperationCsv.title.badBenthos", (Object[])new Object[0]), I18n.t((String)"tutti.exportFishingOperationCsv.message.badBenthos", (Object[])new Object[]{badBenthosList.toString()}));
        }
        this.sendMessage(I18n.t((String)"tutti.exportFishingOperationCsv.action.success", (Object[])new Object[]{this.file}));
    }
}

