/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.core.Environment;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;

public class TemplateException
extends Exception {
    private static final boolean BEFORE_1_4 = TemplateException.before14();
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Exception causeException;
    private final transient Environment env;
    private final String ftlInstructionStack;
    static /* synthetic */ Class class$java$lang$Exception;

    private static boolean before14() {
        Class ec = class$java$lang$Exception == null ? (class$java$lang$Exception = TemplateException.class$("java.lang.Exception")) : class$java$lang$Exception;
        try {
            ec.getMethod("getCause", new Class[0]);
        }
        catch (Throwable e) {
            return true;
        }
        return false;
    }

    public TemplateException(Environment env) {
        this(null, null, env);
    }

    public TemplateException(String description, Environment env) {
        this(description, null, env);
    }

    public TemplateException(Exception cause, Environment env) {
        this(null, cause, env);
    }

    public TemplateException(String description, Exception cause, Environment env) {
        super(TemplateException.getDescription(description, cause));
        this.causeException = cause;
        this.env = env;
        if (env != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            env.outputInstructionStack(pw);
            pw.flush();
            this.ftlInstructionStack = sw.toString();
        } else {
            this.ftlInstructionStack = "";
        }
    }

    private static String getDescription(String description, Exception cause) {
        if (description != null) {
            return description;
        }
        if (cause != null) {
            return cause.getClass().getName() + ": " + cause.getMessage();
        }
        return "No error message";
    }

    public Exception getCauseException() {
        return this.causeException;
    }

    public Throwable getCause() {
        return this.causeException;
    }

    public String getFTLInstructionStack() {
        return this.ftlInstructionStack;
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public void printStackTrace(PrintStream ps) {
        PrintWriter pw = new PrintWriter((Writer)new OutputStreamWriter(ps), true);
        this.printStackTrace(pw);
        pw.flush();
    }

    public void printStackTrace(PrintWriter pw) {
        pw.println();
        pw.println(this.getMessage());
        if (this.ftlInstructionStack != null && this.ftlInstructionStack.length() != 0) {
            pw.println("The problematic instruction:");
            pw.println(this.ftlInstructionStack);
        }
        pw.println("Java backtrace for programmers:");
        pw.println("----------");
        super.printStackTrace(pw);
        if (BEFORE_1_4 && this.causeException != null) {
            pw.println("Underlying cause: ");
            this.causeException.printStackTrace(pw);
        }
        try {
            Method m = this.causeException.getClass().getMethod("getRootCause", EMPTY_CLASS_ARRAY);
            Throwable rootCause = (Throwable)m.invoke((Object)this.causeException, EMPTY_OBJECT_ARRAY);
            if (rootCause != null) {
                Throwable j14Cause = null;
                if (!BEFORE_1_4) {
                    m = this.causeException.getClass().getMethod("getCause", EMPTY_CLASS_ARRAY);
                    j14Cause = (Throwable)m.invoke((Object)this.causeException, EMPTY_OBJECT_ARRAY);
                }
                if (j14Cause == null) {
                    pw.println("ServletException root cause: ");
                    rootCause.printStackTrace(pw);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

