/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data;

import java.util.Map;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DataGenerationEngine;
import org.eclipse.birt.report.engine.data.dte.DataInteractiveEngine;
import org.eclipse.birt.report.engine.data.dte.DataPresentationEngine;
import org.eclipse.birt.report.engine.data.dte.DocumentDataSource;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;

public class DataEngineFactory {
    protected static DataEngineFactory sm_instance;

    protected DataEngineFactory() {
    }

    public static synchronized DataEngineFactory getInstance() {
        if (sm_instance == null) {
            sm_instance = new DataEngineFactory();
        }
        return sm_instance;
    }

    public IDataEngine createDataEngine(ExecutionContext context, boolean needCache) throws Exception {
        ReportDocumentWriter writer;
        DocumentDataSource dataSource;
        IReportDocument document = context.getReportDocument();
        if (document != null) {
            String buildNumber = document.getProperty("BIRT ENGINE BUILD NUMBER");
            Map appContext = context.getAppContext();
            if (appContext != null) {
                appContext.put("BIRT ENGINE BUILD NUMBER", buildNumber);
            }
        }
        if ((dataSource = context.getDataSource()) != null) {
            writer = context.getReportDocWriter();
            IDocArchiveWriter archiverWriter = null;
            if (writer != null) {
                archiverWriter = writer.getArchive();
            }
            return new DataInteractiveEngine(this, context, dataSource.getDataSource(), archiverWriter);
        }
        writer = context.getReportDocWriter();
        if (writer != null) {
            return new DataGenerationEngine(this, context, context.getReportDocWriter().getArchive());
        }
        if (document != null) {
            if (context.getEngineTask().getTaskType() == 4) {
                return new DataInteractiveEngine(this, context, context.getReportDocument().getArchive(), null);
            }
            return new DataPresentationEngine(this, context, context.getReportDocument().getArchive(), needCache);
        }
        return new DteDataEngine(this, context, needCache);
    }

    public void closeDataEngine(IDataEngine dataEngine) {
    }
}

