/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.data;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import java.util.ArrayList;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class SampleCategoryModelConverter
implements Converter {
    public Object convert(Class aClass, Object value) {
        Preconditions.checkNotNull((Object)value, (Object)"Can not convert a null SampleCategoryModel");
        if (this.isEnabled(aClass)) {
            if (this.isEnabled(value.getClass())) {
                Object result = value;
                return result;
            }
            if (value instanceof String) {
                ArrayList entries = Lists.newArrayList();
                String strValue = (String)value;
                if (StringUtils.isNotEmpty((CharSequence)strValue)) {
                    String[] entryStrs;
                    for (String entryStr : entryStrs = strValue.split("\\s*\\|\\s*")) {
                        String[] entryParts = entryStr.split("\\s*\\,\\s*");
                        SampleCategoryModelEntry entry = new SampleCategoryModelEntry();
                        entry.setCategoryId(Integer.valueOf(entryParts[0]));
                        if (entryParts.length > 1) {
                            entry.setLabel(entryParts[1]);
                        }
                        entry.setOrder(entries.size());
                        entries.add(entry);
                    }
                }
                SampleCategoryModel result = new SampleCategoryModel(entries);
                return result;
            }
        }
        throw new ConversionException(I18n.t((String)"tutti.persistence.error.no.convertor", (Object[])new Object[]{aClass.getName(), value}));
    }

    protected boolean isEnabled(Class<?> aClass) {
        return SampleCategoryModel.class.equals(aClass);
    }

    public Class<?> getType() {
        return SampleCategoryModel.class;
    }
}

