/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.batch.BatchPersistenceHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service(value="speciesBatchPersistenceService")
public class SpeciesBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements SpeciesBatchPersistenceService {
    private static final Log log = LogFactory.getLog(SpeciesBatchPersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    protected SampleCategoryModel sampleCategoryModel;

    @Override
    public void init() {
        super.init();
        this.sampleCategoryModel = this.config.getSampleCategoryModel();
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(String fishingOperationId, SampleCategoryModel sampleCategoryModel) throws InvalidBatchModelException {
        SortingBatch horsVracSpeciesBatch;
        Preconditions.checkNotNull((Object)fishingOperationId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        SortingBatch vracSpeciesBatch = this.batchHelper.getSortingBatch((Batch)catchBatch, "Vrac > Species > Alive Itemized", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_VRAC_ID, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES, this.enumeration.PMFM_ID_SORTING_TYPE_2, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_2_ALIVE_ITEMIZED);
        BatchContainer<SpeciesBatch> result = new BatchContainer<SpeciesBatch>();
        if (vracSpeciesBatch != null) {
            result.setId(vracSpeciesBatch.getId());
            for (Batch batch : vracSpeciesBatch.getChildBatchs()) {
                Species species;
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Preconditions.checkNotNull((Object)referenceTaxon, (Object)("Can't have a rootSpeciesBatch with a null taxon, but was for " + batch.getId()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading CatchBatch Vrac > Species > Alive Itemized > " + referenceTaxon.getId() + " - " + " (batch:" + source.getId() + ")"));
                }
                if ((species = this.referentialService.getSpeciesByReferenceTaxonId(referenceTaxon.getId())) == null) {
                    throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.batch.validation.unkonwn.taxon", (Object[])new Object[]{source.getId(), referenceTaxon.getId()}));
                }
                SpeciesBatch target = SpeciesBatchs.newSpeciesBatch();
                target.setSpecies(species);
                this.entityToSpeciesBatch(source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Vrac > Species > Alive Itemized > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if ((horsVracSpeciesBatch = this.batchHelper.getSortingBatch((Batch)catchBatch, "Hors Vrac > Species", this.enumeration.PMFM_ID_SORTED_UNSORTED, this.enumeration.QUALITATIVE_HORS_VRAC_ID, this.enumeration.PMFM_ID_SORTING_TYPE, this.enumeration.QUALITATIVE_ID_SORTING_TYPE_SPECIES)) != null) {
            for (Batch batch : horsVracSpeciesBatch.getChildBatchs()) {
                Species species;
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Preconditions.checkNotNull((Object)referenceTaxon, (Object)("Can't have a rootSpeciesBatch with a null taxon, but was for " + source.getId()));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading CatchBatch Hors Vrac > Species > " + referenceTaxon.getId() + " - " + " (batch:" + source.getId() + ")"));
                }
                if ((species = this.referentialService.getSpeciesByReferenceTaxonId(referenceTaxon.getId())) == null) {
                    throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.batch.validation.unkonwn.taxon", (Object[])new Object[]{source.getId(), referenceTaxon.getId()}));
                }
                SpeciesBatch target = SpeciesBatchs.newSpeciesBatch();
                target.setSpecies(species);
                this.entityToSpeciesBatch(source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Hors Vrac > Species > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if (sampleCategoryModel != null) {
            this.batchHelper.validateSpecies(sampleCategoryModel, result);
        }
        return result;
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, String parentBatchId) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getSpecies());
        Preconditions.checkNotNull((Object)bean.getSpecies().getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(bean.getFishingOperation().getId(), false);
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.speciesBatchToEntity(bean, batch, parentBatchId, catchBatch);
        bean = this.batchHelper.createSortingBatch(bean, catchBatch, batch);
        return bean;
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Integer batchId = bean.getIdAsInt();
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(batchId);
        SortingBatch batch = this.batchHelper.getSortingBatchById(catchBatch, batchId);
        String parentBatchId = null;
        if (bean.getParentBatch() != null) {
            parentBatchId = bean.getParentBatch().getId();
        }
        this.speciesBatchToEntity(bean, batch, parentBatchId, catchBatch);
        this.batchHelper.updateSortingBatch(batch, catchBatch);
        return bean;
    }

    @Override
    public void deleteSpeciesBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer batchId = Integer.valueOf(id);
        this.batchHelper.removeWithChildren(batchId);
    }

    @Override
    public void deleteSpeciesSubBatch(String id) {
        Preconditions.checkNotNull((Object)id);
        Integer speciesBatchId = Integer.valueOf(id);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(speciesBatchId);
        SortingBatch sortingBatch = this.batchHelper.getSortingBatchById(catchBatch, speciesBatchId);
        Collection childBatchs = sortingBatch.getChildBatchs();
        if (CollectionUtils.isNotEmpty((Collection)childBatchs)) {
            for (Batch childBatch : childBatchs) {
                Integer childBatchId = childBatch.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete child [" + childBatchId + "] of species batch: " + id));
                }
                this.batchHelper.removeWithChildren(childBatchId);
            }
        }
    }

    @Override
    public void changeSpeciesBatchSpecies(String batchId, Species species) {
        Preconditions.checkNotNull((Object)batchId);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        this.batchHelper.setSortingBatchReferenceTaxon(batchId, species.getReferenceTaxonId());
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(String speciesBatchId) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencies(this.sampleCategoryModel, speciesBatchId);
        ArrayList results = Lists.newArrayList();
        for (SortingBatch child : frequencyChilds) {
            SpeciesBatchFrequency target = SpeciesBatchFrequencys.newSpeciesBatchFrequency();
            this.entityToSpeciesBatchFrequency(child, target);
            results.add(target);
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(String speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        Preconditions.checkNotNull(frequencies);
        ArrayList notNullFrequencies = Lists.newArrayList();
        String pmfmId = null;
        for (SpeciesBatchFrequency source : frequencies) {
            if (source.getLengthStepCaracteristic() == null) continue;
            if (pmfmId == null) {
                pmfmId = source.getLengthStepCaracteristic().getId();
            } else if (!pmfmId.equals(source.getLengthStepCaracteristic().getId())) {
                throw new DataIntegrityViolationException("Batch frequencies under one SpeciesBatch must have all the same lengthStepCaracteristic");
            }
            notNullFrequencies.add(source);
        }
        Integer sortingBatchId = Integer.valueOf(speciesBatchId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(sortingBatchId);
        if (catchBatch == null) {
            return notNullFrequencies;
        }
        SortingBatch parentBatch = this.batchHelper.getSortingBatchById(catchBatch, sortingBatchId);
        ArrayList notUpdatedChildIds = Lists.newArrayList();
        List<SortingBatch> frequencyChilds = this.batchHelper.getFrequencyChilds(this.sampleCategoryModel, parentBatch);
        for (SortingBatch child : frequencyChilds) {
            notUpdatedChildIds.add(child.getId());
        }
        short rankOrder = 0;
        ArrayList batchsToUpdate = Lists.newArrayList();
        for (SpeciesBatchFrequency source : notNullFrequencies) {
            SortingBatch target;
            rankOrder = (short)(rankOrder + 1);
            if (source.getId() == null) {
                target = SortingBatch.Factory.newInstance();
                this.speciesBatchFrequencyToEntity(source, target, parentBatch, rankOrder);
                this.batchHelper.createSortingBatch(source, catchBatch, target);
                source.setId(target.getId());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Create frequency sortingBatch(" + rankOrder + "): " + target.getId()));
                continue;
            }
            target = this.batchHelper.loadSortingBatch(source.getIdAsInt(), catchBatch);
            this.speciesBatchFrequencyToEntity(source, target, parentBatch, rankOrder);
            batchsToUpdate.add(target);
            notUpdatedChildIds.remove(target.getId());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Update frequency sortingBatch(" + rankOrder + "): " + target.getId()));
        }
        if (batchsToUpdate.size() > 0) {
            this.batchHelper.updateSortingBatch(batchsToUpdate, catchBatch);
        }
        if (notUpdatedChildIds.size() > 0) {
            for (Integer batchId : notUpdatedChildIds) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remove obsolete frequency sortingBatch: " + batchId));
                }
                this.batchHelper.removeWithChildren(batchId, catchBatch);
            }
        }
        return Collections.unmodifiableList(notNullFrequencies);
    }

    protected SpeciesBatch entityToSpeciesBatch(SortingBatch source, SpeciesBatch target) {
        QualityFlag qualityFlag;
        boolean isFrequency;
        Preconditions.checkNotNull((Object)target.getSpecies());
        target.setId(source.getId().toString());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        if (source.getWeight() != null && source.getWeightBeforeSampling() == null) {
            target.setSampleCategoryWeight(source.getWeight());
        } else {
            target.setWeight(source.getWeight());
            target.setSampleCategoryWeight(source.getWeightBeforeSampling());
        }
        target.setComment(source.getComments());
        SortingMeasurement sm = null;
        if (source.getSortingMeasurements().size() == 1) {
            sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        } else if (source.getReferenceTaxon() != null && source.getReferenceTaxon().getId() != null) {
            sm = this.batchHelper.getInheritedSortingMeasurement(source);
        }
        if (sm != null && !(isFrequency = this.batchHelper.isFrequencyBatch(this.sampleCategoryModel, source))) {
            Integer qualitativeId = null;
            if (sm.getQualitativeValue() != null) {
                qualitativeId = sm.getQualitativeValue().getId();
            }
            this.setSampleCategoryQualitative(target, sm.getPmfm().getId(), sm.getNumericalValue(), sm.getAlphanumericalValue(), qualitativeId);
        }
        if (target.getSampleCategoryId() != null) {
            ArrayList targetChilds = Lists.newArrayList();
            for (Batch batch : source.getChildBatchs()) {
                SortingBatch sourceChild = (SortingBatch)batch;
                SpeciesBatch targetChild = SpeciesBatchs.newSpeciesBatch();
                targetChild.setSpecies(target.getSpecies());
                this.entityToSpeciesBatch(sourceChild, targetChild);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded CatchBatch (Vrac|Hors Vrac) > Species > " + targetChild.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
                }
                if (targetChild.getSampleCategoryValue() == null) continue;
                targetChilds.add(targetChild);
                targetChild.setParentBatch(target);
            }
            target.setChildBatchs(targetChilds);
        }
        target.setSpeciesToConfirm((qualityFlag = source.getQualityFlag()) != null && this.enumeration.QUALITY_FLAG_CODE_DOUBTFUL.equals(qualityFlag.getCode()));
        return target;
    }

    protected void entityToSpeciesBatchFrequency(SortingBatch source, SpeciesBatchFrequency target) {
        target.setId(source.getId());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        target.setWeight(source.getWeight());
        Preconditions.checkState((source.getSortingMeasurements().size() == 1 ? 1 : 0) != 0, (Object)("SortingBatch [" + source.getId() + "] need exactly one sortingMeasurement (to store the length step category), but had " + source.getSortingMeasurements().size()));
        SortingMeasurement sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        Preconditions.checkNotNull((Object)sm.getPmfm(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a null pmfm"));
        Preconditions.checkNotNull((Object)sm.getPmfm().getId(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a pmfm with null id"));
        Caracteristic lengthStepCaracteristic = this.referentialService.getCaracteristic(sm.getPmfm().getId());
        target.setLengthStepCaracteristic(lengthStepCaracteristic);
        target.setLengthStep(sm.getNumericalValue());
    }

    protected void speciesBatchToEntity(SpeciesBatch source, SortingBatch target, String parentBatchId, CatchBatch catchBatch) {
        Integer pmfmId;
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().toString().equals(parentBatchId)) {
            this.batchHelper.setSpeciesBatchParents(source.getSampleCategoryId(), source.getSampleCategoryValue(), target, parentBatchId, catchBatch);
        }
        if (target.getRankOrder() == null) {
            int maxRankOrder;
            short rankOrder = 1;
            if (source.getParentBatch() != null && source.getParentBatch().getChildBatchs() != null) {
                maxRankOrder = 0;
                for (SpeciesBatch batch : source.getParentBatch().getChildBatchs()) {
                    Integer r = batch.getRankOrder();
                    if (r == null || r <= maxRankOrder) continue;
                    maxRankOrder = r;
                }
                rankOrder = (short)(rankOrder + (short)maxRankOrder);
            } else if (target.getParentBatch() != null && target.getParentBatch().getChildBatchs() != null) {
                maxRankOrder = 0;
                for (Batch batch : target.getParentBatch().getChildBatchs()) {
                    Short r = batch.getRankOrder();
                    if (r == null || r <= maxRankOrder) continue;
                    maxRankOrder = r.shortValue();
                }
                rankOrder = (short)(rankOrder + maxRankOrder);
            }
            target.setRankOrder(Short.valueOf(rankOrder));
        }
        target.setSubgroupCount(Float.valueOf(1.0f));
        if (source.getSampleCategoryWeight() != null && source.getWeight() == null) {
            QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getSampleCategoryWeight());
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        } else if (source.getWeight() != null && source.getSampleCategoryWeight() == null) {
            QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getWeight());
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (source.getSampleCategoryWeight() == null || source.getWeight() == null) {
            target.setSamplingRatio(null);
            target.setSamplingRatioText(null);
        } else {
            String samplingRatioText = source.getWeight() + "/" + source.getSampleCategoryWeight();
            samplingRatioText = samplingRatioText.replaceAll(",", ".");
            target.setSamplingRatioText(samplingRatioText);
            target.setSamplingRatio(Float.valueOf(source.getWeight().floatValue() / source.getSampleCategoryWeight().floatValue()));
            QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getWeight());
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (source.getSampleCategoryId() != null && source.getSampleCategoryValue() != null && !(pmfmId = source.getSampleCategoryId()).equals(this.enumeration.PMFM_ID_SORTED_UNSORTED)) {
            SortingMeasurement sortingMeasurement = this.batchHelper.setSortingMeasurement(target, pmfmId, source.getSampleCategoryValue());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        target.setIndividualCount(source.getNumber());
        ReferenceTaxon referenceTaxon = source.getSpecies() == null || parentBatchId != null ? null : (ReferenceTaxon)this.load(ReferenceTaxonImpl.class, source.getSpecies().getReferenceTaxonId());
        target.setReferenceTaxon(referenceTaxon);
        String qualityFlag = source.isSpeciesToConfirm() ? this.enumeration.QUALITY_FLAG_CODE_DOUBTFUL : this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED;
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)qualityFlag)));
        target.setComments(source.getComment());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    protected void speciesBatchFrequencyToEntity(SpeciesBatchFrequency source, SortingBatch target, SortingBatch parentBatch, short rankOrder) {
        Preconditions.checkNotNull((Object)source.getBatch());
        Preconditions.checkNotNull((Object)source.getBatch().getId());
        Collection quantificationMeasurements = target.getQuantificationMeasurements();
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedQuantificationMeasurements = Sets.newHashSet();
        if (quantificationMeasurements != null) {
            notChangedQuantificationMeasurements.addAll(quantificationMeasurements);
        }
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().equals(parentBatch.getId())) {
            target.setParentBatch((Batch)parentBatch);
            target.setRootBatch(parentBatch.getRootBatch());
        }
        target.setRankOrder(Short.valueOf(rankOrder));
        if (source.getWeight() != null) {
            QuantificationMeasurement quantificationMeasurement = this.batchHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getWeight());
            notChangedQuantificationMeasurements.remove(quantificationMeasurement);
        }
        if (source.getLengthStepCaracteristic() != null && source.getLengthStep() != null) {
            Integer pmfmId = source.getLengthStepCaracteristic().getIdAsInt();
            SortingMeasurement sortingMeasurement = this.batchHelper.setSortingMeasurement(target, pmfmId, source.getLengthStep());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        target.setIndividualCount(source.getNumber());
        target.setReferenceTaxon(null);
        target.setQualityFlag(parentBatch.getQualityFlag());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        if (quantificationMeasurements != null) {
            quantificationMeasurements.removeAll(notChangedQuantificationMeasurements);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    protected void setSampleCategoryQualitative(SpeciesBatch target, Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (pmfmId == null || pmfmId.equals(this.enumeration.PMFM_ID_SORTING_TYPE)) {
            return;
        }
        boolean isSamplingCategory = this.sampleCategoryModel.containsCategoryId(pmfmId);
        Preconditions.checkNotNull((Object)isSamplingCategory, (Object)("Unable to find corresponding SampleCategoryEnum for PMFM.ID : " + pmfmId));
        target.setSampleCategoryId(pmfmId);
        Serializable categoryValue = this.batchHelper.getSampleCategoryQualitative(pmfmId, numericalvalue, alphanumericalValue, qualitativeValueId);
        target.setSampleCategoryValue(categoryValue);
    }
}

