/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.MultiPostExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.io.File;
import org.jdesktop.beans.AbstractBean;

public abstract class AbstractExportMultiPostAction<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractTuttiAction<M, UI, H> {
    protected File file;
    protected FishingOperation currentOperation;
    protected MultiPostExportService multiPostImportExportService = this.getContext().getMultiPostExportService();

    public AbstractExportMultiPostAction(H handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            EditCatchesUI catchesUI = (EditCatchesUI)((TuttiUI)this.getUI()).getParentContainer(EditCatchesUI.class);
            this.currentOperation = catchesUI.getModel().getFishingOperation();
            String extension = this.getFileExtension();
            this.file = this.saveFile(this.decorate(this.currentOperation, "fileNameCompatible"), extension, this.getFileChooserTitle(), this.getFileChooserButton(), new String[]{"^.*\\." + extension, this.getFileExtensionDescription()});
            doAction = this.file != null;
        }
        return doAction;
    }

    protected abstract String getFileExtension();

    protected abstract String getFileExtensionDescription();

    protected abstract String getFileChooserTitle();

    protected abstract String getFileChooserButton();

    public void releaseAction() {
        this.file = null;
        this.currentOperation = null;
        super.releaseAction();
    }
}

