/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.core.DropViewChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.AbstractSqlStatement;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateViewStatement;
import liquibase.statement.core.DropViewStatement;
import liquibase.util.StringUtils;

public class CreateViewChange
extends AbstractChange {
    private String schemaName;
    private String viewName;
    private String selectQuery;
    private Boolean replaceIfExists;

    public CreateViewChange() {
        super("createView", "Create View", 1);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public void setSelectQuery(String selectQuery) {
        this.selectQuery = selectQuery;
    }

    public Boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public void setReplaceIfExists(Boolean replaceIfExists) {
        this.replaceIfExists = replaceIfExists;
    }

    public SqlStatement[] generateStatements(Database database) {
        ArrayList<AbstractSqlStatement> statements = new ArrayList<AbstractSqlStatement>();
        boolean replaceIfExists = false;
        if (this.getReplaceIfExists() != null && this.getReplaceIfExists().booleanValue()) {
            replaceIfExists = true;
        }
        if (!this.supportsReplaceIfExistsOption(database) && replaceIfExists) {
            statements.add(new DropViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName()));
            statements.add(new CreateViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName(), this.getSelectQuery(), false));
        } else {
            statements.add(new CreateViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName(), this.getSelectQuery(), replaceIfExists));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    public String getConfirmationMessage() {
        return "View " + this.getViewName() + " created";
    }

    protected Change[] createInverses() {
        DropViewChange inverse = new DropViewChange();
        inverse.setViewName(this.getViewName());
        inverse.setSchemaName(this.getSchemaName());
        return new Change[]{inverse};
    }

    private boolean supportsReplaceIfExistsOption(Database database) {
        return !(database instanceof SQLiteDatabase) && !(database instanceof MSSQLDatabase);
    }
}

