/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatReferentialImportResult;
import fr.ifremer.tutti.service.genericformat.importactions.ImportActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporarySpecies;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ImportReferentialSpeciesAction
extends ImportActionSupport {
    private static final Log log = LogFactory.getLog(ImportReferentialSpeciesAction.class);
    private final ReferentialTemporarySpeciesService referentialTemporarySpeciesService;

    public ImportReferentialSpeciesAction(GenericFormatImportContext importContext, ReferentialTemporarySpeciesService referentialTemporarySpeciesService) {
        super(importContext);
        this.referentialTemporarySpeciesService = referentialTemporarySpeciesService;
    }

    @Override
    protected boolean canExecute() {
        return this.importContext.getReferentialTemporarySpeciesFileResult().isFound();
    }

    @Override
    protected void doExecute() {
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.import.temporarySpecies", (Object[])new Object[0]));
        if (log.isInfoEnabled()) {
            log.info((Object)"Import temporary species.");
        }
        ReferentialImportRequest<Species, Integer> referentialImportRequest = this.referentialTemporarySpeciesService.createReferentialImportRequest();
        GenericFormatReferentialImportResult<Species, Integer> importFileResult = this.importContext.getReferentialTemporarySpeciesFileResult();
        try (CsvConsumerForTemporarySpecies consumer = this.importContext.loadTemporarySpecies(false);){
            for (ImportRow row : consumer) {
                consumer.checkRowForGenericFormatImport(row, referentialImportRequest);
            }
            importFileResult.flushErrors(consumer);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not close species.csv file", (Throwable)e);
        }
        catch (ImportRuntimeException e) {
            importFileResult.addGlobalError(e.getMessage());
        }
        if (importFileResult.isValid()) {
            ReferentialImportResult<Species> referentialImportResult = this.referentialTemporarySpeciesService.executeImportRequest(referentialImportRequest);
            importFileResult.flushResult(referentialImportRequest, referentialImportResult);
            if (log.isInfoEnabled()) {
                log.info((Object)("Temporary species import result: " + importFileResult.getReport()));
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Do not import temporary species (the incoming file is not valid)");
        }
    }

    @Override
    protected void skipExecute() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Skip import temporary species (no file found).");
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.skip.import.temporarySpecies", (Object[])new Object[0]));
    }
}

