/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.consumer;

import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportEntityParserFactory;
import fr.ifremer.tutti.service.genericformat.csv.SampleCategoryRow;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;

public class CsvConsumerForSampleCategory
extends CsvComsumer<SampleCategoryRow, fr.ifremer.tutti.service.genericformat.csv.SampleCategoryModel> {
    public CsvConsumerForSampleCategory(Path file, char separator, GenericFormatImportEntityParserFactory parserFactory, boolean reportError) {
        super(file, fr.ifremer.tutti.service.genericformat.csv.SampleCategoryModel.forImport(separator, parserFactory), reportError);
    }

    public void validateRow(ImportRow<SampleCategoryRow> row, GenericFormatImportContext importContext) {
        if (row.isValid()) {
            int categoryIndex = (int)row.getLineNumber() - 1;
            SampleCategoryModel sampleCategoryModel = importContext.getImportRequest().getSampleCategoryModel();
            int nbSampling = sampleCategoryModel.getNbSampling();
            if (nbSampling < categoryIndex) {
                this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.tooMuchCategories", (Object[])new Object[0])));
            } else {
                SampleCategoryRow bean = (SampleCategoryRow)row.getBean();
                SampleCategoryModelEntry categoryEntry = sampleCategoryModel.getCategoryByIndex(categoryIndex);
                String code = bean.getCode();
                if (StringUtils.isBlank((CharSequence)code)) {
                    this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.noCode", (Object[])new Object[0])));
                } else {
                    Caracteristic caracteristic = bean.getCaracteristic();
                    if (caracteristic == null) {
                        this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.noCaracteristic", (Object[])new Object[0])));
                    } else if (!Objects.equals(categoryEntry.getCategoryId(), caracteristic.getIdAsInt())) {
                        this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.caracteristicNotMatching", (Object[])new Object[]{categoryEntry.getCategoryId(), caracteristic.getIdAsInt()})));
                    } else if (!Objects.equals(categoryEntry.getCode(), code)) {
                        this.addCheckError(row, new IllegalStateException(I18n.t((String)"tutti.service.genericFormat.import.sampleCategoryModel.error.codeNotMatching", (Object[])new Object[]{categoryEntry.getCode(), code})));
                    }
                }
            }
        }
        this.reportError(row);
    }
}

