/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor.jvm;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.PreparedStatementFactory;
import liquibase.database.core.OracleDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.AbstractExecutor;
import liquibase.executor.Executor;
import liquibase.executor.jvm.CallableStatementCallback;
import liquibase.executor.jvm.ColumnMapRowMapper;
import liquibase.executor.jvm.ResultSetExtractor;
import liquibase.executor.jvm.RowCallbackHandler;
import liquibase.executor.jvm.RowMapper;
import liquibase.executor.jvm.RowMapperResultSetExtractor;
import liquibase.executor.jvm.SingleColumnRowMapper;
import liquibase.executor.jvm.StatementCallback;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.CallableSqlStatement;
import liquibase.statement.ExecutablePreparedStatement;
import liquibase.statement.SqlStatement;
import liquibase.util.JdbcUtils;
import liquibase.util.StringUtils;

public class JdbcExecutor
extends AbstractExecutor
implements Executor {
    private Logger log = LogFactory.getLogger();

    @Override
    public boolean updatesDatabase() {
        return true;
    }

    public Object execute(StatementCallback action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Object object;
        DatabaseConnection con = this.database.getConnection();
        Statement stmt = null;
        try {
            if (con instanceof OfflineConnection) {
                throw new DatabaseException("Cannot execute commands against an offline database");
            }
            Statement stmtToUse = stmt = ((JdbcConnection)con).getUnderlyingConnection().createStatement();
            object = action.doInStatement(stmtToUse);
        }
        catch (SQLException ex) {
            try {
                JdbcUtils.closeStatement(stmt);
                stmt = null;
                throw new DatabaseException("Error executing SQL " + StringUtils.join(this.applyVisitors(action.getStatement(), sqlVisitors), "; on " + con.getURL()) + ": " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        return object;
    }

    public Object execute(CallableStatementCallback action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Object object;
        DatabaseConnection con = this.database.getConnection();
        if (con instanceof OfflineConnection) {
            throw new DatabaseException("Cannot execute commands against an offline database");
        }
        CallableStatement stmt = null;
        try {
            String sql = this.applyVisitors(action.getStatement(), sqlVisitors)[0];
            stmt = ((JdbcConnection)con).getUnderlyingConnection().prepareCall(sql);
            object = action.doInCallableStatement(stmt);
        }
        catch (SQLException ex) {
            try {
                JdbcUtils.closeStatement(stmt);
                stmt = null;
                throw new DatabaseException("Error executing SQL " + StringUtils.join(this.applyVisitors(action.getStatement(), sqlVisitors), "; on " + con.getURL()) + ": " + ex.getMessage(), ex);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        return object;
    }

    @Override
    public void execute(SqlStatement sql) throws DatabaseException {
        this.execute(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public void execute(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof ExecutablePreparedStatement) {
            ((ExecutablePreparedStatement)sql).execute(new PreparedStatementFactory((JdbcConnection)this.database.getConnection()));
            return;
        }
        this.execute(new ExecuteStatementCallback(sql, sqlVisitors), sqlVisitors);
    }

    public Object query(SqlStatement sql, ResultSetExtractor rse) throws DatabaseException {
        return this.query(sql, rse, new ArrayList<SqlVisitor>());
    }

    public Object query(SqlStatement sql, ResultSetExtractor rse, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof CallableSqlStatement) {
            return this.execute(new QueryCallableStatementCallback(sql, rse), sqlVisitors);
        }
        return this.execute(new QueryStatementCallback(sql, rse, sqlVisitors), sqlVisitors);
    }

    public List query(SqlStatement sql, RowMapper rowMapper) throws DatabaseException {
        return this.query(sql, rowMapper, new ArrayList<SqlVisitor>());
    }

    public List query(SqlStatement sql, RowMapper rowMapper, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return (List)this.query(sql, new RowMapperResultSetExtractor(rowMapper), sqlVisitors);
    }

    public Object queryForObject(SqlStatement sql, RowMapper rowMapper) throws DatabaseException {
        return this.queryForObject(sql, rowMapper, new ArrayList<SqlVisitor>());
    }

    public Object queryForObject(SqlStatement sql, RowMapper rowMapper, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        List results = this.query(sql, rowMapper, sqlVisitors);
        return JdbcUtils.requiredSingleResult(results);
    }

    @Override
    public <T> T queryForObject(SqlStatement sql, Class<T> requiredType) throws DatabaseException {
        return this.queryForObject(sql, requiredType, new ArrayList<SqlVisitor>());
    }

    @Override
    public <T> T queryForObject(SqlStatement sql, Class<T> requiredType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return (T)this.queryForObject(sql, this.getSingleColumnRowMapper(requiredType), sqlVisitors);
    }

    @Override
    public long queryForLong(SqlStatement sql) throws DatabaseException {
        return this.queryForLong(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public long queryForLong(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Number number = this.queryForObject(sql, Long.class, sqlVisitors);
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public int queryForInt(SqlStatement sql) throws DatabaseException {
        return this.queryForInt(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public int queryForInt(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Number number = this.queryForObject(sql, Integer.class, sqlVisitors);
        return number != null ? number.intValue() : 0;
    }

    @Override
    public List queryForList(SqlStatement sql, Class elementType) throws DatabaseException {
        return this.queryForList(sql, elementType, new ArrayList<SqlVisitor>());
    }

    @Override
    public List queryForList(SqlStatement sql, Class elementType, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.query(sql, this.getSingleColumnRowMapper(elementType), sqlVisitors);
    }

    @Override
    public List<Map<String, ?>> queryForList(SqlStatement sql) throws DatabaseException {
        return this.queryForList(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public List<Map<String, ?>> queryForList(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        return this.query(sql, this.getColumnMapRowMapper(), sqlVisitors);
    }

    @Override
    public int update(SqlStatement sql) throws DatabaseException {
        return this.update(sql, new ArrayList<SqlVisitor>());
    }

    @Override
    public int update(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        if (sql instanceof CallableSqlStatement) {
            throw new DatabaseException("Direct update using CallableSqlStatement not currently implemented");
        }
        class UpdateStatementCallback
        implements StatementCallback {
            private final /* synthetic */ SqlStatement val$sql;
            private final /* synthetic */ List val$sqlVisitors;

            UpdateStatementCallback(SqlStatement sqlStatement, List list) {
                this.val$sql = sqlStatement;
                this.val$sqlVisitors = list;
            }

            @Override
            public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
                String[] sqlToExecute = JdbcExecutor.this.applyVisitors(this.val$sql, this.val$sqlVisitors);
                if (sqlToExecute.length != 1) {
                    throw new DatabaseException("Cannot call update on Statement that returns back multiple Sql objects");
                }
                JdbcExecutor.this.log.debug("Executing UPDATE database command: " + sqlToExecute[0]);
                return stmt.executeUpdate(sqlToExecute[0]);
            }

            @Override
            public SqlStatement getStatement() {
                return this.val$sql;
            }
        }
        return (Integer)this.execute(new UpdateStatementCallback(sql, sqlVisitors), sqlVisitors);
    }

    protected RowMapper getColumnMapRowMapper() {
        return new ColumnMapRowMapper();
    }

    protected RowMapper getSingleColumnRowMapper(Class requiredType) {
        return new SingleColumnRowMapper(requiredType);
    }

    @Override
    public void comment(String message) throws DatabaseException {
        LogFactory.getLogger().debug(message);
    }

    private class ExecuteStatementCallback
    implements StatementCallback {
        private final SqlStatement sql;
        private final List<SqlVisitor> sqlVisitors;

        private ExecuteStatementCallback(SqlStatement sql, List<SqlVisitor> sqlVisitors) {
            this.sql = sql;
            this.sqlVisitors = sqlVisitors;
        }

        @Override
        public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
            String[] stringArray = JdbcExecutor.this.applyVisitors(this.sql, this.sqlVisitors);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String statement = stringArray[n2];
                if (JdbcExecutor.this.database instanceof OracleDatabase) {
                    statement = statement.replaceFirst("/\\s*/\\s*$", "");
                }
                JdbcExecutor.this.log.debug("Executing EXECUTE database command: " + statement);
                if (statement.contains("?")) {
                    stmt.setEscapeProcessing(false);
                }
                try {
                    stmt.execute(statement);
                }
                catch (SQLException e) {
                    if (!statement.startsWith("CREATE TABLE DATABASECHANGELOGLOCK") && !statement.startsWith("CREATE TABLE DATABASECHANGELOG")) {
                        throw e;
                    }
                    JdbcExecutor.this.log.warning("Could not execute query. Error: " + e.getLocalizedMessage());
                }
                ++n2;
            }
            return null;
        }

        @Override
        public SqlStatement getStatement() {
            return this.sql;
        }
    }

    private class QueryCallableStatementCallback
    implements CallableStatementCallback {
        private final SqlStatement sql;
        private final ResultSetExtractor rse;

        private QueryCallableStatementCallback(SqlStatement sql, ResultSetExtractor rse) {
            this.sql = sql;
            this.rse = rse;
        }

        @Override
        public Object doInCallableStatement(CallableStatement cs) throws SQLException, DatabaseException {
            ResultSet rs = null;
            try {
                rs = cs.executeQuery();
                Object object = this.rse.extractData(rs);
                return object;
            }
            finally {
                JdbcUtils.closeResultSet(rs);
            }
        }

        @Override
        public SqlStatement getStatement() {
            return this.sql;
        }
    }

    private class QueryStatementCallback
    implements StatementCallback {
        private final SqlStatement sql;
        private final List<SqlVisitor> sqlVisitors;
        private final ResultSetExtractor rse;

        private QueryStatementCallback(SqlStatement sql, ResultSetExtractor rse, List<SqlVisitor> sqlVisitors) {
            this.sql = sql;
            this.rse = rse;
            this.sqlVisitors = sqlVisitors;
        }

        @Override
        public Object doInStatement(Statement stmt) throws SQLException, DatabaseException {
            Object object;
            ResultSet rs = null;
            try {
                String[] sqlToExecute = JdbcExecutor.this.applyVisitors(this.sql, this.sqlVisitors);
                if (sqlToExecute.length != 1) {
                    throw new DatabaseException("Can only query with statements that return one sql statement");
                }
                JdbcExecutor.this.log.debug("Executing QUERY database command: " + sqlToExecute[0]);
                ResultSet rsToUse = rs = stmt.executeQuery(sqlToExecute[0]);
                object = this.rse.extractData(rsToUse);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                throw throwable;
            }
            JdbcUtils.closeResultSet(rs);
            return object;
        }

        @Override
        public SqlStatement getStatement() {
            return this.sql;
        }
    }

    private static class RowCallbackHandlerResultSetExtractor
    implements ResultSetExtractor {
        private final RowCallbackHandler rch;

        public RowCallbackHandlerResultSetExtractor(RowCallbackHandler rch) {
            this.rch = rch;
        }

        @Override
        public Object extractData(ResultSet rs) throws SQLException {
            while (rs.next()) {
                this.rch.processRow(rs);
            }
            return null;
        }
    }
}

