/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class SecurityUtil {
    public static String getSystemProperty(final String name, final String def) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name, def);
            }
        });
    }

    public static Properties getSystemProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        });
    }

    public static String getFiletoURISchemaPart(final File f) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                URI uri = f.toURI();
                if (uri != null) {
                    return uri.getScheme();
                }
                return null;
            }
        });
    }

    public static String getFileAbsolutePath(final File f) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return f.getAbsolutePath();
            }
        });
    }

    public static File getAbsoluteFile(final File f) {
        return AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                return f.getAbsoluteFile();
            }
        });
    }

    public static File getCanonicalFile(final File f) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    return f.getAbsoluteFile();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public static URI fileToURI(final File f) {
        return AccessController.doPrivileged(new PrivilegedAction<URI>(){

            @Override
            public URI run() {
                return f.toURI();
            }
        });
    }

    public static FileOutputStream createFileOutputStream(final File f) throws FileNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws FileNotFoundException {
                    return new FileOutputStream(f, false);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getException();
        }
    }

    public static boolean exists(final File f) {
        Boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean exists = f.exists();
                return exists;
            }
        });
        return exists;
    }

    public static boolean isFile(final File f) {
        Boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean exists = f.isFile();
                return exists;
            }
        });
        return exists;
    }

    public static boolean isDirectory(final File f) {
        Boolean exists = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                boolean exists = f.isDirectory();
                return exists;
            }
        });
        return exists;
    }
}

