/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.util;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.birt.data.oda.pojo.querymodel.IColumnsMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PojoQueryWriter {
    public static String write(PojoQuery query) throws OdaException {
        if (query == null) {
            return null;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("PojoQuery");
            doc.appendChild(root);
            if (query.getVersion() != null) {
                root.setAttribute("version", query.getVersion());
            }
            if (query.getAppContextKey() != null) {
                root.setAttribute("appContextKey", query.getAppContextKey());
            }
            if (query.getDataSetClass() != null) {
                root.setAttribute("dataSetClass", query.getDataSetClass());
            }
            IColumnsMapping[] iColumnsMappingArray = query.getColumnsMappings();
            int n = iColumnsMappingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IColumnsMapping cm = iColumnsMappingArray[n2];
                root.appendChild(cm.createElement(doc));
                ++n2;
            }
            TransformerFactory tff = TransformerFactory.newInstance();
            tff.setAttribute("indent-number", 4);
            Transformer tf = tff.newTransformer();
            tf.setOutputProperty("indent", "yes");
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            DOMSource source = new DOMSource(doc);
            tf.transform(source, sr);
            return sw.toString();
        }
        catch (ParserConfigurationException e) {
            throw new OdaException((Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            throw new OdaException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new OdaException((Throwable)e);
        }
    }
}

