package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportProgramAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/tutti/tags/tutti-3.1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/ExportProgramAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.export.generic.TuttiExportService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.File;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * To export a selected program.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 2.0
 */
public class ExportProgramAction extends AbstractTuttiAction<SelectCruiseUIModel, SelectCruiseUI, SelectCruiseUIHandler> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(ExportProgramAction.class);

    protected File file;

    public ExportProgramAction(SelectCruiseUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        Program program = getModel().getProgram();
        if (doAction) {

            // choose file to export
            file = saveFile(
                    "exportProgram-" + program.getName(), "zip",
                    t("tutti.selectCruise.title.choose.exportProgramFile"),
                    t("tutti.selectCruise.action.chooseProgramExportFile"),
                    "^.+\\.zip$", t("tutti.common.file.zip")
            );
            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Program program = getModel().getProgram();
        Preconditions.checkNotNull(program);
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will save program " + program.getId() +
                     " to file: " + file);
        }

        // nbCruise * (check cruise / export cruise / gear caracteristics / operation / parameter / catches / individual observation / accidental catches / species) +  zip
        List<Cruise> allCruise =
                getContext().getPersistenceService().getAllCruise(program.getId());

        ProgressionModel progressionModel = new ProgressionModel();
        setProgressionModel(progressionModel);
        progressionModel.setTotal(9 * allCruise.size() + 1);

//        TuttiProtocol protocol = null;
//        if (getContext().isProtocolFilled()) {
//            protocol = getDataContext().getProtocol();
//            if (log.isInfoEnabled()) {
//                log.info("Will use protocol " + protocol.getName());
//            }
//        }
        ApplicationBusinessException exportError = null;

        TuttiExportService service = getContext().getTuttiExportService();
        try {
            service.exportProgram(program.getId(), file, progressionModel);
        } catch (ApplicationBusinessException e) {

            String errorMessage;
            errorMessage = t("tutti.exportProgram.action.exportErrors", program.getName(), e.getMessage());

            exportError = new ApplicationBusinessException(errorMessage);
        }

        handler.resetEditProgramAction();

        sendMessage(t("tutti.exportProgram.action.success", program.getName(),
                      file.getName()));

        if (exportError != null) {
            throw exportError;
        }
    }
}
