/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical.synchro;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.shared.application.ApplicationTechnicalException;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.ForeignKeyMetadata;
import org.hibernate.tool.hbm2ddl.IndexMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.nuiton.i18n.I18n;

public class ReferentialSynchroTableMetadata {
    public static final String PK_SEPARATOR = "~~";
    protected final String selectPrimaryKeysQuery;
    protected final String selectMaxUpdateDateQuery;
    protected final String countQuery;
    protected final TableMetadata delegate;
    protected final Map<String, ColumnMetadata> columns;
    protected final List<String> columnNames;
    protected final Set<String> pkNames;
    protected final int[] pkIndexs;
    protected final String insertQuery;
    protected final String updateQuery;
    protected final boolean withUpdateDateColumn;
    protected final String countDataToUpdateQuery;
    protected final String selectDataToUpdateQuery;
    protected final String selectAllQuery;
    protected final String selectDataQueryFromPk;

    public ReferentialSynchroTableMetadata(TableMetadata delegate, DatabaseMetaData meta) {
        Preconditions.checkNotNull((Object)delegate);
        this.delegate = delegate;
        try {
            Field field = TableMetadata.class.getDeclaredField("columns");
            field.setAccessible(true);
            this.columns = Maps.newLinkedHashMap((Map)((Map)field.get(delegate)));
            this.withUpdateDateColumn = this.columns.containsKey("update_date");
            this.columnNames = this.initColumnNames(this.columns);
            this.pkNames = this.initPrimaryKeys(meta);
            Preconditions.checkNotNull(this.pkNames);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n._((String)"tutti.persistence.tableMetadata.instanciation.error", (Object[])new Object[]{this}), (Throwable)e);
        }
        this.pkIndexs = this.createPkIndex();
        this.insertQuery = this.createInsertQuery();
        this.updateQuery = this.createUpdateQuery();
        this.selectMaxUpdateDateQuery = this.createSelectMaxUpdateDateQuery();
        this.selectPrimaryKeysQuery = this.createSelectPrimaryKeysQuery();
        this.selectAllQuery = this.createSelectAllQuery();
        this.selectDataQueryFromPk = this.createSelectDataFromPkQuery();
        this.selectDataToUpdateQuery = this.createSelectDataToUpdateQuery();
        this.countQuery = this.createCountQuery();
        this.countDataToUpdateQuery = this.createCountDataToUpdateQuery();
    }

    ReferentialSynchroTableMetadata() {
        this.delegate = null;
        this.columns = null;
        this.columnNames = null;
        this.pkNames = null;
        this.pkIndexs = null;
        this.withUpdateDateColumn = false;
        this.insertQuery = null;
        this.updateQuery = null;
        this.countQuery = null;
        this.countDataToUpdateQuery = null;
        this.selectPrimaryKeysQuery = null;
        this.selectMaxUpdateDateQuery = null;
        this.selectDataToUpdateQuery = null;
        this.selectAllQuery = null;
        this.selectDataQueryFromPk = null;
    }

    public Set<String> getPkNames() {
        return this.pkNames;
    }

    public boolean isWithUpdateDateColumn() {
        return this.withUpdateDateColumn;
    }

    public int getColumnsCount() {
        return this.columns.size();
    }

    public Set<String> getColumnNames() {
        return ImmutableSet.copyOf(this.columnNames);
    }

    public int getColumnIndex(String name) {
        int result = this.columnNames.indexOf(name);
        return result;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public ForeignKeyMetadata getForeignKeyMetadata(ForeignKey fk) {
        return this.delegate.getForeignKeyMetadata(fk);
    }

    public ColumnMetadata getColumnMetadata(String columnName) {
        return this.delegate.getColumnMetadata(columnName);
    }

    public String getSchema() {
        return this.delegate.getSchema();
    }

    public String getCatalog() {
        return this.delegate.getCatalog();
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String keyName) {
        return this.delegate.getForeignKeyMetadata(keyName);
    }

    public IndexMetadata getIndexMetadata(String indexName) {
        return this.delegate.getIndexMetadata(indexName);
    }

    public String getInsertQuery() {
        return this.insertQuery;
    }

    public String getUpdateQuery() {
        return this.updateQuery;
    }

    public String getSelectPrimaryKeysQuery() {
        return this.selectPrimaryKeysQuery;
    }

    public String getSelectMaxUpdateDateQuery() {
        return this.selectMaxUpdateDateQuery;
    }

    public String getSelectDataQueryFromPk() {
        return this.selectDataQueryFromPk;
    }

    public String getSelectDataToUpdateQuery(Date fromDate) {
        String sql = fromDate == null ? this.selectAllQuery : this.selectDataToUpdateQuery;
        return sql;
    }

    public String getCountQuery() {
        return this.countQuery;
    }

    public String getCountDataToUpdateQuery(Date fromDate) {
        String sql = fromDate == null ? this.countQuery : this.countDataToUpdateQuery;
        return sql;
    }

    public int[] getPkIndexs() {
        return this.pkIndexs;
    }

    public boolean isSimpleKey() {
        return this.pkIndexs.length == 1;
    }

    public List<Object> getPk(ResultSet incomingData) throws SQLException {
        ArrayList result = Lists.newArrayListWithCapacity((int)this.pkIndexs.length);
        for (int pkIndex : this.pkIndexs) {
            Object pk = incomingData.getObject(pkIndex);
            result.add(pk);
        }
        return result;
    }

    public String toPkStr(List<Object> pkList) {
        StringBuilder sb = new StringBuilder();
        for (Object pk : pkList) {
            sb.append(PK_SEPARATOR).append(pk);
        }
        return sb.substring(PK_SEPARATOR.length());
    }

    public List<Object> fromPkStr(String pk) {
        String[] split;
        ArrayList pkList = Lists.newArrayList();
        for (String s : split = pk.split(PK_SEPARATOR)) {
            if ("null".equals(s)) {
                s = null;
            }
            pkList.add(s);
        }
        return pkList;
    }

    protected List<String> initColumnNames(Map<String, ColumnMetadata> columns) {
        ArrayList result = Lists.newArrayListWithCapacity((int)columns.size());
        for (String name : columns.keySet()) {
            result.add(name);
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> initPrimaryKeys(DatabaseMetaData meta) throws SQLException {
        LinkedHashSet result = Sets.newLinkedHashSet();
        ResultSet rs = meta.getPrimaryKeys(this.getCatalog(), this.getSchema(), this.getName());
        try {
            while (rs.next()) {
                result.add(rs.getString("COLUMN_NAME"));
            }
            rs.close();
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)result);
            return immutableSet;
        }
        finally {
            TuttiEntities.closeSilently(rs);
        }
    }

    protected int[] createPkIndex() {
        int[] result = new int[this.pkNames.size()];
        int pkI = 0;
        for (String pkName : this.pkNames) {
            String pkColumnName = pkName.toLowerCase();
            int i = 1;
            int index = -1;
            for (String columnName : this.columnNames) {
                if (pkColumnName.equals(columnName)) {
                    index = i;
                    continue;
                }
                ++i;
            }
            result[pkI++] = index;
        }
        return result;
    }

    protected String createInsertQuery() {
        StringBuilder queryParams = new StringBuilder();
        StringBuilder valueParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            queryParams.append(", ").append(columnName);
            valueParams.append(", ?");
        }
        String result = String.format("INSERT INTO %s (%s) VALUES (%s)", this.getName(), queryParams.substring(2), valueParams.substring(2));
        return result;
    }

    protected String createUpdateQuery() {
        StringBuilder updateParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            updateParams.append(", ").append(columnName).append(" = ?");
        }
        String result = String.format("UPDATE %s SET %s WHERE %s", this.getName(), updateParams.substring(2), this.createPkWhereClause());
        return result;
    }

    protected String createSelectDataFromPkQuery() {
        String result = String.format("SELECT %s FROM %s WHERE %s", this.createSelectParams(), this.getName(), this.createPkWhereClause());
        return result;
    }

    protected String createSelectPrimaryKeysQuery() {
        String prefix = " || '~~' || ";
        StringBuilder pkParams = new StringBuilder();
        for (String columnName : this.pkNames) {
            pkParams.append(prefix).append(columnName);
        }
        return String.format("SELECT %s FROM %s", pkParams.substring(prefix.length()), this.getName());
    }

    protected String createSelectAllQuery() {
        return "SELECT " + this.createSelectParams() + " FROM " + this.getName();
    }

    protected String createSelectMaxUpdateDateQuery() {
        return String.format("SELECT max(update_date) FROM %s", this.getName());
    }

    protected String createSelectDataToUpdateQuery() {
        String whereClause = this.createWithUpdateDateWhereClause();
        return "SELECT " + this.createSelectParams() + " FROM " + this.getName() + whereClause;
    }

    protected String createCountQuery() {
        return String.format("SELECT count(*) FROM %s", this.getName());
    }

    protected String createCountDataToUpdateQuery() {
        String whereClause = this.createWithUpdateDateWhereClause();
        return "SELECT count(*) FROM " + this.getName() + whereClause;
    }

    protected String createPkWhereClause() {
        StringBuilder pkParams = new StringBuilder();
        for (String columnName : this.pkNames) {
            pkParams.append("AND ").append(columnName).append(" = ?");
        }
        return pkParams.substring(4);
    }

    protected String createWithUpdateDateWhereClause() {
        String whereClause = this.isWithUpdateDateColumn() ? " WHERE (update_date IS NULL OR update_date > ?)" : "";
        return whereClause;
    }

    protected String createSelectParams() {
        StringBuilder queryParams = new StringBuilder();
        for (String columnName : this.columnNames) {
            queryParams.append(", ").append(columnName);
        }
        return queryParams.substring(2);
    }

    public String getTableLogPrefix() {
        return "[" + this.getName() + "]";
    }
}

