package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.BlockingLayerUI;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidatorMessageWidget;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class MainUI extends JFrame implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, MainUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCK = "busyBlockLayerUI.block";
    public static final String BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR = "busyBlockLayerUI.blockingColor";
    public static final String BINDING_MENU_ACTIONS_ENABLED = "menuActions.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED = "menuActionEditCatches.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED = "menuActionEditCruise.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED = "menuActionEditProgram.enabled";
    public static final String BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED = "menuActionEditProtocol.enabled";
    public static final String BINDING_MENU_ACTION_GENERATE_CRUISE_REPORT_ENABLED = "menuActionGenerateCruiseReport.enabled";
    public static final String BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED = "menuActionSelectCruise.enabled";
    public static final String BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED = "menuActionValidateCatches.enabled";
    public static final String BINDING_MENU_ADMINISTRATION_ENABLED = "menuAdministration.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_FR_ENABLED = "menuChangeLocaleFR.enabled";
    public static final String BINDING_MENU_CHANGE_LOCALE_UK_ENABLED = "menuChangeLocaleUK.enabled";
    public static final String BINDING_MENU_EDIT_SAMPLE_CATEGORY_MODEL_ENABLED = "menuEditSampleCategoryModel.enabled";
    public static final String BINDING_MENU_FILE_CONFIGURATION_ENABLED = "menuFileConfiguration.enabled";
    public static final String BINDING_MENU_FILE_MANAGE_DB_ENABLED = "menuFileManageDb.enabled";
    public static final String BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED = "menuImportTemporaryReferential.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(MainUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTitledPanel body;
    protected JToolBar bottomBar;
    protected TuttiHelpBroker broker;
    protected BlockingLayerUI busyBlockLayerUI;
    protected final MainUIHandler handler = new MainUIHandler();
    protected MainUI mainFrame = this;
    protected JMenuBar menu;
    protected JMenuItem menuActionEditCatches;
    protected JMenuItem menuActionEditCruise;
    protected JMenuItem menuActionEditProgram;
    protected JMenuItem menuActionEditProtocol;
    protected JMenuItem menuActionGenerateCruiseReport;
    protected JMenuItem menuActionSelectCruise;
    protected JMenuItem menuActionValidateCatches;
    protected JMenu menuActions;
    protected JMenu menuAdministration;
    protected JMenu menuChangeLocale;
    protected JMenuItem menuChangeLocaleFR;
    protected JMenuItem menuChangeLocaleUK;
    protected JMenuItem menuEditSampleCategoryModel;
    protected JMenu menuFile;
    protected JMenuItem menuFileConfiguration;
    protected JMenuItem menuFileExit;
    protected JMenuItem menuFileManageDb;
    protected JMenuItem menuFileUpdateApplication;
    protected JMenuItem menuFileUpdateReport;
    protected JMenu menuHelp;
    protected JMenuItem menuHelpAbout;
    protected JMenuItem menuHelpSite;
    protected JMenuItem menuImportTemporaryReferential;
    protected JMenuItem menuShowHelp;
    protected TuttiUIContext model;
    protected JButton showHelp;
    protected StatusMessagePanel status;
    protected SwingValidatorMessageWidget validatorMessageWidget;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MainUI(TuttiUIContext context) {
        TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public MainUI() {
        $initialize();
    }

    public MainUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0) {
        super(param0);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public MainUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public MainUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__menuHelpSite(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.gotoSite();
    }

    public void doActionPerformed__on__menuShowHelp(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.showHelp();
    }

    public void doWindowClosing__on__mainFrame(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        menuFileExit.getAction().actionPerformed(null);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTitledPanel getBody() {
        return body;
    }

    public JToolBar getBottomBar() {
        return bottomBar;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public BlockingLayerUI getBusyBlockLayerUI() {
        return busyBlockLayerUI;
    }

    public MainUIHandler getHandler() {
        return handler;
    }

    public JMenuBar getMenu() {
        return menu;
    }

    public JMenuItem getMenuActionEditCatches() {
        return menuActionEditCatches;
    }

    public JMenuItem getMenuActionEditCruise() {
        return menuActionEditCruise;
    }

    public JMenuItem getMenuActionEditProgram() {
        return menuActionEditProgram;
    }

    public JMenuItem getMenuActionEditProtocol() {
        return menuActionEditProtocol;
    }

    public JMenuItem getMenuActionGenerateCruiseReport() {
        return menuActionGenerateCruiseReport;
    }

    public JMenuItem getMenuActionSelectCruise() {
        return menuActionSelectCruise;
    }

    public JMenuItem getMenuActionValidateCatches() {
        return menuActionValidateCatches;
    }

    public JMenu getMenuActions() {
        return menuActions;
    }

    public JMenu getMenuAdministration() {
        return menuAdministration;
    }

    public JMenu getMenuChangeLocale() {
        return menuChangeLocale;
    }

    public JMenuItem getMenuChangeLocaleFR() {
        return menuChangeLocaleFR;
    }

    public JMenuItem getMenuChangeLocaleUK() {
        return menuChangeLocaleUK;
    }

    public JMenuItem getMenuEditSampleCategoryModel() {
        return menuEditSampleCategoryModel;
    }

    public JMenu getMenuFile() {
        return menuFile;
    }

    public JMenuItem getMenuFileConfiguration() {
        return menuFileConfiguration;
    }

    public JMenuItem getMenuFileExit() {
        return menuFileExit;
    }

    public JMenuItem getMenuFileManageDb() {
        return menuFileManageDb;
    }

    public JMenuItem getMenuFileUpdateApplication() {
        return menuFileUpdateApplication;
    }

    public JMenuItem getMenuFileUpdateReport() {
        return menuFileUpdateReport;
    }

    public JMenu getMenuHelp() {
        return menuHelp;
    }

    public JMenuItem getMenuHelpAbout() {
        return menuHelpAbout;
    }

    public JMenuItem getMenuHelpSite() {
        return menuHelpSite;
    }

    public JMenuItem getMenuImportTemporaryReferential() {
        return menuImportTemporaryReferential;
    }

    public JMenuItem getMenuShowHelp() {
        return menuShowHelp;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JButton getShowHelp() {
        return showHelp;
    }

    public StatusMessagePanel getStatus() {
        return status;
    }

    public SwingValidatorMessageWidget getValidatorMessageWidget() {
        return validatorMessageWidget;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToBottomBar() {
        if (!allComponentsCreated) {
            return;
        }
        bottomBar.add(validatorMessageWidget);
    }

    protected void addChildrenToMainFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add(bottomBar);
        add(showHelp);
        add(SwingUtil.boxComponentWithJxLayer(body), BorderLayout.CENTER);
        add(status, BorderLayout.SOUTH);
        mainFrame.setJMenuBar(menu);
    }

    protected void addChildrenToMenu() {
        if (!allComponentsCreated) {
            return;
        }
        menu.add(menuFile);
        menu.add(menuActions);
        menu.add(menuAdministration);
        menu.add(menuHelp);
    }

    protected void addChildrenToMenuActions() {
        if (!allComponentsCreated) {
            return;
        }
        menuActions.add(menuActionSelectCruise);
        menuActions.add(menuActionEditProgram);
        menuActions.add(menuActionEditCruise);
        menuActions.add(menuActionEditProtocol);
        menuActions.add(menuActionEditCatches);
        menuActions.add(menuActionValidateCatches);
        menuActions.add(menuActionGenerateCruiseReport);
    }

    protected void addChildrenToMenuAdministration() {
        if (!allComponentsCreated) {
            return;
        }
        menuAdministration.add(menuImportTemporaryReferential);
        menuAdministration.add(menuEditSampleCategoryModel);
    }

    protected void addChildrenToMenuChangeLocale() {
        if (!allComponentsCreated) {
            return;
        }
        menuChangeLocale.add(menuChangeLocaleUK);
        menuChangeLocale.add(menuChangeLocaleFR);
    }

    protected void addChildrenToMenuFile() {
        if (!allComponentsCreated) {
            return;
        }
        menuFile.add(menuFileConfiguration);
        menuFile.add(menuFileUpdateApplication);
        menuFile.add(menuFileUpdateReport);
        menuFile.add($JSeparator0);
        menuFile.add(menuFileManageDb);
        menuFile.add($JSeparator1);
        menuFile.add(menuFileExit);
    }

    protected void addChildrenToMenuHelp() {
        if (!allComponentsCreated) {
            return;
        }
        menuHelp.add(menuShowHelp);
        menuHelp.add(menuHelpSite);
        menuHelp.add(menuHelpAbout);
        menuHelp.add(menuChangeLocale);
    }

    protected void createBody() {
        $objectMap.put("body", body = new JXTitledPanel());
        
        body.setName("body");
        body.putClientProperty("help", "tutti.main.help");
    }

    protected void createBottomBar() {
        $objectMap.put("bottomBar", bottomBar = new JToolBar());
        
        bottomBar.setName("bottomBar");
        bottomBar.setFloatable(false);
        bottomBar.setBorderPainted(false);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.main.help"));
    }

    protected void createBusyBlockLayerUI() {
        $objectMap.put("busyBlockLayerUI", busyBlockLayerUI = new BlockingLayerUI());
        
        busyBlockLayerUI.setUseIcon(false);
    }

    protected void createMenu() {
        $objectMap.put("menu", menu = new JMenuBar());
        
        menu.setName("menu");
    }

    protected void createMenuActionEditCatches() {
        $objectMap.put("menuActionEditCatches", menuActionEditCatches = new JMenuItem());
        
        menuActionEditCatches.setName("menuActionEditCatches");
        menuActionEditCatches.setText(_("tutti.main.action.editCatches"));
        menuActionEditCatches.setToolTipText(_("tutti.main.action.editCatches.tip"));
        menuActionEditCatches.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSelectedCruiseCatchesAction.class);
        menuActionEditCatches.putClientProperty("help", "tutti.main.menu.action.editCatches.help");
    }

    protected void createMenuActionEditCruise() {
        $objectMap.put("menuActionEditCruise", menuActionEditCruise = new JMenuItem());
        
        menuActionEditCruise.setName("menuActionEditCruise");
        menuActionEditCruise.setText(_("tutti.main.action.editSelectedCruise"));
        menuActionEditCruise.setToolTipText(_("tutti.main.action.editSelectedCruise.tip"));
        menuActionEditCruise.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSelectedCruiseAction.class);
        menuActionEditCruise.putClientProperty("help", "tutti.main.menu.action.editCruise.help");
    }

    protected void createMenuActionEditProgram() {
        $objectMap.put("menuActionEditProgram", menuActionEditProgram = new JMenuItem());
        
        menuActionEditProgram.setName("menuActionEditProgram");
        menuActionEditProgram.setText(_("tutti.main.action.editSelectedProgram"));
        menuActionEditProgram.setToolTipText(_("tutti.main.action.editProgram.tip"));
        menuActionEditProgram.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSelectedProgramAction.class);
        menuActionEditProgram.putClientProperty("help", "tutti.main.menu.action.editProgram.help");
    }

    protected void createMenuActionEditProtocol() {
        $objectMap.put("menuActionEditProtocol", menuActionEditProtocol = new JMenuItem());
        
        menuActionEditProtocol.setName("menuActionEditProtocol");
        menuActionEditProtocol.setText(_("tutti.main.action.editSelectedProtocol"));
        menuActionEditProtocol.setToolTipText(_("tutti.main.action.editSelectedProtocol.tip"));
        menuActionEditProtocol.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSelectedProtocolAction.class);
        menuActionEditProtocol.putClientProperty("help", "tutti.main.menu.action.editProtocol.help");
    }

    protected void createMenuActionGenerateCruiseReport() {
        $objectMap.put("menuActionGenerateCruiseReport", menuActionGenerateCruiseReport = new JMenuItem());
        
        menuActionGenerateCruiseReport.setName("menuActionGenerateCruiseReport");
        menuActionGenerateCruiseReport.setText(_("tutti.main.action.generateSelectedCruiseReport"));
        menuActionGenerateCruiseReport.setToolTipText(_("tutti.main.action.generateSelectedCruiseReport.tip"));
        menuActionGenerateCruiseReport.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ShowReportAction.class);
        menuActionGenerateCruiseReport.putClientProperty("help", "tutti.main.menu.action.generateSelectedCruiseReport.help");
    }

    protected void createMenuActionSelectCruise() {
        $objectMap.put("menuActionSelectCruise", menuActionSelectCruise = new JMenuItem());
        
        menuActionSelectCruise.setName("menuActionSelectCruise");
        menuActionSelectCruise.setText(_("tutti.main.action.selectCruise"));
        menuActionSelectCruise.setToolTipText(_("tutti.main.action.selectCruise.tip"));
        menuActionSelectCruise.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.SelectCruiseAction.class);
        menuActionSelectCruise.putClientProperty("help", "tutti.main.menu.action.selectCruise.help");
    }

    protected void createMenuActionValidateCatches() {
        $objectMap.put("menuActionValidateCatches", menuActionValidateCatches = new JMenuItem());
        
        menuActionValidateCatches.setName("menuActionValidateCatches");
        menuActionValidateCatches.setText(_("tutti.main.action.validateCatches"));
        menuActionValidateCatches.setToolTipText(_("tutti.main.action.validateCatches.tip"));
        menuActionValidateCatches.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ValidateSelectedCruiseCatchesAction.class);
        menuActionValidateCatches.putClientProperty("help", "tutti.main.menu.action.validateCatches.help");
    }

    protected void createMenuActions() {
        $objectMap.put("menuActions", menuActions = new JMenu());
        
        menuActions.setName("menuActions");
        menuActions.setText(_("tutti.main.menu.actions"));
        menuActions.setToolTipText(_("tutti.main.menu.actions.tip"));
    }

    protected void createMenuAdministration() {
        $objectMap.put("menuAdministration", menuAdministration = new JMenu());
        
        menuAdministration.setName("menuAdministration");
        menuAdministration.setText(_("tutti.main.menu.administration"));
        menuAdministration.setToolTipText(_("tutti.main.menu.administration.tip"));
    }

    protected void createMenuChangeLocale() {
        $objectMap.put("menuChangeLocale", menuChangeLocale = new JMenu());
        
        menuChangeLocale.setName("menuChangeLocale");
        menuChangeLocale.setText(_("tutti.main.menu.changeLocale"));
        menuChangeLocale.setToolTipText(_("tutti.main.action.changeLocale.tip"));
        menuChangeLocale.putClientProperty("help", "tutti.main.menu.action.changeLocale.help");
    }

    protected void createMenuChangeLocaleFR() {
        $objectMap.put("menuChangeLocaleFR", menuChangeLocaleFR = new JMenuItem());
        
        menuChangeLocaleFR.setName("menuChangeLocaleFR");
        menuChangeLocaleFR.setText(_("tutti.main.action.changeLocaleFR"));
        menuChangeLocaleFR.setToolTipText(_("tutti.main.action.changeLocaleFR.tip"));
        menuChangeLocaleFR.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ChangeToLocaleFRAction.class);
        menuChangeLocaleFR.putClientProperty("help", "tutti.main.menu.action.changeLocaleFR.help");
    }

    protected void createMenuChangeLocaleUK() {
        $objectMap.put("menuChangeLocaleUK", menuChangeLocaleUK = new JMenuItem());
        
        menuChangeLocaleUK.setName("menuChangeLocaleUK");
        menuChangeLocaleUK.setText(_("tutti.main.action.changeLocaleUK"));
        menuChangeLocaleUK.setToolTipText(_("tutti.main.action.changeLocaleUK.tip"));
        menuChangeLocaleUK.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ChangeToLocaleUKAction.class);
        menuChangeLocaleUK.putClientProperty("help", "tutti.main.menu.action.changeLocaleUK.help");
    }

    protected void createMenuEditSampleCategoryModel() {
        $objectMap.put("menuEditSampleCategoryModel", menuEditSampleCategoryModel = new JMenuItem());
        
        menuEditSampleCategoryModel.setName("menuEditSampleCategoryModel");
        menuEditSampleCategoryModel.setText(_("tutti.main.action.editSampleCategoryModel"));
        menuEditSampleCategoryModel.setToolTipText(_("tutti.main.action.editSampleCategoryModel.tip"));
        menuEditSampleCategoryModel.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.EditSampleCategoryModelAction.class);
        menuEditSampleCategoryModel.putClientProperty("help", "tutti.main.menu.action.editSampleCategoryModel.help");
    }

    protected void createMenuFile() {
        $objectMap.put("menuFile", menuFile = new JMenu());
        
        menuFile.setName("menuFile");
        menuFile.setText(_("tutti.main.menu.file"));
        menuFile.setToolTipText(_("tutti.main.menu.file.tip"));
    }

    protected void createMenuFileConfiguration() {
        $objectMap.put("menuFileConfiguration", menuFileConfiguration = new JMenuItem());
        
        menuFileConfiguration.setName("menuFileConfiguration");
        menuFileConfiguration.setText(_("tutti.main.action.configuration"));
        menuFileConfiguration.setToolTipText(_("tutti.main.action.configuration.tip"));
        menuFileConfiguration.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ShowConfigAction.class);
        menuFileConfiguration.putClientProperty("help", "tutti.main.menu.action.configuration.help");
    }

    protected void createMenuFileExit() {
        $objectMap.put("menuFileExit", menuFileExit = new JMenuItem());
        
        menuFileExit.setName("menuFileExit");
        menuFileExit.setText(_("tutti.main.action.exit"));
        menuFileExit.setToolTipText(_("tutti.main.action.exit.tip"));
        menuFileExit.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.CloseApplicationAction.class);
        menuFileExit.putClientProperty("help", "tutti.main.menu.action.exit.help");
    }

    protected void createMenuFileManageDb() {
        $objectMap.put("menuFileManageDb", menuFileManageDb = new JMenuItem());
        
        menuFileManageDb.setName("menuFileManageDb");
        menuFileManageDb.setText(_("tutti.main.action.manageDb"));
        menuFileManageDb.setToolTipText(_("tutti.main.action.manageDb.tip"));
        menuFileManageDb.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ManageDbAction.class);
        menuFileManageDb.putClientProperty("help", "tutti.main.menu.action.manageDb.help");
    }

    protected void createMenuFileUpdateApplication() {
        $objectMap.put("menuFileUpdateApplication", menuFileUpdateApplication = new JMenuItem());
        
        menuFileUpdateApplication.setName("menuFileUpdateApplication");
        menuFileUpdateApplication.setText(_("tutti.main.action.updateApplication"));
        menuFileUpdateApplication.setToolTipText(_("tutti.main.action.updateApplication.tip"));
        menuFileUpdateApplication.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.UpdateApplicationAction.class);
        menuFileUpdateApplication.putClientProperty("help", "tutti.main.menu.action.updateApplication.help");
    }

    protected void createMenuFileUpdateReport() {
        $objectMap.put("menuFileUpdateReport", menuFileUpdateReport = new JMenuItem());
        
        menuFileUpdateReport.setName("menuFileUpdateReport");
        menuFileUpdateReport.setText(_("tutti.main.action.updateReport"));
        menuFileUpdateReport.setToolTipText(_("tutti.main.action.updateReport.tip"));
        menuFileUpdateReport.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.UpdateReportAction.class);
        menuFileUpdateReport.putClientProperty("help", "tutti.main.menu.action.updateReport.help");
    }

    protected void createMenuHelp() {
        $objectMap.put("menuHelp", menuHelp = new JMenu());
        
        menuHelp.setName("menuHelp");
        menuHelp.setText(_("tutti.main.menu.help"));
        menuHelp.setToolTipText(_("tutti.main.menu.help.tip"));
    }

    protected void createMenuHelpAbout() {
        $objectMap.put("menuHelpAbout", menuHelpAbout = new JMenuItem());
        
        menuHelpAbout.setName("menuHelpAbout");
        menuHelpAbout.setText(_("tutti.main.action.about"));
        menuHelpAbout.setToolTipText(_("tutti.main.action.about.tip"));
        menuHelpAbout.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ShowAboutAction.class);
        menuHelpAbout.putClientProperty("help", "tutti.main.menu.action.about.help");
    }

    protected void createMenuHelpSite() {
        $objectMap.put("menuHelpSite", menuHelpSite = new JMenuItem());
        
        menuHelpSite.setName("menuHelpSite");
        menuHelpSite.setText(_("tutti.main.action.site"));
        menuHelpSite.setToolTipText(_("tutti.main.action.site.tip"));
        menuHelpSite.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuHelpSite"));
        menuHelpSite.putClientProperty("help", "tutti.main.menu.action.site.help");
    }

    protected void createMenuImportTemporaryReferential() {
        $objectMap.put("menuImportTemporaryReferential", menuImportTemporaryReferential = new JMenuItem());
        
        menuImportTemporaryReferential.setName("menuImportTemporaryReferential");
        menuImportTemporaryReferential.setText(_("tutti.main.action.importTemporaryReferential"));
        menuImportTemporaryReferential.setToolTipText(_("tutti.main.action.importTemporaryReferential.tip"));
        menuImportTemporaryReferential.putClientProperty("applicationAction", fr.ifremer.tutti.ui.swing.action.ImportTemporaryReferentialAction.class);
        menuImportTemporaryReferential.putClientProperty("help", "tutti.main.menu.action.importTemporaryReferential.help");
    }

    protected void createMenuShowHelp() {
        $objectMap.put("menuShowHelp", menuShowHelp = new JMenuItem());
        
        menuShowHelp.setName("menuShowHelp");
        menuShowHelp.setText(_("tutti.main.action.showHelp"));
        menuShowHelp.setToolTipText(_("tutti.main.action.showHelp.tip"));
        menuShowHelp.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__menuShowHelp"));
        menuShowHelp.putClientProperty("help", "tutti.index.help");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createShowHelp() {
        $objectMap.put("showHelp", showHelp = new JButton());
        
        showHelp.setName("showHelp");
        showHelp.setToolTipText(_("tutti.main.action.showHelp.tip"));
        showHelp.putClientProperty("help", "tutti.main.menu.action.showHelp.help");
    }

    protected void createStatus() {
        $objectMap.put("status", status = new StatusMessagePanel());
        
        status.setName("status");
    }

    protected void createValidatorMessageWidget() {
        $objectMap.put("validatorMessageWidget", validatorMessageWidget = new SwingValidatorMessageWidget());
        
        validatorMessageWidget.setName("validatorMessageWidget");
        validatorMessageWidget.setFocusPainted(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToMainFrame();
        addChildrenToMenu();
        addChildrenToMenuFile();
        addChildrenToMenuActions();
        addChildrenToMenuAdministration();
        addChildrenToMenuHelp();
        addChildrenToMenuChangeLocale();
        addChildrenToBottomBar();
        
        // apply 17 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 48 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        setIconImage(SwingUtil.createImageIcon("allegro_32.png").getImage());
        menuFile.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.menu.file.mnemonic"),'Z'));
        menuFileConfiguration.setIcon(SwingUtil.createActionIcon("config"));
        menuFileConfiguration.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.configuration.mnemonic"),'Z'));
        menuFileUpdateApplication.setIcon(SwingUtil.createActionIcon("update-application"));
        menuFileUpdateApplication.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.updateApplication.mnemonic"),'Z'));
        menuFileUpdateReport.setIcon(SwingUtil.createActionIcon("update-report"));
        menuFileUpdateReport.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.updateReport.mnemonic"),'Z'));
        menuFileManageDb.setIcon(SwingUtil.createActionIcon("manage-db"));
        menuFileManageDb.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.manageDb.mnemonic"),'Z'));
        menuFileExit.setIcon(SwingUtil.createActionIcon("exit"));
        menuFileExit.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.exit.mnemonic"),'Z'));
        menuActions.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.menu.actions.mnemonic"),'Z'));
        menuActionSelectCruise.setIcon(SwingUtil.createActionIcon("home"));
        menuActionSelectCruise.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.selectCruise.mnemonic"),'Z'));
        menuActionEditProgram.setIcon(SwingUtil.createActionIcon("program"));
        menuActionEditProgram.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editSelectedProgram.mnemonic"),'Z'));
        menuActionEditCruise.setIcon(SwingUtil.createActionIcon("cruise"));
        menuActionEditCruise.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editSelectedCruise.mnemonic"),'Z'));
        menuActionEditProtocol.setIcon(SwingUtil.createActionIcon("protocol"));
        menuActionEditProtocol.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editSelectedProtocol.mnemonic"),'Z'));
        menuActionEditCatches.setIcon(SwingUtil.createActionIcon("edit"));
        menuActionEditCatches.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editCatches.mnemonic"),'Z'));
        menuActionValidateCatches.setIcon(SwingUtil.createActionIcon("validate"));
        menuActionValidateCatches.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.validateCatches.mnemonic"),'Z'));
        menuActionGenerateCruiseReport.setIcon(SwingUtil.createActionIcon("report"));
        menuActionGenerateCruiseReport.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.generateSelectedCruiseReport.mnemonic"),'Z'));
        menuAdministration.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.menu.administration.mnemonic"),'Z'));
        menuImportTemporaryReferential.setIcon(SwingUtil.createActionIcon("temporary-referential-import"));
        menuImportTemporaryReferential.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.importTemporaryReferential.mnemonic"),'Z'));
        menuEditSampleCategoryModel.setIcon(SwingUtil.createActionIcon("sampleOrder"));
        menuEditSampleCategoryModel.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.editSampleCategoryModel.mnemonic"),'Z'));
        menuHelp.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.menu.help.mnemonic"),'Z'));
        menuShowHelp.setIcon(SwingUtil.createActionIcon("help"));
        menuShowHelp.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.showHelp.mnemonic"),'Z'));
        menuHelpSite.setIcon(SwingUtil.createActionIcon("site"));
        menuHelpSite.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.site.mnemonic"),'Z'));
        menuHelpAbout.setIcon(SwingUtil.createActionIcon("about"));
        menuHelpAbout.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.about.mnemonic"),'Z'));
        menuChangeLocale.setIcon(SwingUtil.createActionIcon("translate"));
        menuChangeLocale.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.changeLocale.mnemonic"),'Z'));
        menuChangeLocaleUK.setIcon(SwingUtil.createActionIcon("i18n-uk"));
        menuChangeLocaleUK.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.changeLocaleUK.mnemonic"),'Z'));
        menuChangeLocaleFR.setIcon(SwingUtil.createActionIcon("i18n-fr"));
        menuChangeLocaleFR.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.main.action.changeLocaleFR.mnemonic"),'Z'));
        bottomBar.setMargin(new java.awt.Insets(0, 0, 0, 5));
        showHelp.setIcon(SwingUtil.createActionIcon("show-help"));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, menuFileConfiguration, "tutti.main.menu.action.configuration.help");
        registerHelpId(_broker, menuFileUpdateApplication, "tutti.main.menu.action.updateApplication.help");
        registerHelpId(_broker, menuFileUpdateReport, "tutti.main.menu.action.updateReport.help");
        registerHelpId(_broker, menuFileManageDb, "tutti.main.menu.action.manageDb.help");
        registerHelpId(_broker, menuFileExit, "tutti.main.menu.action.exit.help");
        registerHelpId(_broker, menuActionSelectCruise, "tutti.main.menu.action.selectCruise.help");
        registerHelpId(_broker, menuActionEditProgram, "tutti.main.menu.action.editProgram.help");
        registerHelpId(_broker, menuActionEditCruise, "tutti.main.menu.action.editCruise.help");
        registerHelpId(_broker, menuActionEditProtocol, "tutti.main.menu.action.editProtocol.help");
        registerHelpId(_broker, menuActionEditCatches, "tutti.main.menu.action.editCatches.help");
        registerHelpId(_broker, menuActionValidateCatches, "tutti.main.menu.action.validateCatches.help");
        registerHelpId(_broker, menuActionGenerateCruiseReport, "tutti.main.menu.action.generateSelectedCruiseReport.help");
        registerHelpId(_broker, menuImportTemporaryReferential, "tutti.main.menu.action.importTemporaryReferential.help");
        registerHelpId(_broker, menuEditSampleCategoryModel, "tutti.main.menu.action.editSampleCategoryModel.help");
        registerHelpId(_broker, menuShowHelp, "tutti.index.help");
        registerHelpId(_broker, menuHelpSite, "tutti.main.menu.action.site.help");
        registerHelpId(_broker, menuHelpAbout, "tutti.main.menu.action.about.help");
        registerHelpId(_broker, menuChangeLocale, "tutti.main.menu.action.changeLocale.help");
        registerHelpId(_broker, menuChangeLocaleUK, "tutti.main.menu.action.changeLocaleUK.help");
        registerHelpId(_broker, menuChangeLocaleFR, "tutti.main.menu.action.changeLocaleFR.help");
        registerHelpId(_broker, showHelp, "tutti.main.menu.action.showHelp.help");
        registerHelpId(_broker, body, "tutti.main.help");
        _broker.prepareUI(this);
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("mainFrame", mainFrame);
        createModel();
        createBroker();
        createBusyBlockLayerUI();
        createMenu();
        createMenuFile();
        createMenuFileConfiguration();
        createMenuFileUpdateApplication();
        createMenuFileUpdateReport();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createMenuFileManageDb();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createMenuFileExit();
        createMenuActions();
        createMenuActionSelectCruise();
        createMenuActionEditProgram();
        createMenuActionEditCruise();
        createMenuActionEditProtocol();
        createMenuActionEditCatches();
        createMenuActionValidateCatches();
        createMenuActionGenerateCruiseReport();
        createMenuAdministration();
        createMenuImportTemporaryReferential();
        createMenuEditSampleCategoryModel();
        createMenuHelp();
        createMenuShowHelp();
        createMenuHelpSite();
        createMenuHelpAbout();
        createMenuChangeLocale();
        createMenuChangeLocaleUK();
        createMenuChangeLocaleFR();
        createBottomBar();
        createValidatorMessageWidget();
        createShowHelp();
        createBody();
        createStatus();
        // inline creation of mainFrame
        setName("mainFrame");
        SwingUtil.setComponentHeight(mainFrame,600);
        SwingUtil.setComponentWidth(mainFrame,800);
        setTitle(_("tutti.main.title.applicationName"));
        mainFrame.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__mainFrame"));
        
        /*protected void $afterCompleteSetup() {
                handler.afterInitUI();
            }*/;// registers 17 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 17 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCKING_COLOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("config", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && model.getConfig() != null) {
                    busyBlockLayerUI.setBlockingColor(model.getConfig().getColorBlockingLayer());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("config", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BUSY_BLOCK_LAYER_UI_BLOCK, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("busy", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    busyBlockLayerUI.setBlock(model.isBusy());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("busy", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_CONFIGURATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileConfiguration.setEnabled(model.getScreen() != TuttiScreen.CONFIG);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_FILE_MANAGE_DB_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuFileManageDb.setEnabled(model.getScreen() != TuttiScreen.MANAGE_DB);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTIONS_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActions.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_SELECT_CRUISE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionSelectCruise.setEnabled(model.getScreen() != TuttiScreen.SELECT_CRUISE);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROGRAM_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("programFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProgram.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROGRAM && model.isProgramFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("programFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CRUISE_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCruise.setEnabled(model.getScreen() != TuttiScreen.EDIT_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_PROTOCOL_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("protocolFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditProtocol.setEnabled(model.getScreen() != TuttiScreen.EDIT_PROTOCOL && model.isProtocolFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("protocolFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_EDIT_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionEditCatches.setEnabled(model.getScreen() != TuttiScreen.EDIT_FISHING_OPERATION && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_VALIDATE_CATCHES_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionValidateCatches.setEnabled(model.getScreen() != TuttiScreen.VALIDATE_CRUISE && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ACTION_GENERATE_CRUISE_REPORT_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuActionGenerateCruiseReport.setEnabled(model.getScreen() != TuttiScreen.REPORT && model.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_ADMINISTRATION_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuAdministration.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_IMPORT_TEMPORARY_REFERENTIAL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("screen", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuImportTemporaryReferential.setEnabled(model.getScreen() != TuttiScreen.IMPORT_TEMPORARY_REFERENTIAL);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("screen", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_EDIT_SAMPLE_CATEGORY_MODEL_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("dbLoaded", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuEditSampleCategoryModel.setEnabled(model.isDbLoaded());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("dbLoaded", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_UK_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleUK.setEnabled(!handler.acceptLocale(model.getLocale(), "en_GB"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MENU_CHANGE_LOCALE_FR_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("locale", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    menuChangeLocaleFR.setEnabled(!handler.acceptLocale(model.getLocale(), "fr_FR"));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("locale", this);
                }
            }
        });
    }

}