package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveBenthosSubBatchAction.java 1388 2013-11-26 08:03:42Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-3.0/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/RemoveBenthosSubBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;

import javax.swing.JOptionPane;
import java.util.Set;

import static org.nuiton.i18n.I18n._;

/**
 * To remove a species batch children.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RemoveBenthosSubBatchAction extends AbstractTuttiAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {

    /**
     * Selected row to treat.
     *
     * @since 2.8
     */
    protected int rowIndex;

    /**
     * Rows to delete after all.
     *
     * @since 3.0-rc-1
     */
    protected Set<BenthosBatchRowModel> rowToRemove;

    /**
     * Parent batch of rows to delete.
     *
     * @since 3.0-rc-1
     */
    protected BenthosBatchRowModel parentBatch;

    public RemoveBenthosSubBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();

        rowIndex = -1;

        if (result) {
            int answer = JOptionPane.showConfirmDialog(getContext().getActionUI(),
                                                       _("tutti.editBenthosBatch.action.removeSubBatch.confirm.message"),
                                                       _("tutti.editBenthosBatch.action.removeSubBatch.confirm.title"),
                                                       JOptionPane.YES_NO_OPTION);
            result = answer == JOptionPane.YES_OPTION;
        }

        return result;
    }

    @Override
    public void doAction() throws Exception {

        TuttiPersistence persistenceService =
                getContext().getPersistenceService();

        JXTable table = handler.getTable();

        rowIndex = SwingUtil.getSelectedModelRow(table);

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove sub batch if no batch selected");

        parentBatch = handler.getTableModel().getEntry(rowIndex);

        Preconditions.checkState(!TuttiEntities.isNew(parentBatch),
                                 "Can't remove sub batch if batch is not persisted");

        // save parent batch (will destroy all his childs from db)
        persistenceService.deleteSpeciesSubBatch(parentBatch.getId());

        // collect of rows to remove from model
        rowToRemove = Sets.newHashSet();

        handler.collectChildren(parentBatch, rowToRemove);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        JXTable table = handler.getTable();

        // remove all rows from the model
        getModel().getRows().removeAll(rowToRemove);

        // remove childs from parent batch
        parentBatch.setChildBatch(null);

        // refresh table from parent batch row index to the end
        handler.getTableModel().fireTableDataChanged();

        // select parent batch row
        TuttiUIUtil.selectFirstCellOnRow(table, rowIndex, true);
    }
}
