/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.ui.swing.TuttiDbUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import java.awt.Component;
import java.io.File;
import java.util.Map;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;
import org.nuiton.updater.ApplicationUpdaterCallback;
import org.nuiton.updater.DownloadMonitor;

public class UpdateDbAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(UpdateDbAction.class);
    protected ApplicationInfo updateDbVersion;

    public UpdateDbAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.dbManager.action.upgradeDb.tip", (Object[])new Object[0]));
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        this.updateDbVersion = null;
        if (doAction) {
            doAction = this.getContext().checkUpdateDataReachable();
        }
        if (doAction) {
            ApplicationUpdater up = new ApplicationUpdater();
            Map dbVersions = up.getVersions(this.getConfig().getUpdateDataUrl(), this.getConfig().getDataDirectory());
            this.updateDbVersion = (ApplicationInfo)dbVersions.get("db");
            if (this.getContext().isDbExist() && this.updateDbVersion != null && this.updateDbVersion.newVersion != null) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.dbManager.updatedb.found", (Object[])new Object[]{this.updateDbVersion.newVersion}), I18n._((String)"tutti.common.askBeforeUpdate.help", (Object[])new Object[0]));
                int i = JOptionPane.showConfirmDialog((Component)((MainUIHandler)this.getHandler()).getUI(), htmlMessage, I18n._((String)"tutti.dbManager.title.confirm.updatedb", (Object[])new Object[0]), 2, 3);
                doAction = i == 0;
            }
        }
        return doAction;
    }

    @Override
    public void doAction() {
        TuttiUIContext context = this.getContext();
        TuttiApplicationConfig config = context.getConfig();
        File current = config.getDataDirectory();
        String url = config.getUpdateDataUrl();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Try to install / update db (current data location: %s), using update url: %s", current, url));
        }
        File dest = new File(config.getTuttiBasedir(), "NEW");
        ProgressionModel progressionModel = new ProgressionModel();
        context.getActionUI().getModel().setProgressionModel(progressionModel);
        progressionModel.setMessage(I18n._((String)"tutti.dbManager.action.upgradeDb.check", (Object[])new Object[0]));
        TuttiDbUpdaterCallBack callback = new TuttiDbUpdaterCallBack(this, progressionModel);
        ApplicationUpdater up = new ApplicationUpdater();
        up.update(url, current, dest, false, (ApplicationUpdaterCallback)callback, (DownloadMonitor)progressionModel);
        if (callback.isDbUpdated()) {
            this.sendMessage(I18n._((String)"tutti.dbManager.action.upgradeDb.done", (Object[])new Object[]{this.updateDbVersion.newVersion}));
        } else {
            this.sendMessage(I18n._((String)"tutti.dbManager.action.upgradeDb.upToDate", (Object[])new Object[0]));
        }
    }

    @Override
    public void postSuccessAction() {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        super.postSuccessAction();
    }

    @Override
    public void postFailedAction(Throwable error) {
        ((MainUIHandler)this.handler).reloadDbManagerText();
        super.postFailedAction(error);
    }
}

