/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.TuttiCsvUtil;
import fr.ifremer.tutti.service.catches.multipost.CatchRow;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;

public class CatchRowModel
extends TuttiCsvUtil.AbstractTuttiImportExportModel<CatchRow> {
    public CatchRowModel(char separator) {
        this(separator, null);
    }

    public CatchRowModel(char separator, List<Species> species) {
        super(separator);
        ValueFormatter<Serializable> caracteristicValueFormatter = new ValueFormatter<Serializable>(){

            public String format(Serializable value) {
                String result = "";
                if (value != null) {
                    if (CaracteristicQualitativeValue.class.isAssignableFrom(value.getClass())) {
                        CaracteristicQualitativeValue cqv = (CaracteristicQualitativeValue)value;
                        result = cqv.getId();
                    } else {
                        result = String.valueOf(value);
                    }
                }
                return result;
            }
        };
        this.newColumnForImportExport("id");
        this.newColumnForImportExport("parentId");
        this.newColumnForExport("species", (ValueFormatter)new ValueFormatter<Species>(){

            public String format(Species value) {
                return value != null ? String.valueOf(value.getReferenceTaxonId()) : null;
            }
        });
        if (species == null) {
            species = Lists.newArrayList();
        }
        Map speciesMap = TuttiEntities.splitByTaxonId((Iterable)species);
        this.newForeignKeyColumn("species", Species.class, "referenceTaxonId", speciesMap);
        this.newColumnForImportExport("categoryId", TuttiCsvUtil.INTEGER);
        this.newColumnForExport("categoryValue", (ValueFormatter)caracteristicValueFormatter);
        this.newMandatoryColumn("categoryValue", (ValueParser)TuttiCsvUtil.STRING);
        this.newColumnForImportExport("categoryWeight", TuttiCsvUtil.FLOAT);
        this.newColumnForImportExport("weight", TuttiCsvUtil.FLOAT);
        this.newColumnForImportExport("number", TuttiCsvUtil.INTEGER);
        this.newColumnForImportExport("comment");
        this.newColumnForImportExport("toConfirm", TuttiCsvUtil.PRIMITIVE_BOOLEAN);
    }

    public CatchRow newEmptyInstance() {
        return new CatchRow();
    }
}

