package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: ImportMultiPostAction.java 1247 2013-09-28 12:15:25Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.9/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/ImportMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractImportMultiPostAction;
import fr.ifremer.tutti.ui.swing.content.operation.catches.MultiPostImportLogDialog;

import javax.swing.JTextArea;
import java.awt.Dialog;
import java.util.Collection;
import java.util.Map;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ImportMultiPostAction extends AbstractImportMultiPostAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {

    protected Map<String, Object> notImportedData;

    public ImportMultiPostAction(SpeciesBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiSpecies";
    }

    @Override
    protected String getFileExtensionDescription() {
        return _("tutti.common.file.tuttiSpecies");
    }

    @Override
    protected String getFileChooserTitle() {
        return _("tutti.editSpeciesBatch.action.importMultiPost.sourceFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return _("tutti.editSpeciesBatch.action.importMultiPost.sourceFile.button");
    }

    @Override
    public void releaseAction() {
        notImportedData = null;
        super.releaseAction();
    }

    @Override
    protected void importBatches(FishingOperation operation) {
        notImportedData = multiPostImportExportService.importSpecies(file, operation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        if (!notImportedData.isEmpty()) {
            MultiPostImportLogDialog dialog = new MultiPostImportLogDialog((Dialog) getContext().getActionUI());

            Collection<SpeciesBatch> notImportedSpeciesBatches =
                    (Collection<SpeciesBatch>) notImportedData.get(MultiPostImportService.BATCHES_KEY);

            StringBuffer stringBuffer = new StringBuffer();
            Float totalSortedWeight = (Float) notImportedData.get(CatchBatch.PROPERTY_SPECIES_TOTAL_SORTED_WEIGHT);
            if (totalSortedWeight != null) {
                stringBuffer.append("- " + _("tutti.multiPostImportLog.totalSortedWeight", totalSortedWeight) + "\n");
            }

            Float inertWeight = (Float) notImportedData.get(CatchBatch.PROPERTY_SPECIES_TOTAL_INERT_WEIGHT);
            if (inertWeight != null) {
                stringBuffer.append("- " + _("tutti.multiPostImportLog.inertWeight", inertWeight) + "\n");
            }

            Float livingNotItemizedWeight =
                    (Float) notImportedData.get(CatchBatch.PROPERTY_SPECIES_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT);
            if (livingNotItemizedWeight != null) {
                stringBuffer.append("- " + _("tutti.multiPostImportLog.livingNotItemizedWeight", livingNotItemizedWeight) + "\n");
            }

            for (SpeciesBatch sb : notImportedSpeciesBatches) {
                stringBuffer.append("- " + decorate(sb.getSpecies()) + " / " + decorate(sb.getSampleCategoryValue()) + "\n");
            }

            if (stringBuffer.length() > 0) {
                JTextArea batchList = dialog.getBatchList();
                batchList.setText(stringBuffer.toString());
                dialog.setSize(400, 300);
                dialog.setLocationRelativeTo(getContext().getMainUI());
                dialog.setVisible(true);
            }
        }

        sendMessage(_("tutti.editSpeciesBatch.action.importMultiPost.success", file));
    }
}
