/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.db;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.config.TuttiPersistenceConfig;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.db.ExportDbAction;
import fr.ifremer.tutti.ui.swing.content.db.ImportDbAction;
import java.io.File;
import java.util.Date;
import org.nuiton.i18n.I18n;

public class ReimportDbAction
extends AbstractMainUITuttiAction {
    protected File backupFile;
    protected File importFile;
    protected String jdbcUrl;

    public ReimportDbAction(MainUIHandler handler) {
        super(handler, true);
        this.setActionDescription(I18n._((String)"tutti.dbManager.action.importDb.tip", (Object[])new Object[0]));
    }

    @Override
    public boolean prepareAction() throws Exception {
        this.jdbcUrl = null;
        this.importFile = null;
        this.backupFile = null;
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.jdbcUrl = TuttiPersistenceConfig.getInstance().getJdbcUrl();
            if (((TuttiUIContext)this.getModel()).isDbExist()) {
                this.displayInfoMessage(I18n._((String)"tutti.dbManager.title.backup.db", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.importDb.backup.db", (Object[])new Object[0]));
                this.backupFile = this.saveFile(this.getConfig().getServiceConfig().getPersistenceConfig().getDbBackupDirectory(), "tutti-db-" + ExportDbAction.df.format(new Date()), "zip", I18n._((String)"tutti.dbManager.title.choose.dbExportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbExportFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
                if (this.backupFile == null) {
                    this.displayWarningMessage(I18n._((String)"tutti.dbManager.title.backup.db", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.importdb.no.backup.db.choosen", (Object[])new Object[0]));
                    doAction = false;
                }
            }
            if (doAction && this.importFile == null) {
                this.importFile = this.chooseFile(I18n._((String)"tutti.dbManager.title.choose.dbImportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.chooseDbFile", (Object[])new Object[0]), "^.*\\.zip", I18n._((String)"tutti.common.file.zip", (Object[])new Object[0]));
                if (this.importFile == null) {
                    this.displayWarningMessage(I18n._((String)"tutti.dbManager.title.choose.dbImportFile", (Object[])new Object[0]), I18n._((String)"tutti.dbManager.action.importdb.no.import.file.choosen", (Object[])new Object[0]));
                    doAction = false;
                }
            }
            if (doAction) {
                ProgressionModel progressionModel = new ProgressionModel();
                progressionModel.setTotal(3);
                this.setProgressionModel(progressionModel);
                this.getContext().getPersistenceService().checkImportStructure(this.importFile);
            }
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        this.backupFile = null;
        this.importFile = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.importFile);
        Preconditions.checkNotNull((Object)this.backupFile);
        ProgressionModel progressionModel = this.getProgressionModel();
        progressionModel.increments(I18n._((String)"tutti.reimport.step.closeDb", (Object[])new Object[]{this.jdbcUrl}));
        this.getContext().setDbLoaded(false);
        ((MainUIHandler)this.getHandler()).reloadPersistenceService();
        progressionModel.increments(I18n._((String)"tutti.reimport.step.backupDb", (Object[])new Object[]{this.backupFile}));
        this.getContext().getPersistenceService().exportDb(this.backupFile);
        this.getContext().clearDbContext();
        String actionContent = ImportDbAction.class.getName() + ":" + this.importFile.getAbsolutePath();
        File startActionFile = this.getConfig().getStartActionFile();
        TuttiIOUtil.writeContent((File)startActionFile, (String)actionContent, (String)I18n._((String)"tutti.error.write.startActionFile", (Object[])new Object[]{startActionFile}));
        progressionModel.increments(I18n._((String)"tutti.reimport.step.reloadApplication", (Object[])new Object[0]));
        RunTutti.closeTutti((MainUIHandler)this.getHandler(), 89);
    }
}

