/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.RunTutti;
import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.SelectCruiseAction;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelUI;
import fr.ifremer.tutti.ui.swing.content.config.TuttiConfigUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.db.DbManagerUI;
import fr.ifremer.tutti.ui.swing.content.db.OpenDbAction;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.RemoveablePropertyChangeListener;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiUIAction;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.net.URL;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.session.SwingSession;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.i18n.I18n;

public class MainUIHandler
extends AbstractTuttiUIHandler<TuttiUIContext, MainUI> {
    private static final Log log = LogFactory.getLog(MainUIHandler.class);
    protected JComponent currentBody;
    protected PersistenceService persistenceService;

    protected MainUIHandler(TuttiUIContext context, MainUI ui) {
        super(context, ui);
        this.persistenceService = context.getPersistenceService();
        context.setMainUI(ui);
        context.setActionUI(new TuttiActionUI(ui, context));
    }

    public MainUIHandler(TuttiUIContext context) {
        super(context, null);
        this.persistenceService = null;
    }

    @Override
    public void beforeInitUI() {
        this.context.addPropertyChangeListener(new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (TuttiUIContext.PROPERTIES_TO_SAVE.contains(propertyName)) {
                    if ("cruiseId".equals(propertyName)) {
                        MainUIHandler.this.getDataContext().resetCruise();
                    }
                    if ("protocolId".equals(propertyName)) {
                        MainUIHandler.this.getDataContext().resetProtocol();
                    }
                    MainUIHandler.this.changeTitle();
                } else if (propertyName.equals("screen")) {
                    MainUIHandler.this.setScreen((TuttiScreen)((Object)evt.getNewValue()));
                }
            }
        });
        ((MainUI)this.ui).setContextValue(this.ui, MainUI.class.getName());
        this.context.addPropertyChangeListener("busy", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                MainUIHandler.this.updateBusyState(newvalue != null && newvalue != false);
            }
        });
        this.context.addPropertyChangeListener("hideBody", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Boolean newvalue = (Boolean)evt.getNewValue();
                if (MainUIHandler.this.getUI() != null && ((MainUI)MainUIHandler.this.getUI()).getBody() != null) {
                    ((MainUI)MainUIHandler.this.getUI()).getBody().setVisible(newvalue != null && newvalue != false);
                }
            }
        });
    }

    protected void updateBusyState(boolean busy) {
        if (busy) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"block ui in busy mode");
            }
            ((MainUI)this.ui).setCursor(Cursor.getPredefinedCursor(3));
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"unblock ui in none busy mode");
            }
            ((MainUI)this.ui).setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        SwingUtil.setLayerUI((JComponent)((MainUI)this.ui).getBody(), (LayerUI)((MainUI)this.ui).getBusyBlockLayerUI());
        ((MainUI)this.ui).applyDataBinding("menuChangeLocaleFR.enabled");
        ((MainUI)this.ui).applyDataBinding("menuChangeLocaleUK.enabled");
        SwingSession swingSession = this.context.getSwingSession();
        swingSession.add((Component)((Object)this.ui));
        swingSession.save();
        this.changeTitle();
        JToolBar bar = ((MainUI)this.ui).getBottomBar();
        ((MainUI)this.ui).getStatus().addWidget((Component)bar, 0);
        if (this.context.isDbLoaded()) {
            TuttiUIAction<SelectCruiseAction> uiAction = TuttiActionHelper.createUIAction(this, SelectCruiseAction.class);
            SelectCruiseAction logicAction = uiAction.getLogicAction();
            logicAction.setSkipCheckCurrentScreen(true);
            logicAction.setActionDescription(((MainUI)this.ui).getMenuActionSelectCruise().getToolTipText());
            uiAction.actionPerformed(null);
        } else if (this.context.isDbExist()) {
            TuttiUIAction<OpenDbAction> uiAction = TuttiActionHelper.createUIAction(this, OpenDbAction.class);
            OpenDbAction logicAction = uiAction.getLogicAction();
            logicAction.setSkipCheckCurrentScreen(true);
            uiAction.actionPerformed(null);
        } else {
            this.context.clearDbContext();
            this.context.setScreen(TuttiScreen.MANAGE_DB);
        }
    }

    @Override
    protected JComponent getComponentToFocus() {
        return this.currentBody;
    }

    @Override
    public void onCloseUI() {
        PropertyChangeListener[] propertyChangeListeners;
        this.context.setScreen(null);
        this.context.removeMessageNotifier(this);
        for (PropertyChangeListener listener : propertyChangeListeners = this.context.getPropertyChangeListeners()) {
            if (listener instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listener;
                listener = (PropertyChangeListener)proxy.getListener();
            }
            if (!(listener instanceof RemoveablePropertyChangeListener)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove listener: " + listener));
            }
            this.context.removePropertyChangeListener(listener);
        }
        if (this.ui != null) {
            JAXXBinding[] bindings;
            for (JAXXBinding binding : bindings = ((MainUI)this.ui).getDataBindings()) {
                SwingUtil.removeDataBinding((JAXXObject)this.ui, (String[])new String[]{binding.getId()});
            }
            ((MainUI)this.ui).setVisible(false);
            ((MainUI)this.ui).dispose();
        }
    }

    @Override
    public SwingValidator<TuttiUIContext> getValidator() {
        return null;
    }

    public void reloadUI() {
        this.onCloseUI();
        RunTutti.startTutti(this.getContext(), false);
    }

    public boolean acceptLocale(Locale l, String expected) {
        return l != null && l.toString().equals(expected);
    }

    public void changeLocale(Locale locale) {
        ((TuttiUIContext)this.getModel()).setLocale(locale);
        I18n.setDefaultLocale((Locale)this.getConfig().getI18nLocale());
        this.getContext().reloadDecoratorService();
        this.reloadUI();
    }

    public void gotoSite() {
        TuttiApplicationConfig config = this.context.getConfig();
        URL siteURL = config.getSiteUrl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("goto " + siteURL));
        }
        TuttiUIUtil.openLink(siteURL);
    }

    public void showHelp() {
        ((TuttiUIContext)this.getModel()).showHelp((JAXXContext)this.ui, ((MainUI)this.ui).getBroker(), null);
    }

    @Override
    public final void showInformationMessage(String message) {
        ((MainUI)this.ui).getStatus().setStatus("<html><body>" + message + "</body></html>");
    }

    public void registerValidator(SwingValidator validator) {
        ((MainUI)this.ui).getValidatorMessageWidget().registerValidator(validator);
    }

    @Override
    public void clearValidators() {
        ((MainUI)this.ui).getValidatorMessageWidget().clearValidators();
    }

    public boolean quitCurrentScreen() {
        boolean canClose;
        if (this.context.getScreen() == null || this.currentBody == null) {
            canClose = true;
            if (log.isWarnEnabled()) {
                log.warn((Object)"==================================================");
                log.warn((Object)"No screen, Should then skipCheckCurrent in action.");
                log.warn((Object)"==================================================");
            }
        } else {
            TuttiUI body = (TuttiUI)((Object)this.currentBody);
            Preconditions.checkNotNull((Object)this.currentBody);
            Object handler = body.getHandler();
            canClose = handler instanceof CloseableUI ? ((CloseableUI)handler).quitUI() : true;
        }
        return canClose;
    }

    public AbstractTuttiUIHandler getCurrentHandler() {
        TuttiUI body = (TuttiUI)((Object)this.currentBody);
        return body.getHandler();
    }

    public void reloadPersistenceService() {
        this.persistenceService = this.context.reloadPersistenceService();
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    protected void setScreen(TuttiScreen screen) {
        if (this.currentBody != null) {
            TuttiUI body = (TuttiUI)((Object)this.currentBody);
            ((AbstractTuttiUIHandler)body.getHandler()).onCloseUI();
            this.context.getSwingSession().save();
            ((MainUI)this.ui).getBody().remove((Component)this.currentBody);
            this.currentBody = null;
        }
        if (screen != null) {
            Icon icon;
            String screenTitle;
            JComponent screenUI;
            JToolBar rightDecoration = null;
            switch (screen) {
                case CONFIG: {
                    screenUI = new TuttiConfigUI(this.ui);
                    screenTitle = I18n._((String)"tutti.config.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuFileConfiguration().getIcon();
                    break;
                }
                case EDIT_SAMPLE_CATEGORY_MODEL: {
                    screenUI = new EditSampleCategoryModelUI(this.ui);
                    screenTitle = I18n._((String)"tutti.editSampleCategoryModel.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuEditSampleCategoryModel().getIcon();
                    break;
                }
                default: {
                    screenUI = new DbManagerUI(this.ui);
                    screenTitle = I18n._((String)"tutti.dbMabager.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuActionManageDb().getIcon();
                    break;
                }
                case SELECT_CRUISE: {
                    screenUI = new SelectCruiseUI(this.ui);
                    screenTitle = I18n._((String)"tutti.selectCruise.title", (Object[])new Object[0]);
                    icon = ((MainUI)this.ui).getMenuActionSelectCruise().getIcon();
                    break;
                }
                case EDIT_PROGRAM: {
                    screenTitle = EditProgramUIHandler.getTitle(this.context.isProgramFilled());
                    screenUI = new EditProgramUI(this.ui);
                    icon = ((MainUI)this.ui).getMenuActionEditProgram().getIcon();
                    break;
                }
                case EDIT_CRUISE: {
                    screenTitle = EditCruiseUIHandler.getTitle(this.context.isCruiseFilled());
                    screenUI = new EditCruiseUI(this.ui);
                    rightDecoration = ((EditCruiseUI)screenUI).getTopToolBar();
                    icon = ((MainUI)this.ui).getMenuActionEditCruise().getIcon();
                    break;
                }
                case EDIT_PROTOCOL: {
                    screenTitle = EditProtocolUIHandler.getTitle(this.context.isProtocolFilled());
                    screenUI = new EditProtocolUI(this.ui);
                    icon = ((MainUI)this.ui).getMenuActionEditProtocol().getIcon();
                    break;
                }
                case EDIT_FISHING_OPERATION: {
                    screenTitle = I18n._((String)"tutti.fishingOperations.title.edit.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                    icon = ((MainUI)this.ui).getMenuActionEditCatches().getIcon();
                    screenUI = new FishingOperationsUI(this.ui);
                    break;
                }
                case IMPORT_TEMPORARY_REFERENTIAL: {
                    screenTitle = I18n._((String)"tutti.manageTemporaryReferential.title", (Object[])new Object[0]);
                    screenUI = new ManageTemporaryReferentialUI(this.ui);
                    icon = ((MainUI)this.ui).getMenuImportTemporaryReferential().getIcon();
                    break;
                }
                case VALIDATE_CRUISE: {
                    screenUI = new ValidateCruiseUI(this.ui);
                    screenTitle = I18n._((String)"tutti.fishingOperations.title.validate.operations", (Object[])new Object[]{this.getSelectedCruiseTitle()});
                    icon = ((MainUI)this.ui).getMenuActionValidateCatches().getIcon();
                }
            }
            JButton showHelp = ((MainUI)this.ui).getShowHelp();
            if (rightDecoration == null) {
                rightDecoration = new JToolBar();
                rightDecoration.setFloatable(false);
                rightDecoration.setOpaque(false);
                rightDecoration.setBorderPainted(false);
            } else {
                rightDecoration.remove(showHelp);
            }
            rightDecoration.add((Component)showHelp, 0);
            this.currentBody = screenUI;
            this.context.getSwingSession().add((Component)this.currentBody, true);
            ((MainUI)this.ui).getBody().setTitle(screenTitle);
            ((MainUI)this.ui).getBody().add((Component)this.currentBody);
            ((MainUI)this.ui).getBody().setLeftDecoration((JComponent)new JLabel(icon));
            ((MainUI)this.ui).getBody().setRightDecoration((JComponent)rightDecoration);
            ((MainUI)this.ui).getBody().getRightDecoration().setVisible(true);
        }
    }

    public void changeTitle() {
        String title = this.getSelectedCruiseTitle();
        ((MainUI)this.ui).setTitle(I18n._((String)"tutti.main.title.application", (Object[])new Object[]{this.getConfig().getVersion(), title}));
    }

    protected String getSelectedCruiseTitle() {
        String title;
        if (this.context.isDbLoaded()) {
            if (this.context.isProgramFilled()) {
                Program program = this.getDataContext().getProgram();
                title = I18n._((String)"tutti.main.title.selectedProgram", (Object[])new Object[]{program.getName()}) + " / ";
                if (this.context.isCruiseFilled()) {
                    Cruise cruise = this.getDataContext().getCruise();
                    if (cruise != null) {
                        title = title + I18n._((String)"tutti.main.title.selectedCruise", (Object[])new Object[]{cruise.getName()});
                    }
                } else {
                    title = title + I18n._((String)"tutti.main.title.noSelectedCruise", (Object[])new Object[0]);
                }
            } else {
                title = I18n._((String)"tutti.main.title.noSelectedProgram", (Object[])new Object[0]);
            }
            title = title + " / ";
            if (this.context.isProtocolFilled()) {
                TuttiProtocol protocol = this.getDataContext().getProtocol();
                title = title + I18n._((String)"tutti.main.title.selectedProtocol", (Object[])new Object[]{protocol.getName()});
            } else {
                title = title + I18n._((String)"tutti.main.title.noSelectedProtocol", (Object[])new Object[0]);
            }
        } else {
            title = I18n._((String)"tutti.main.title.nodb", (Object[])new Object[0]);
        }
        return title;
    }

    public void setBodyTitle(String title) {
        ((MainUI)this.ui).getBody().setTitle(title);
    }
}

