/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import jaxx.runtime.SwingUtil;
import org.apache.commons.collections.CollectionUtils;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class AttachmentCellRenderer
extends DefaultTableCellRenderer {
    public static final String TEXT_PATTERN = "<html><body>%s</body></html>";
    private static final long serialVersionUID = 1L;
    private final String noneText;
    private final Decorator<Attachment> decorator;

    public static AttachmentCellRenderer newRender(Decorator<Attachment> decorator) {
        return new AttachmentCellRenderer(decorator);
    }

    protected AttachmentCellRenderer(Decorator<Attachment> decorator) {
        this.setHorizontalAlignment(0);
        this.setIcon(SwingUtil.createActionIcon((String)"edit-attachment"));
        this.noneText = I18n.n_((String)"tutti.attachmentEditor.none.tip", (Object[])new Object[0]);
        this.decorator = decorator;
    }

    @Override
    protected void setValue(Object value) {
    }

    @Override
    public JComponent getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String toolTipTextValue;
        List attachments = (List)value;
        if (CollectionUtils.isEmpty((Collection)attachments)) {
            toolTipTextValue = "<i>" + I18n._((String)this.noneText, (Object[])new Object[0]) + "</i>";
        } else {
            StringBuilder sb = new StringBuilder();
            for (Attachment attachment : attachments) {
                sb.append("<br/>").append(this.decorator.toString((Object)attachment));
            }
            toolTipTextValue = sb.substring(5);
        }
        String textValue = ButtonAttachment.getButtonText(attachments);
        boolean editable = table.isCellEditable(row, column);
        toolTipTextValue = String.format(TEXT_PATTERN, toolTipTextValue);
        this.setEnabled(editable);
        this.setText(textValue);
        this.setToolTipText(toolTipTextValue);
        this.setBackground(null);
        return this;
    }
}

