package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditFishingOperationUIModel.java 876 2013-04-26 17:21:26Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.5.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/EditFishingOperationUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.spatial.SexagecimalPosition;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TabContentModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.DateUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import static org.nuiton.i18n.I18n.n_;

/**
 * Model for UI {@link EditFishingOperationUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditFishingOperationUIModel extends AbstractTuttiBeanUIModel<FishingOperation, EditFishingOperationUIModel>
        implements AttachmentModelAware, TabContentModel, FishingOperation {

    private static final long serialVersionUID = 1L;

    public static final String TITLE = n_("tutti.editFishingOperation.tab.general");

    public static final String PROPERTY_PERSISTED = "persisted";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DEGREE = "gearShootingStartLatitudeDegree";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_MINUTE = "gearShootingStartLatitudeMinute";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DECIMAL_MINUTE = "gearShootingStartLatitudeDecimalMinute";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_SECOND = "gearShootingStartLatitudeSecond";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DEGREE = "gearShootingStartLongitudeDegree";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_MINUTE = "gearShootingStartLongitudeMinute";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DECIMAL_MINUTE = "gearShootingStartLongitudeDecimalMinute";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_SECOND = "gearShootingStartLongitudeSecond";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DEGREE = "gearShootingEndLatitudeDegree";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_MINUTE = "gearShootingEndLatitudeMinute";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DECIMAL_MINUTE = "gearShootingEndLatitudeDecimalMinute";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_SECOND = "gearShootingEndLatitudeSecond";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DEGREE = "gearShootingEndLongitudeDegree";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_MINUTE = "gearShootingEndLongitudeMinute";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DECIMAL_MINUTE = "gearShootingEndLongitudeDecimalMinute";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_SECOND = "gearShootingEndLongitudeSecond";

    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";

    /**
     * Delegate edit object.
     *
     * @since 1.3
     */
    protected final FishingOperation editObject = TuttiBeanFactory.newFishingOperation();

    protected SexagecimalPosition gearShootingStartLatitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingStartLongitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingEndLatitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingEndLongitudeAsSexagecimal;

    protected final List<Attachment> attachment = Lists.newArrayList();

    protected FishingOperation fishingOperation;

    protected String validationContext;

    protected CoordinateEditorType coordinateEditorType;

    protected boolean loadingData;

    protected static Binder<EditFishingOperationUIModel, FishingOperation> toBeanBinder =
            BinderFactory.newBinder(EditFishingOperationUIModel.class,
                                    FishingOperation.class);

    protected static Binder<FishingOperation, EditFishingOperationUIModel> fromBeanBinder =
            BinderFactory.newBinder(FishingOperation.class, EditFishingOperationUIModel.class);

    public EditFishingOperationUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
        gearShootingStartLatitudeAsSexagecimal = SexagecimalPosition.valueOf(getGearShootingStartLatitude());
        gearShootingStartLongitudeAsSexagecimal = SexagecimalPosition.valueOf(getGearShootingStartLongitude());
        gearShootingEndLatitudeAsSexagecimal = SexagecimalPosition.valueOf(getGearShootingEndLatitude());
        gearShootingEndLongitudeAsSexagecimal = SexagecimalPosition.valueOf(getGearShootingEndLongitude());
    }

    public boolean isLoadingData() {
        return loadingData;
    }

    public void setLoadingData(boolean loadingData) {
        this.loadingData = loadingData;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getIcon() {
        return null;
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty(getStationNumber())
               && getFishingOperationNumber() == null
               && getStrata() == null
               && getSubStrata() == null
               && getLocation() == null
               && gearShootingStartLatitudeAsSexagecimal.isNull()
               && gearShootingStartLongitudeAsSexagecimal.isNull()
               && getGearShootingStartDate() == null
               && gearShootingEndLatitudeAsSexagecimal.isNull()
               && gearShootingEndLongitudeAsSexagecimal.isNull()
               && getGearShootingEndDate() == null
               && !isFishingOperationRectiligne()
               && getTrawlDistance() == null
               && getFishingOperationValid() == null
               && CollectionUtils.isEmpty(getRecorderPerson())
               && getGear() == null
               && StringUtils.isEmpty(getComment())
               && CollectionUtils.isEmpty(getAttachment());
    }

    @Override
    protected FishingOperation newEntity() {
        return fishingOperation;
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
        firePropertyChange(PROPERTY_PERSISTED, null, isPersisted());
    }

    public boolean isPersisted() {
        return fishingOperation != null && !TuttiEntities.isNew(fishingOperation);
    }

    public Integer getGearShootingStartLatitudeDegree() {
        Integer result = gearShootingStartLatitudeAsSexagecimal.getDegre();
        if (gearShootingStartLatitudeAsSexagecimal.isSign()) {
            result *= -1;
        }
        return result;
    }

    public Integer getGearShootingStartLatitudeDecimalDegree() {
        return getGearShootingStartLatitudeDegree();
    }

    public void setGearShootingStartLatitudeDegree(Integer degree) {
        Object oldValue = getGearShootingStartLatitudeDegree();
        boolean sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        gearShootingStartLatitudeAsSexagecimal.setSign(sign);
        gearShootingStartLatitudeAsSexagecimal.setDegre(degree);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingStartLatitudeDecimalDegree(Integer degree) {
        setGearShootingStartLatitudeDegree(degree);
    }

    public Integer getGearShootingStartLatitudeMinute() {
        return gearShootingStartLatitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingStartLatitudeMinute(Integer minute) {
        Object oldValue = getGearShootingStartLatitudeMinute();
        gearShootingStartLatitudeAsSexagecimal.setMinute(minute);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingStartLatitudeDecimalMinute() {
        return gearShootingStartLatitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingStartLatitudeDecimalMinute(Float decimalMinute) {
        gearShootingStartLatitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        // 2013-01-22 kmorin: pass null as previous value, 
        // otherwise the filed is not filled with the value (I cannot explain why... :()
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingStartLatitudeSecond() {
        return gearShootingStartLatitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingStartLatitudeSecond(Integer second) {
        Object oldValue = getGearShootingStartLatitudeSecond();
        gearShootingStartLatitudeAsSexagecimal.setSeconde(second);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_SECOND, oldValue, second);
    }

    public Integer getGearShootingStartLongitudeDegree() {
        Integer result = gearShootingStartLongitudeAsSexagecimal.getDegre();
        if (gearShootingStartLongitudeAsSexagecimal.isSign()) {
            result *= -1;
        }
        return result;
    }

    public Integer getGearShootingStartLongitudeDecimalDegree() {
        return getGearShootingStartLongitudeDegree();
    }

    public void setGearShootingStartLongitudeDegree(Integer degree) {
        Object oldValue = getGearShootingStartLongitudeDegree();
        boolean sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        gearShootingStartLongitudeAsSexagecimal.setSign(sign);
        gearShootingStartLongitudeAsSexagecimal.setDegre(degree);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingStartLongitudeDecimalDegree(Integer degree) {
        setGearShootingStartLongitudeDegree(degree);
    }

    public Integer getGearShootingStartLongitudeMinute() {
        return gearShootingStartLongitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingStartLongitudeMinute(Integer minute) {
        Object oldValue = getGearShootingStartLongitudeMinute();
        gearShootingStartLongitudeAsSexagecimal.setMinute(minute);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingStartLongitudeDecimalMinute() {
        return gearShootingStartLongitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingStartLongitudeDecimalMinute(Float decimalMinute) {
        gearShootingStartLongitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        // 2013-01-22 kmorin: pass null as previous value,
        // otherwise the filed is not filled with the value (I cannot explain why... :()
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingStartLongitudeSecond() {
        return gearShootingStartLongitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingStartLongitudeSecond(Integer second) {
        Object oldValue = getGearShootingStartLongitudeSecond();
        gearShootingStartLongitudeAsSexagecimal.setSeconde(second);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_SECOND, oldValue, second);
    }

    public void setGearShootingStartTime(Date gearShootingStartDate) {
        Object oldValue = getGearShootingStartDate();
        if (oldValue != null) {
            setGearShootingStartDate(gearShootingStartDate);
        }
    }

    public Integer getGearShootingEndLatitudeDegree() {
        Integer result = gearShootingEndLatitudeAsSexagecimal.getDegre();
        if (gearShootingEndLatitudeAsSexagecimal.isSign()) {
            result *= -1;
        }
        return result;
    }

    public Integer getGearShootingEndLatitudeDecimalDegree() {
        return getGearShootingEndLatitudeDegree();
    }

    public void setGearShootingEndLatitudeDegree(Integer degree) {
        Object oldValue = getGearShootingEndLatitudeDegree();
        boolean sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        gearShootingEndLatitudeAsSexagecimal.setSign(sign);
        gearShootingEndLatitudeAsSexagecimal.setDegre(degree);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingEndLatitudeDecimalDegree(Integer degree) {
        setGearShootingEndLatitudeDegree(degree);
    }

    public Integer getGearShootingEndLatitudeMinute() {
        return gearShootingEndLatitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingEndLatitudeMinute(Integer minute) {
        Object oldValue = getGearShootingEndLatitudeMinute();
        gearShootingEndLatitudeAsSexagecimal.setMinute(minute);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingEndLatitudeDecimalMinute() {
        return gearShootingEndLatitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingEndLatitudeDecimalMinute(Float decimalMinute) {
        gearShootingEndLatitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        // 2013-01-22 kmorin: pass null as previous value,
        // otherwise the filed is not filled with the value (I cannot explain why... :()
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingEndLatitudeSecond() {
        return gearShootingEndLatitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingEndLatitudeSecond(Integer second) {
        Object oldValue = getGearShootingEndLatitudeSecond();
        gearShootingEndLatitudeAsSexagecimal.setSeconde(second);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_SECOND, oldValue, second);
    }

    public Integer getGearShootingEndLongitudeDegree() {
        Integer result = gearShootingEndLongitudeAsSexagecimal.getDegre();
        if (gearShootingEndLongitudeAsSexagecimal.isSign()) {
            result *= -1;
        }
        return result;
    }

    public Integer getGearShootingEndLongitudeDecimalDegree() {
        return getGearShootingEndLongitudeDegree();
    }

    public void setGearShootingEndLongitudeDegree(Integer degree) {
        Object oldValue = getGearShootingEndLongitudeDegree();
        boolean sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        gearShootingEndLongitudeAsSexagecimal.setSign(sign);
        gearShootingEndLongitudeAsSexagecimal.setDegre(degree);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingEndLongitudeDecimalDegree(Integer degree) {
        setGearShootingEndLongitudeDegree(degree);
    }

    public Integer getGearShootingEndLongitudeMinute() {
        return gearShootingEndLongitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingEndLongitudeMinute(Integer minute) {
        Object oldValue = getGearShootingEndLongitudeMinute();
        gearShootingEndLongitudeAsSexagecimal.setMinute(minute);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingEndLongitudeDecimalMinute() {
        return gearShootingEndLongitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingEndLongitudeDecimalMinute(Float decimalMinute) {
        gearShootingEndLongitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        // 2013-01-22 kmorin: pass null as previous value, 
        // otherwise the filed is not filled with the value (I cannot explain why... :()
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingEndLongitudeSecond() {
        return gearShootingEndLongitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingEndLongitudeSecond(Integer second) {
        Object oldValue = getGearShootingEndLongitudeSecond();
        gearShootingEndLongitudeAsSexagecimal.setSeconde(second);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_SECOND, oldValue, second);
    }

    public void setGearShootingEndTime(Date gearShootingEndDate) {
        Object oldValue = getGearShootingEndDate();
        if (oldValue != null) {
            setGearShootingEndDate(gearShootingEndDate);
        }
    }

    public String getValidationContext() {
        return validationContext;
    }

    public void setValidationContext(String validationContext) {
        Object oldValue = getValidationContext();
        this.validationContext = validationContext;
        firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public CoordinateEditorType getCoordinateEditorType() {
        return coordinateEditorType;
    }

    public void setCoordinateEditorType(CoordinateEditorType coordinateEditorType) {
        this.coordinateEditorType = coordinateEditorType;
    }

    public boolean isDateInCruise(Date date) {
        return DateUtil.between(date, getCruise().getBeginDate(), getCruise().getEndDate());
    }

    public boolean isValidDuration() {
        int minutes = DateUtil.getDifferenceInMinutes(getGearShootingStartDate(), getGearShootingEndDate());
        return minutes <= 45 && minutes >= 20;
    }

//    public List<FishingOperation> getExistingOperations() {
//        return existingOperations;
//    }

//    public void setExistingOperations(List<FishingOperation> existingOperations) {
//        this.existingOperations = existingOperations;
//    }

    public void convertGearShootingCoordinatesDDToDMS() {
        SexagecimalPosition position;
        Integer degree;

        position = SexagecimalPosition.valueOf(getGearShootingStartLatitude());
        degree = position.getDegre();
        if (degree != null) {
            degree *= position.isSign() ? -1 : 1;
        }
        setGearShootingStartLatitudeDegree(degree);
        setGearShootingStartLatitudeMinute(position.getMinute());
        setGearShootingStartLatitudeSecond(position.getSeconde());
        setGearShootingStartLatitudeDecimalMinute(position.getMinuteDecimale());

        position = SexagecimalPosition.valueOf(getGearShootingStartLongitude());
        degree = position.getDegre();
        if (degree != null) {
            degree *= position.isSign() ? -1 : 1;
        }
        setGearShootingStartLongitudeDegree(degree);
        setGearShootingStartLongitudeMinute(position.getMinute());
        setGearShootingStartLongitudeSecond(position.getSeconde());
        setGearShootingStartLongitudeDecimalMinute(position.getMinuteDecimale());

        position = SexagecimalPosition.valueOf(getGearShootingEndLatitude());
        degree = position.getDegre();
        if (degree != null) {
            degree *= position.isSign() ? -1 : 1;
        }
        if (position.getDegre() != null) {

        }
        setGearShootingEndLatitudeDegree(degree);
        setGearShootingEndLatitudeMinute(position.getMinute());
        setGearShootingEndLatitudeSecond(position.getSeconde());
        setGearShootingEndLatitudeDecimalMinute(position.getMinuteDecimale());

        position = SexagecimalPosition.valueOf(getGearShootingEndLongitude());
        degree = position.getDegre();
        if (degree != null) {
            degree *= position.isSign() ? -1 : 1;
        }
        setGearShootingEndLongitudeDegree(degree);
        setGearShootingEndLongitudeMinute(position.getMinute());
        setGearShootingEndLongitudeSecond(position.getSeconde());
        setGearShootingEndLongitudeDecimalMinute(position.getMinuteDecimale());
    }

    public void convertGearShootingCoordinatesDMSToDD() {
        Float decimalValue = gearShootingStartLatitudeAsSexagecimal.toDecimal();
        editObject.setGearShootingStartLatitude(decimalValue);

        decimalValue = gearShootingStartLongitudeAsSexagecimal.toDecimal();
        editObject.setGearShootingStartLongitude(decimalValue);

        decimalValue = gearShootingEndLatitudeAsSexagecimal.toDecimal();
        editObject.setGearShootingEndLatitude(decimalValue);

        decimalValue = gearShootingEndLongitudeAsSexagecimal.toDecimal();
        editObject.setGearShootingEndLongitude(decimalValue);
    }

    public void computeDistance() {
        if (coordinateEditorType != CoordinateEditorType.DD) {
            convertGearShootingCoordinatesDMSToDD();
        }
        if (getGearShootingStartLatitude() != null && getGearShootingStartLongitude() != null
            && getGearShootingEndLatitude() != null && getGearShootingEndLongitude() != null) {
            Integer distance = TuttiUIUtil.computeDistanceInMeters(
                    getGearShootingStartLatitude(),
                    getGearShootingStartLongitude(),
                    getGearShootingEndLatitude(),
                    getGearShootingEndLongitude());
            setTrawlDistance(distance.floatValue());
        }
    }

    //------------------------------------------------------------------------//
    //-- AttachmentModelAware methods                                       --//
    //------------------------------------------------------------------------//

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.OPERATION;
    }

    @Override
    public Integer getObjectId() {
        return getIdAsInt();
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    //------------------------------------------------------------------------//
    //-- FishingOperation methods                                           --//
    //------------------------------------------------------------------------//

    @Override
    public Cruise getCruise() {
        return editObject.getCruise();
    }

    @Override
    public void setCruise(Cruise cruise) {
        editObject.setCruise(cruise);
    }

    @Override
    public String getStationNumber() {
        return editObject.getStationNumber();
    }

    @Override
    public void setStationNumber(String stationNumber) {
        Object oldValue = getStationNumber();
        editObject.setStationNumber(stationNumber);
        firePropertyChange(PROPERTY_STATION_NUMBER, oldValue, stationNumber);
    }

    @Override
    public Integer getFishingOperationNumber() {
        return editObject.getFishingOperationNumber();
    }

    @Override
    public void setFishingOperationNumber(Integer fishingOperationNumber) {
        Object oldValue = getFishingOperationNumber();
        editObject.setFishingOperationNumber(fishingOperationNumber);
        firePropertyChange(PROPERTY_FISHING_OPERATION_NUMBER, oldValue, fishingOperationNumber);
    }

    @Override
    public TuttiLocation getStrata() {
        return editObject.getStrata();
    }

    @Override
    public void setStrata(TuttiLocation strata) {
        Object oldValue = getStrata();
        editObject.setStrata(strata);
        firePropertyChange(PROPERTY_STRATA, oldValue, strata);
    }

    @Override
    public TuttiLocation getSubStrata() {
        return editObject.getSubStrata();
    }

    @Override
    public void setSubStrata(TuttiLocation subStrata) {
        Object oldValue = getSubStrata();
        editObject.setSubStrata(subStrata);
        firePropertyChange(PROPERTY_SUB_STRATA, oldValue, subStrata);
    }

    @Override
    public Float getGearShootingStartLatitude() {
        return editObject.getGearShootingStartLatitude();
    }

    @Override
    public void setGearShootingStartLatitude(Float gearShootingStartLatitude) {
        Object oldValue = getGearShootingStartLatitude();
        editObject.setGearShootingStartLatitude(gearShootingStartLatitude);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE, oldValue, gearShootingStartLatitude);
    }

    @Override
    public Float getGearShootingStartLongitude() {
        return editObject.getGearShootingStartLongitude();
    }

    @Override
    public void setGearShootingStartLongitude(Float gearShootingStartLongitude) {
        Object oldValue = getGearShootingStartLongitude();
        editObject.setGearShootingStartLongitude(gearShootingStartLongitude);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE, oldValue, gearShootingStartLongitude);
    }

    @Override
    public Date getGearShootingStartDate() {
        return editObject.getGearShootingStartDate();
    }

    @Override
    public void setGearShootingStartDate(Date gearShootingStartDate) {
        Object oldValue = getGearShootingStartDate();
        if (gearShootingStartDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar(gearShootingStartDate);
            calendar.set(Calendar.SECOND, 0);
            editObject.setGearShootingStartDate(calendar.getTime());

        } else {
            editObject.setGearShootingStartDate(null);
        }
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_DATE, oldValue, getGearShootingStartDate());
    }

    @Override
    public Float getGearShootingEndLatitude() {
        return editObject.getGearShootingEndLatitude();
    }

    @Override
    public void setGearShootingEndLatitude(Float gearShootingEndLatitude) {
        Object oldValue = getGearShootingEndLatitude();
        editObject.setGearShootingEndLatitude(gearShootingEndLatitude);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE, oldValue, gearShootingEndLatitude);
    }

    @Override
    public Float getGearShootingEndLongitude() {
        return editObject.getGearShootingEndLongitude();
    }

    @Override
    public void setGearShootingEndLongitude(Float gearShootingEndLongitude) {
        Object oldValue = getGearShootingEndLongitude();
        editObject.setGearShootingEndLongitude(gearShootingEndLongitude);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE, oldValue, gearShootingEndLongitude);
    }

    @Override
    public Date getGearShootingEndDate() {
        return editObject.getGearShootingEndDate();
    }

    @Override
    public void setGearShootingEndDate(Date gearShootingEndDate) {
        Object oldValue = getGearShootingEndDate();
        if (gearShootingEndDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar(gearShootingEndDate);
            calendar.set(Calendar.SECOND, 0);
            editObject.setGearShootingEndDate(calendar.getTime());

        } else {
            editObject.setGearShootingEndDate(null);
        }
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_DATE, oldValue, getGearShootingEndDate());
    }

    @Override
    public boolean isFishingOperationRectiligne() {
        return editObject.isFishingOperationRectiligne();
    }

    @Override
    public void setFishingOperationRectiligne(boolean fishingOperationRectiligne) {
        Object oldValue = isFishingOperationRectiligne();
        editObject.setFishingOperationRectiligne(fishingOperationRectiligne);
        firePropertyChange(PROPERTY_FISHING_OPERATION_RECTILIGNE, oldValue, fishingOperationRectiligne);
    }

    @Override
    public Float getTrawlDistance() {
        return editObject.getTrawlDistance();
    }

    @Override
    public void setTrawlDistance(Float trawlDistance) {
        Object oldValue = getTrawlDistance();
        editObject.setTrawlDistance(trawlDistance);
        firePropertyChange(PROPERTY_TRAWL_DISTANCE, oldValue, trawlDistance);
    }

    @Override
    public Boolean getFishingOperationValid() {
        return editObject.getFishingOperationValid();
    }

    @Override
    public void setFishingOperationValid(Boolean fishingOperationValid) {
        Object oldValue = getFishingOperationValid();
        editObject.setFishingOperationValid(fishingOperationValid);
        firePropertyChange(PROPERTY_FISHING_OPERATION_VALID, oldValue, fishingOperationValid);
    }

    @Override
    public TuttiLocation getLocation() {
        return editObject.getLocation();
    }

    @Override
    public void setLocation(TuttiLocation location) {
        Object oldValue = getLocation();
        editObject.setLocation(location);
        firePropertyChange(PROPERTY_LOCATION, oldValue, location);
    }

    @Override
    public String getComment() {
        return editObject.getComment();
    }

    @Override
    public void setComment(String comment) {
        Object oldValue = getComment();
        editObject.setComment(comment);
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public List<Person> getRecorderPerson() {
        return editObject.getRecorderPerson();
    }

    @Override
    public void setRecorderPerson(List<Person> recorderPerson) {
        Object oldValue = null;
        List<Person> oldRecorderPerson = getRecorderPerson();
        if (oldRecorderPerson != null) {
            oldValue = Lists.newArrayList(oldRecorderPerson);
        }
        editObject.setRecorderPerson(Lists.<Person>newArrayList());
        if (recorderPerson != null) {
            getRecorderPerson().addAll(recorderPerson);
        }
        firePropertyChange(PROPERTY_RECORDER_PERSON, oldValue, recorderPerson);
    }

    @Override
    public Gear getGear() {
        return editObject.getGear();
    }

    @Override
    public void setGear(Gear gear) {
        Object oldValue = getGear();
        editObject.setGear(gear);
        firePropertyChange(PROPERTY_GEAR, oldValue, gear);
    }

    @Override
    public Vessel getVessel() {
        return editObject.getVessel();
    }

    @Override
    public void setVessel(Vessel vessel) {
        Object oldValue = getVessel();
        editObject.setVessel(vessel);
        firePropertyChange(PROPERTY_VESSEL, oldValue, vessel);
    }

    @Override
    public String getMultirigAggregation() {
        return editObject.getMultirigAggregation();
    }

    @Override
    public void setMultirigAggregation(String multirigAggregation) {
        Object oldValue = getMultirigAggregation();
        editObject.setMultirigAggregation(multirigAggregation);
        firePropertyChange(PROPERTY_MULTIRIG_AGGREGATION, oldValue, multirigAggregation);
    }

    @Override
    public boolean isPlanktonObserved() {
        return false;
    }

    @Override
    public void setPlanktonObserved(boolean planktonObserved) {
    }

    @Override
    public CaracteristicMap getVesselUseFeatures() {
        return null;
    }

    @Override
    public void setVesselUseFeatures(CaracteristicMap vesselUseFeatures) {
    }

    @Override
    public CaracteristicMap getGearUseFeatures() {
        return null;
    }

    @Override
    public void setGearUseFeatures(CaracteristicMap gearUseFeatures) {
    }

    @Override
    public boolean isAccidentalObserved() {
        return false;
    }

    @Override
    public void setAccidentalObserved(boolean accidentalObserved) {
    }

    @Override
    public Person getRecorderPerson(int index) {
        return null;
    }

    @Override
    public boolean isRecorderPersonEmpty() {
        return false;
    }

    @Override
    public int sizeRecorderPerson() {
        return 0;
    }

    @Override
    public void addRecorderPerson(Person recorderPerson) {
    }

    @Override
    public void addAllRecorderPerson(Collection<Person> recorderPerson) {
    }

    @Override
    public boolean removeRecorderPerson(Person recorderPerson) {
        return false;
    }

    @Override
    public boolean removeAllRecorderPerson(Collection<Person> recorderPerson) {
        return false;
    }

    @Override
    public boolean containsRecorderPerson(Person recorderPerson) {
        return false;
    }

    @Override
    public boolean containsAllRecorderPerson(Collection<Person> recorderPerson) {
        return false;
    }
}