/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.catches.multipost;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.TuttiIOUtil;
import fr.ifremer.tutti.TuttiTechnicalException;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiBeanFactory;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.multipost.AbstractFishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.AbstractFishingOperationRowModel;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRow;
import fr.ifremer.tutti.service.catches.multipost.AccidentalCatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.AttachmentRow;
import fr.ifremer.tutti.service.catches.multipost.AttachmentRowModel;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRow;
import fr.ifremer.tutti.service.catches.multipost.CaracteristicRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRow;
import fr.ifremer.tutti.service.catches.multipost.CatchFrequencyRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchRow;
import fr.ifremer.tutti.service.catches.multipost.CatchRowModel;
import fr.ifremer.tutti.service.catches.multipost.CatchWeightsRow;
import fr.ifremer.tutti.service.catches.multipost.CatchWeightsRowModel;
import fr.ifremer.tutti.service.catches.multipost.FishingOperationRow;
import fr.ifremer.tutti.service.catches.multipost.FishingOperationRowModel;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRow;
import fr.ifremer.tutti.service.catches.multipost.IndividualObservationRowModel;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRow;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterRowModel;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterWeightRow;
import fr.ifremer.tutti.service.catches.multipost.MarineLitterWeightRowModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ZipUtil;

@Deprecated
public class TuttiMultiPostImportExportService
extends AbstractTuttiService {
    public static final String BATCHES_KEY = "batchesKey";
    protected static final String ATTACHMENTS_DIRECTORY = "attachments";
    protected static final String ATTACHMENTS_FILE = "attachments.csv";
    protected static final String SPECIES_FILE = "species.csv";
    protected static final String BENTHOS_FILE = "benthos.csv";
    protected static final String MARINE_LITTER_FILE = "marineLitter.csv";
    protected static final String INDIVIDUAL_OBSERVATION_FILE = "individualObservation.csv";
    protected static final String ACCIDENTAL_CATCHES_FILE = "accidentalCatches.csv";
    protected static final String FREQUENCIES_FILE = "frequencies.csv";
    protected static final String CARACTERISTIC_FILE = "caracteristics.csv";
    protected static final String WEIGHTS_FILE = "weights.csv";
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;
    protected char csvSeparator;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
        this.csvSeparator = context.getConfig().getCsvSeparator();
    }

    public void exportSpecies(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<SpeciesBatch> speciesBatchContainer = this.persistenceService.getRootSpeciesBatch(operationId, null);
            ArrayList rows = Lists.newArrayList();
            ArrayList frequencyRows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (SpeciesBatch batch : speciesBatchContainer.getChildren()) {
                this.createSpeciesRow(batch, null, rows, frequencyRows, attachmentRows);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            CatchWeightsRow weights = new CatchWeightsRow();
            weights.setTotalSortedWeight(catchBatch.getSpeciesTotalSortedWeight());
            weights.setInertWeight(catchBatch.getSpeciesTotalInertWeight());
            weights.setLivingNotItemizedWeight(catchBatch.getSpeciesTotalLivingNotItemizedWeight());
            this.exportOperation(weights, operation);
            this.exportCatches(file, SPECIES_FILE, weights, rows, frequencyRows, attachmentRows);
        }
    }

    public void exportBenthos(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<BenthosBatch> benthosBatchContainer = this.persistenceService.getRootBenthosBatch(operationId, null);
            ArrayList rows = Lists.newArrayList();
            ArrayList frequencyRows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (BenthosBatch batch : benthosBatchContainer.getChildren()) {
                this.createBenthosRow(batch, null, rows, frequencyRows, attachmentRows);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            CatchWeightsRow weights = new CatchWeightsRow();
            weights.setTotalSortedWeight(catchBatch.getBenthosTotalSortedWeight());
            weights.setInertWeight(catchBatch.getBenthosTotalInertWeight());
            weights.setLivingNotItemizedWeight(catchBatch.getBenthosTotalLivingNotItemizedWeight());
            this.exportOperation(weights, operation);
            this.exportCatches(file, BENTHOS_FILE, weights, rows, frequencyRows, attachmentRows);
        }
    }

    public void exportMarineLitter(File file, FishingOperation operation) {
        String operationId = operation.getId();
        if (this.persistenceService.isFishingOperationWithCatchBatch(operationId)) {
            BatchContainer<MarineLitterBatch> marineLitterBatchContainer = this.persistenceService.getRootMarineLitterBatch(operationId);
            ArrayList rows = Lists.newArrayList();
            ArrayList attachmentRows = Lists.newArrayList();
            for (MarineLitterBatch batch : marineLitterBatchContainer.getChildren()) {
                MarineLitterRow row = new MarineLitterRow();
                String id = UUID.randomUUID().toString();
                row.setBatchId(id);
                row.setCategory(batch.getMarineLitterCategory());
                row.setSizeCategory(batch.getMarineLitterSizeCategory());
                row.setNumber(batch.getNumber());
                row.setWeight(batch.getWeight());
                row.setComment(batch.getComment());
                rows.add(row);
                this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.BATCH, attachmentRows);
            }
            MarineLitterRowModel csvModel = new MarineLitterRowModel(this.csvSeparator);
            BufferedWriter writer = null;
            File directory = Files.createTempDir();
            ArrayList file2zip = Lists.newArrayList();
            File speciesFile = new File(directory, MARINE_LITTER_FILE);
            file2zip.add(speciesFile);
            try {
                writer = Files.newWriter((File)speciesFile, (Charset)Charsets.UTF_8);
                Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
                export.write((Writer)writer);
                writer.close();
            }
            catch (Exception e) {
                throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[]{speciesFile}), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            MarineLitterWeightRow weight = new MarineLitterWeightRow();
            weight.setTotalWeight(catchBatch.getMarineLitterTotalWeight());
            this.exportOperation(weight, operation);
            MarineLitterWeightRowModel weightModel = new MarineLitterWeightRowModel(this.csvSeparator);
            File weightFile = new File(directory, WEIGHTS_FILE);
            file2zip.add(weightFile);
            try {
                writer = Files.newWriter((File)weightFile, (Charset)Charsets.UTF_8);
                Export export = Export.newExport((ExportModel)weightModel, (Iterable)Lists.newArrayList((Object[])new MarineLitterWeightRow[]{weight}));
                export.write((Writer)writer);
                writer.close();
            }
            catch (Exception e) {
                throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.weight.error", (Object[])new Object[]{weightFile}), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Writer)writer);
            }
            this.exportAttachments(directory, file2zip, attachmentRows);
            try {
                ZipUtil.compressFiles((File)file, (File)directory, (Collection)file2zip);
            }
            catch (IOException e) {
                try {
                    throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.error", (Object[])new Object[]{file}), (Throwable)e);
                }
                catch (Throwable throwable) {
                    TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
                    throw throwable;
                }
            }
            TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
        }
    }

    public void exportIndividualObservation(File file, FishingOperation operation) {
        List<IndividualObservationBatch> individualObservations = this.persistenceService.getAllIndividualObservationBatch(operation.getId());
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristicRows = Lists.newArrayList();
        ArrayList attachmentRows = Lists.newArrayList();
        for (IndividualObservationBatch batch : individualObservations) {
            IndividualObservationRow row = new IndividualObservationRow();
            String id = UUID.randomUUID().toString();
            row.setBatchId(id);
            row.setSpecies(batch.getSpecies());
            row.setWeight(batch.getWeight());
            row.setSize(batch.getSize());
            row.setLengthStepCaracteristic(batch.getLengthStepCaracteristic());
            row.setSamplingCode(batch.getSamplingCode());
            row.setCalcifiedPieceSamplingCode(batch.getCalcifiedPieceSamplingCode());
            row.setComment(batch.getComment());
            rows.add(row);
            CaracteristicMap caracteristicMap = batch.getCaracteristics();
            for (Caracteristic caracteristic : caracteristicMap.keySet()) {
                CaracteristicRow caracteristicRow = new CaracteristicRow();
                caracteristicRow.setBatchId(id);
                caracteristicRow.setCaracteristic(caracteristic);
                caracteristicRow.setValue((Serializable)caracteristicMap.get((Object)caracteristic));
                caracteristicRows.add(caracteristicRow);
            }
            this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.SAMPLE, attachmentRows);
        }
        IndividualObservationRowModel csvModel = new IndividualObservationRowModel(this.csvSeparator);
        BufferedWriter writer = null;
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        File individualObservationFile = new File(directory, INDIVIDUAL_OBSERVATION_FILE);
        file2zip.add(individualObservationFile);
        try {
            writer = Files.newWriter((File)individualObservationFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        CaracteristicRowModel caracteristicCsvModel = new CaracteristicRowModel(this.csvSeparator);
        File caracteristicFile = new File(directory, CARACTERISTIC_FILE);
        file2zip.add(caracteristicFile);
        try {
            writer = Files.newWriter((File)caracteristicFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)caracteristicCsvModel, (Iterable)caracteristicRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[]{caracteristicFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        FishingOperationRow foRow = new FishingOperationRow();
        this.exportOperation(foRow, operation);
        FishingOperationRowModel foRowModel = new FishingOperationRowModel(this.csvSeparator);
        File weightFile = new File(directory, WEIGHTS_FILE);
        file2zip.add(weightFile);
        try {
            writer = Files.newWriter((File)weightFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)foRowModel, (Iterable)Lists.newArrayList((Object[])new FishingOperationRow[]{foRow}));
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.operation.error", (Object[])new Object[]{weightFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        this.exportAttachments(directory, file2zip, attachmentRows);
        try {
            ZipUtil.compressFiles((File)file, (File)directory, (Collection)file2zip);
        }
        catch (IOException e) {
            try {
                throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.error", (Object[])new Object[]{file}), (Throwable)e);
            }
            catch (Throwable throwable) {
                TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
                throw throwable;
            }
        }
        TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
    }

    public void exportAccidentalCatch(File file, FishingOperation operation) {
        List<AccidentalBatch> accidentalCatches = this.persistenceService.getAllAccidentalBatch(operation.getId());
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristicRows = Lists.newArrayList();
        ArrayList attachmentRows = Lists.newArrayList();
        for (AccidentalBatch batch : accidentalCatches) {
            AccidentalCatchRow row = new AccidentalCatchRow();
            String id = UUID.randomUUID().toString();
            row.setBatchId(id);
            row.setSpecies(batch.getSpecies());
            row.setGender(batch.getGender());
            row.setWeight(batch.getWeight());
            row.setSize(batch.getSize());
            row.setLengthStepCaracteristic(batch.getLengthStepCaracteristic());
            row.setDeadOrAlive(batch.getDeadOrAlive());
            row.setComment(batch.getComment());
            rows.add(row);
            CaracteristicMap caracteristicMap = batch.getCaracteristics();
            for (Caracteristic caracteristic : caracteristicMap.keySet()) {
                CaracteristicRow caracteristicRow = new CaracteristicRow();
                caracteristicRow.setBatchId(id);
                caracteristicRow.setCaracteristic(caracteristic);
                caracteristicRow.setValue((Serializable)caracteristicMap.get((Object)caracteristic));
                caracteristicRows.add(caracteristicRow);
            }
            this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.SAMPLE, attachmentRows);
        }
        AccidentalCatchRowModel csvModel = new AccidentalCatchRowModel(this.csvSeparator);
        BufferedWriter writer = null;
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        File accidentalCatchesFile = new File(directory, ACCIDENTAL_CATCHES_FILE);
        file2zip.add(accidentalCatchesFile);
        try {
            writer = Files.newWriter((File)accidentalCatchesFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, (Iterable)rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        CaracteristicRowModel caracteristicCsvModel = new CaracteristicRowModel(this.csvSeparator);
        File caracteristicFile = new File(directory, CARACTERISTIC_FILE);
        file2zip.add(caracteristicFile);
        try {
            writer = Files.newWriter((File)caracteristicFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)caracteristicCsvModel, (Iterable)caracteristicRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[]{caracteristicFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        FishingOperationRow foRow = new FishingOperationRow();
        this.exportOperation(foRow, operation);
        FishingOperationRowModel foRowModel = new FishingOperationRowModel(this.csvSeparator);
        File weightFile = new File(directory, WEIGHTS_FILE);
        file2zip.add(weightFile);
        try {
            writer = Files.newWriter((File)weightFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)foRowModel, (Iterable)Lists.newArrayList((Object[])new FishingOperationRow[]{foRow}));
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.operation.error", (Object[])new Object[]{weightFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        this.exportAttachments(directory, file2zip, attachmentRows);
        try {
            ZipUtil.compressFiles((File)file, (File)directory, (Collection)file2zip);
        }
        catch (IOException e) {
            try {
                throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.error", (Object[])new Object[]{file}), (Throwable)e);
            }
            catch (Throwable throwable) {
                TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
                throw throwable;
            }
        }
        TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
    }

    public Map<String, Object> importSpecies(File file, FishingOperation operation) {
        HashMap notImportedData = Maps.newHashMap();
        final LinkedHashMap notImportedBatches = Maps.newLinkedHashMap();
        BatchContainer<SpeciesBatch> speciesBatches = this.persistenceService.getRootSpeciesBatch(operation.getId(), null);
        TuttiDataContext dataContext = this.context.getDataContext();
        List<Species> speciesList = dataContext.getReferentSpecies();
        final HashMap batches = Maps.newHashMap();
        File tempDir = Files.createTempDir();
        try {
            ZipUtil.uncompress((File)file, (File)tempDir);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[]{file}));
        }
        CatchWeightsRowModel weightsModel = new CatchWeightsRowModel(this.csvSeparator);
        this.checkSameOperation(tempDir, weightsModel, operation);
        File speciesFile = new File(tempDir, SPECIES_FILE);
        BufferedReader reader = null;
        try {
            reader = Files.newReader((File)speciesFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[]{speciesFile}), (Throwable)e);
        }
        CatchRowModel csvModel = new CatchRowModel(this.csvSeparator, speciesList);
        Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
        for (CatchRow row : importer) {
            SpeciesBatch batch = TuttiBeanFactory.newSpeciesBatch();
            batch.setFishingOperation(operation);
            Species species = row.getSpecies();
            batch.setSpecies(row.getSpecies());
            batch.setWeight(row.getWeight());
            batch.setNumber(row.getNumber());
            batch.setComment(row.getComment());
            batch.setSpeciesToConfirm(row.isToConfirm());
            Pair<Integer, Serializable> valueAndCategoryType = this.getValueAndCategoryType(row);
            Integer categoryId = (Integer)valueAndCategoryType.getKey();
            Serializable value = (Serializable)valueAndCategoryType.getValue();
            batch.setSampleCategoryId(categoryId);
            batch.setSampleCategoryValue(value);
            batch.setSampleCategoryWeight(row.getCategoryWeight());
            String parentId = row.getParentId();
            String parentPersistedId = null;
            SpeciesBatch parent = null;
            if (StringUtils.isNotEmpty((CharSequence)parentId)) {
                parent = (SpeciesBatch)batches.get(parentId);
                parentPersistedId = parent.getId();
            }
            SpeciesBatch existingBatch = null;
            List batchesToBrowse = parent == null ? speciesBatches.getChildren() : parent.getChildBatchs();
            if (batchesToBrowse != null) {
                for (SpeciesBatch sb : batchesToBrowse) {
                    if (!sb.getSpecies().equals(species) || sb.getSampleCategoryId().equals(batch.getSampleCategoryId()) && !sb.getSampleCategoryValue().equals(value)) continue;
                    existingBatch = sb;
                    batches.put(row.getId(), sb);
                    notImportedBatches.put(row.getId(), batch);
                    break;
                }
            }
            if (existingBatch != null) continue;
            batch = this.persistenceService.createSpeciesBatch(batch, parentPersistedId);
            batches.put(row.getId(), batch);
        }
        File frequencyFile = new File(tempDir, FREQUENCIES_FILE);
        try {
            reader = Files.newReader((File)frequencyFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.frequencies.error", (Object[])new Object[]{frequencyFile}), (Throwable)e);
        }
        CatchFrequencyRowModel frequencyModel = new CatchFrequencyRowModel(this.csvSeparator, dataContext.getCaracteristics());
        Import frequencyImporter = Import.newImport((ImportModel)frequencyModel, (Reader)reader);
        ArrayListMultimap frequencyMap = ArrayListMultimap.create();
        for (CatchFrequencyRow frequencyRow : frequencyImporter) {
            SpeciesBatch batch;
            if (notImportedBatches.get(frequencyRow.getBatchId()) != null || (batch = (SpeciesBatch)batches.get(frequencyRow.getBatchId())) == null) continue;
            SpeciesBatchFrequency frequency = TuttiBeanFactory.newSpeciesBatchFrequency();
            frequency.setLengthStepCaracteristic(frequencyRow.getLengthStepCaracteristic());
            frequency.setLengthStep(frequencyRow.getLengthStep());
            frequency.setNumber(frequencyRow.getNumber());
            frequency.setWeight(frequencyRow.getWeight());
            frequency.setBatch(batch);
            frequencyMap.put((Object)batch.getId(), (Object)frequency);
        }
        for (String batchId : frequencyMap.keySet()) {
            List frequencies = frequencyMap.get((Object)batchId);
            this.persistenceService.saveSpeciesBatchFrequency(batchId, frequencies);
        }
        Function<AttachmentRow, Integer> getObjetcIdFunction = new Function<AttachmentRow, Integer>(){

            public Integer apply(AttachmentRow input) {
                SpeciesBatch batch;
                Integer result = null;
                if (notImportedBatches.get(input.getBatchId()) == null && (batch = (SpeciesBatch)batches.get(input.getBatchId())) != null) {
                    result = batch.getIdAsInt();
                }
                return result;
            }
        };
        this.importAttachments(tempDir, getObjetcIdFunction, AttachementObjectTypeEnum.BATCH);
        File weightsFile = new File(tempDir, WEIGHTS_FILE);
        try {
            reader = Files.newReader((File)weightsFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.weights.error", (Object[])new Object[]{weightsFile}), (Throwable)e);
        }
        Import weights = Import.newImport((ImportModel)weightsModel, (Reader)reader);
        Iterator iterator = weights.iterator();
        if (iterator.hasNext()) {
            CatchWeightsRow row = (CatchWeightsRow)iterator.next();
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getId());
            catchBatch.setFishingOperation(operation);
            if (catchBatch.getSpeciesTotalSortedWeight() == null) {
                catchBatch.setSpeciesTotalSortedWeight(row.getTotalSortedWeight());
            } else if (row.getTotalSortedWeight() != null) {
                notImportedData.put("speciesTotalSortedWeight", row.getTotalSortedWeight());
            }
            if (catchBatch.getSpeciesTotalInertWeight() == null) {
                catchBatch.setSpeciesTotalInertWeight(row.getInertWeight());
            } else if (row.getInertWeight() != null) {
                notImportedData.put("speciesTotalInertWeight", row.getInertWeight());
            }
            if (catchBatch.getSpeciesTotalLivingNotItemizedWeight() == null) {
                catchBatch.setSpeciesTotalLivingNotItemizedWeight(row.getLivingNotItemizedWeight());
            } else if (row.getLivingNotItemizedWeight() != null) {
                notImportedData.put("speciesTotalLivingNotItemizedWeight", row.getLivingNotItemizedWeight());
            }
            this.persistenceService.saveCatchBatch(catchBatch);
        }
        notImportedData.put(BATCHES_KEY, notImportedBatches.values());
        return notImportedData;
    }

    public Map<String, Object> importBenthos(File file, FishingOperation operation) {
        HashMap notImportedData = Maps.newHashMap();
        final LinkedHashMap notImportedBatches = Maps.newLinkedHashMap();
        BatchContainer<BenthosBatch> benthosBatches = this.persistenceService.getRootBenthosBatch(operation.getId(), null);
        TuttiDataContext dataContext = this.context.getDataContext();
        List<Species> speciesList = dataContext.getReferentSpecies();
        final HashMap batches = Maps.newHashMap();
        File tempDir = Files.createTempDir();
        try {
            ZipUtil.uncompress((File)file, (File)tempDir);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[]{file}));
        }
        CatchWeightsRowModel weightsModel = new CatchWeightsRowModel(this.csvSeparator);
        this.checkSameOperation(tempDir, weightsModel, operation);
        File benthosFile = new File(tempDir, BENTHOS_FILE);
        BufferedReader reader = null;
        try {
            reader = Files.newReader((File)benthosFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[]{benthosFile}), (Throwable)e);
        }
        CatchRowModel csvModel = new CatchRowModel(this.csvSeparator, speciesList);
        Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
        for (CatchRow row : importer) {
            BenthosBatch batch = TuttiBeanFactory.newBenthosBatch();
            batch.setFishingOperation(operation);
            Species species = row.getSpecies();
            batch.setSpecies(row.getSpecies());
            batch.setWeight(row.getWeight());
            batch.setNumber(row.getNumber());
            batch.setComment(row.getComment());
            batch.setSpeciesToConfirm(row.isToConfirm());
            Pair<Integer, Serializable> valueAndCategoryType = this.getValueAndCategoryType(row);
            Integer categoryId = (Integer)valueAndCategoryType.getKey();
            Serializable value = (Serializable)valueAndCategoryType.getValue();
            batch.setSampleCategoryId(categoryId);
            batch.setSampleCategoryValue(value);
            batch.setSampleCategoryWeight(row.getCategoryWeight());
            String parentId = row.getParentId();
            String parentPersistedId = null;
            BenthosBatch parent = null;
            if (StringUtils.isNotEmpty((CharSequence)parentId)) {
                parent = (BenthosBatch)batches.get(parentId);
                parentPersistedId = parent.getId();
            }
            BenthosBatch existingBatch = null;
            List batchesToBrowse = parent == null ? benthosBatches.getChildren() : parent.getChildBatchs();
            if (batchesToBrowse != null) {
                for (BenthosBatch bb : batchesToBrowse) {
                    if (!bb.getSpecies().equals(species) || bb.getSampleCategoryId().equals(batch.getSampleCategoryId()) && !bb.getSampleCategoryValue().equals(value)) continue;
                    existingBatch = bb;
                    batches.put(row.getId(), bb);
                    notImportedBatches.put(row.getId(), batch);
                    break;
                }
            }
            if (existingBatch != null) continue;
            batch = this.persistenceService.createBenthosBatch(batch, parentPersistedId);
            batches.put(row.getId(), batch);
        }
        File frequencyFile = new File(tempDir, FREQUENCIES_FILE);
        try {
            reader = Files.newReader((File)frequencyFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.frequencies.error", (Object[])new Object[]{frequencyFile}), (Throwable)e);
        }
        CatchFrequencyRowModel frequencyModel = new CatchFrequencyRowModel(this.csvSeparator, dataContext.getCaracteristics());
        Import frequencyImporter = Import.newImport((ImportModel)frequencyModel, (Reader)reader);
        ArrayListMultimap frequencyMap = ArrayListMultimap.create();
        for (CatchFrequencyRow frequencyRow : frequencyImporter) {
            BenthosBatch batch;
            if (notImportedBatches.get(frequencyRow.getBatchId()) != null || (batch = (BenthosBatch)batches.get(frequencyRow.getBatchId())) == null) continue;
            BenthosBatchFrequency frequency = TuttiBeanFactory.newBenthosBatchFrequency();
            frequency.setLengthStepCaracteristic(frequencyRow.getLengthStepCaracteristic());
            frequency.setLengthStep(frequencyRow.getLengthStep());
            frequency.setNumber(frequencyRow.getNumber());
            frequency.setWeight(frequencyRow.getWeight());
            frequency.setBatch(batch);
            frequencyMap.put((Object)batch.getId(), (Object)frequency);
        }
        for (String batchId : frequencyMap.keySet()) {
            List frequencies = frequencyMap.get((Object)batchId);
            this.persistenceService.saveBenthosBatchFrequency(batchId, frequencies);
        }
        Function<AttachmentRow, Integer> getObjetcIdFunction = new Function<AttachmentRow, Integer>(){

            public Integer apply(AttachmentRow input) {
                BenthosBatch batch;
                Integer result = null;
                if (notImportedBatches.get(input.getBatchId()) == null && (batch = (BenthosBatch)batches.get(input.getBatchId())) != null) {
                    result = batch.getIdAsInt();
                }
                return result;
            }
        };
        this.importAttachments(tempDir, getObjetcIdFunction, AttachementObjectTypeEnum.BATCH);
        File weightsFile = new File(tempDir, WEIGHTS_FILE);
        try {
            reader = Files.newReader((File)weightsFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.weights.error", (Object[])new Object[]{weightsFile}), (Throwable)e);
        }
        Import weights = Import.newImport((ImportModel)weightsModel, (Reader)reader);
        Iterator iterator = weights.iterator();
        if (iterator.hasNext()) {
            CatchWeightsRow row = (CatchWeightsRow)iterator.next();
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operation.getId());
            catchBatch.setFishingOperation(operation);
            if (catchBatch.getBenthosTotalSortedWeight() == null) {
                catchBatch.setBenthosTotalSortedWeight(row.getTotalSortedWeight());
            } else if (row.getTotalSortedWeight() != null) {
                notImportedData.put("benthosTotalSortedWeight", row.getTotalSortedWeight());
            }
            if (catchBatch.getBenthosTotalInertWeight() == null) {
                catchBatch.setBenthosTotalInertWeight(row.getInertWeight());
            } else if (row.getInertWeight() != null) {
                notImportedData.put("benthosTotalInertWeight", row.getInertWeight());
            }
            if (catchBatch.getBenthosTotalLivingNotItemizedWeight() == null) {
                catchBatch.setBenthosTotalLivingNotItemizedWeight(row.getLivingNotItemizedWeight());
            } else if (row.getLivingNotItemizedWeight() != null) {
                notImportedData.put("benthosTotalLivingNotItemizedWeight", row.getLivingNotItemizedWeight());
            }
            this.persistenceService.saveCatchBatch(catchBatch);
        }
        notImportedData.put(BATCHES_KEY, notImportedBatches.values());
        return notImportedData;
    }

    public Map<String, Object> importMarineLitter(File file, FishingOperation operation) {
        String operationId = operation.getId();
        HashMap notImportedData = Maps.newHashMap();
        final LinkedHashMap notImportedBatches = Maps.newLinkedHashMap();
        BatchContainer<MarineLitterBatch> marineLitterBatches = this.persistenceService.getRootMarineLitterBatch(operationId);
        final HashMap batches = Maps.newHashMap();
        File tempDir = Files.createTempDir();
        try {
            ZipUtil.uncompress((File)file, (File)tempDir);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[]{file}));
        }
        MarineLitterWeightRowModel weightModel = new MarineLitterWeightRowModel(this.csvSeparator);
        this.checkSameOperation(tempDir, weightModel, operation);
        File marineLitterFile = new File(tempDir, MARINE_LITTER_FILE);
        BufferedReader reader = null;
        try {
            reader = Files.newReader((File)marineLitterFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[]{marineLitterFile}), (Throwable)e);
        }
        List categoryValues = this.persistenceService.getMarineLitterCategoryCaracteristic().getQualitativeValue();
        List sizeCategoryValues = this.persistenceService.getMarineLitterSizeCategoryCaracteristic().getQualitativeValue();
        MarineLitterRowModel csvModel = new MarineLitterRowModel(this.csvSeparator, categoryValues, sizeCategoryValues);
        Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
        for (MarineLitterRow row : importer) {
            MarineLitterBatch batch = TuttiBeanFactory.newMarineLitterBatch();
            batch.setFishingOperation(operation);
            batch.setWeight(row.getWeight());
            batch.setNumber(row.getNumber());
            batch.setComment(row.getComment());
            batch.setMarineLitterCategory(row.getCategory());
            batch.setMarineLitterSizeCategory(row.getSizeCategory());
            MarineLitterBatch existingBatch = null;
            List batchesToBrowse = marineLitterBatches.getChildren();
            if (batchesToBrowse != null) {
                for (MarineLitterBatch mlb : batchesToBrowse) {
                    if (!mlb.getMarineLitterCategory().equals(batch.getMarineLitterCategory()) || !mlb.getMarineLitterSizeCategory().equals(batch.getMarineLitterSizeCategory())) continue;
                    existingBatch = mlb;
                    batches.put(row.getBatchId(), mlb);
                    notImportedBatches.put(row.getBatchId(), batch);
                    break;
                }
            }
            if (existingBatch != null) continue;
            batch = this.persistenceService.createMarineLitterBatch(batch);
            batches.put(row.getBatchId(), batch);
        }
        Function<AttachmentRow, Integer> getObjetcIdFunction = new Function<AttachmentRow, Integer>(){

            public Integer apply(AttachmentRow input) {
                MarineLitterBatch batch;
                Integer result = null;
                if (notImportedBatches.get(input.getBatchId()) == null && (batch = (MarineLitterBatch)batches.get(input.getBatchId())) != null) {
                    result = batch.getIdAsInt();
                }
                return result;
            }
        };
        this.importAttachments(tempDir, getObjetcIdFunction, AttachementObjectTypeEnum.BATCH);
        File weightsFile = new File(tempDir, WEIGHTS_FILE);
        try {
            reader = Files.newReader((File)weightsFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.weights.error", (Object[])new Object[]{weightsFile}), (Throwable)e);
        }
        Import weight = Import.newImport((ImportModel)weightModel, (Reader)reader);
        Iterator iterator = weight.iterator();
        if (iterator.hasNext()) {
            MarineLitterWeightRow row = (MarineLitterWeightRow)iterator.next();
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(operationId);
            catchBatch.setFishingOperation(operation);
            if (catchBatch.getMarineLitterTotalWeight() == null) {
                catchBatch.setMarineLitterTotalWeight(row.getTotalWeight());
            } else if (row.getTotalWeight() != null) {
                notImportedData.put("marineLitterTotalWeight", row.getTotalWeight());
            }
            this.persistenceService.saveCatchBatch(catchBatch);
        }
        notImportedData.put(BATCHES_KEY, notImportedBatches.values());
        return notImportedData;
    }

    public void importIndividualObservation(File file, FishingOperation operation) {
        final LinkedHashMap batches = Maps.newLinkedHashMap();
        File tempDir = Files.createTempDir();
        try {
            ZipUtil.uncompress((File)file, (File)tempDir);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[]{file}));
        }
        FishingOperationRowModel operationModel = new FishingOperationRowModel(this.csvSeparator);
        this.checkSameOperation(tempDir, operationModel, operation);
        File observationFile = new File(tempDir, INDIVIDUAL_OBSERVATION_FILE);
        BufferedReader reader = null;
        try {
            reader = Files.newReader((File)observationFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[]{observationFile}), (Throwable)e);
        }
        TuttiDataContext dataContext = this.context.getDataContext();
        List<Species> speciesList = dataContext.getReferentSpecies();
        List<Caracteristic> caracteristics = dataContext.getCaracteristicWithProtected();
        IndividualObservationRowModel csvModel = new IndividualObservationRowModel(this.csvSeparator, speciesList, caracteristics);
        Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
        for (IndividualObservationRow row : importer) {
            IndividualObservationBatch batch = TuttiBeanFactory.newIndividualObservationBatch();
            batch.setFishingOperation(operation);
            batch.setSpecies(row.getSpecies());
            batch.setWeight(row.getWeight());
            batch.setSize(row.getSize());
            batch.setLengthStepCaracteristic(row.getLengthStepCaracteristic());
            batch.setSamplingCode(row.getSamplingCode());
            batch.setCalcifiedPieceSamplingCode(row.getCalcifiedPieceSamplingCode());
            batch.setComment(row.getComment());
            batch.setCaracteristics(new CaracteristicMap());
            batches.put(row.getBatchId(), batch);
        }
        File caracteristicFile = new File(tempDir, CARACTERISTIC_FILE);
        try {
            reader = Files.newReader((File)caracteristicFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.caracteristics.error", (Object[])new Object[]{caracteristicFile}), (Throwable)e);
        }
        CaracteristicRowModel caracteristicModel = new CaracteristicRowModel(this.csvSeparator, caracteristics);
        Import caracteristicImporter = Import.newImport((ImportModel)caracteristicModel, (Reader)reader);
        for (CaracteristicRow caracteristicRow : caracteristicImporter) {
            IndividualObservationBatch batch = (IndividualObservationBatch)batches.get(caracteristicRow.getBatchId());
            if (batch == null) continue;
            Caracteristic caracteristic = caracteristicRow.getCaracteristic();
            Serializable value = caracteristicRow.getValue();
            switch (caracteristic.getCaracteristicType()) {
                case QUALITATIVE: {
                    value = TuttiEntities.getQualitativeValue((Caracteristic)caracteristic, (Integer)Integer.parseInt(value.toString()));
                    break;
                }
                case NUMBER: {
                    value = Float.valueOf(Float.parseFloat(value.toString()));
                }
            }
            CaracteristicMap map = batch.getCaracteristics();
            map.put((Object)caracteristic, (Object)value);
        }
        for (IndividualObservationBatch batch : batches.values()) {
            this.persistenceService.createIndividualObservationBatch(batch);
        }
        Function<AttachmentRow, Integer> getObjetcIdFunction = new Function<AttachmentRow, Integer>(){

            public Integer apply(AttachmentRow input) {
                Integer result = null;
                IndividualObservationBatch batch = (IndividualObservationBatch)batches.get(input.getBatchId());
                if (batch != null) {
                    result = batch.getIdAsInt();
                }
                return result;
            }
        };
        this.importAttachments(tempDir, getObjetcIdFunction, AttachementObjectTypeEnum.SAMPLE);
    }

    public void importAccidentalCatches(File file, FishingOperation operation) {
        final LinkedHashMap batches = Maps.newLinkedHashMap();
        File tempDir = Files.createTempDir();
        try {
            ZipUtil.uncompress((File)file, (File)tempDir);
        }
        catch (IOException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.uncompress.error", (Object[])new Object[]{file}));
        }
        FishingOperationRowModel operationModel = new FishingOperationRowModel(this.csvSeparator);
        this.checkSameOperation(tempDir, operationModel, operation);
        File accidentalFile = new File(tempDir, ACCIDENTAL_CATCHES_FILE);
        BufferedReader reader = null;
        try {
            reader = Files.newReader((File)accidentalFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.batches.error", (Object[])new Object[]{accidentalFile}), (Throwable)e);
        }
        TuttiDataContext dataContext = this.context.getDataContext();
        List<Species> speciesList = dataContext.getReferentSpecies();
        List<CaracteristicQualitativeValue> genderValues = dataContext.getGenderValues();
        List<Caracteristic> caracteristics = dataContext.getCaracteristicWithProtected();
        List<CaracteristicQualitativeValue> dedOrAliveValues = dataContext.getDeadOrAliveValues();
        AccidentalCatchRowModel csvModel = new AccidentalCatchRowModel(this.csvSeparator, speciesList, genderValues, caracteristics, dedOrAliveValues);
        Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);
        for (AccidentalCatchRow row : importer) {
            AccidentalBatch batch = TuttiBeanFactory.newAccidentalBatch();
            batch.setFishingOperation(operation);
            batch.setSpecies(row.getSpecies());
            batch.setGender(row.getGender());
            batch.setWeight(row.getWeight());
            batch.setSize(row.getSize());
            batch.setLengthStepCaracteristic(row.getLengthStepCaracteristic());
            batch.setDeadOrAlive(row.getDeadOrAlive());
            batch.setComment(row.getComment());
            batch.setCaracteristics(new CaracteristicMap());
            batches.put(row.getBatchId(), batch);
        }
        File caracteristicFile = new File(tempDir, CARACTERISTIC_FILE);
        try {
            reader = Files.newReader((File)caracteristicFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.caracteristics.error", (Object[])new Object[]{caracteristicFile}), (Throwable)e);
        }
        CaracteristicRowModel caracteristicModel = new CaracteristicRowModel(this.csvSeparator, caracteristics);
        Import caracteristicImporter = Import.newImport((ImportModel)caracteristicModel, (Reader)reader);
        for (CaracteristicRow caracteristicRow : caracteristicImporter) {
            AccidentalBatch batch = (AccidentalBatch)batches.get(caracteristicRow.getBatchId());
            if (batch == null) continue;
            Caracteristic caracteristic = caracteristicRow.getCaracteristic();
            Serializable value = caracteristicRow.getValue();
            switch (caracteristic.getCaracteristicType()) {
                case QUALITATIVE: {
                    value = TuttiEntities.getQualitativeValue((Caracteristic)caracteristic, (Integer)Integer.parseInt(value.toString()));
                    break;
                }
                case NUMBER: {
                    value = Float.valueOf(Float.parseFloat(value.toString()));
                }
            }
            CaracteristicMap map = batch.getCaracteristics();
            map.put((Object)caracteristic, (Object)value);
        }
        for (AccidentalBatch batch : batches.values()) {
            this.persistenceService.createAccidentalBatch(batch);
        }
        Function<AttachmentRow, Integer> getObjetcIdFunction = new Function<AttachmentRow, Integer>(){

            public Integer apply(AttachmentRow input) {
                Integer result = null;
                AccidentalBatch batch = (AccidentalBatch)batches.get(input.getBatchId());
                if (batch != null) {
                    result = batch.getIdAsInt();
                }
                return result;
            }
        };
        this.importAttachments(tempDir, getObjetcIdFunction, AttachementObjectTypeEnum.SAMPLE);
    }

    protected void exportCatches(File file, String batchFile, CatchWeightsRow weights, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRowModel csvModel = new CatchRowModel(this.csvSeparator);
        CatchFrequencyRowModel csvFrequencyModel = new CatchFrequencyRowModel(this.csvSeparator);
        CatchWeightsRowModel catchWeightsModel = new CatchWeightsRowModel(this.csvSeparator);
        BufferedWriter writer = null;
        File directory = Files.createTempDir();
        ArrayList file2zip = Lists.newArrayList();
        File weightsFile = new File(directory, WEIGHTS_FILE);
        file2zip.add(weightsFile);
        try {
            writer = Files.newWriter((File)weightsFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)catchWeightsModel, (Iterable)Lists.newArrayList((Object[])new CatchWeightsRow[]{weights}));
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.weights.error", (Object[])new Object[]{weightsFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        File speciesFile = new File(directory, batchFile);
        file2zip.add(speciesFile);
        try {
            writer = Files.newWriter((File)speciesFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvModel, rows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.batches.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        File frequencyFile = new File(directory, FREQUENCIES_FILE);
        file2zip.add(frequencyFile);
        try {
            writer = Files.newWriter((File)frequencyFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvFrequencyModel, frequencyRows);
            export.write((Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.frequencies.error", (Object[])new Object[]{frequencyFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        this.exportAttachments(directory, file2zip, attachmentRows);
        try {
            ZipUtil.compressFiles((File)file, (File)directory, (Collection)file2zip);
        }
        catch (IOException e) {
            try {
                throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.error", (Object[])new Object[]{file}), (Throwable)e);
            }
            catch (Throwable throwable) {
                TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
                throw throwable;
            }
        }
        TuttiIOUtil.deleteDirectory((File)directory, (String)I18n._((String)"tutti.service.multipost.export.deleteTempDirectory.error", (Object[])new Object[]{file}));
    }

    protected void createSpeciesRow(SpeciesBatch batch, String parentId, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRow row = new CatchRow();
        String id = UUID.randomUUID().toString();
        row.setId(id);
        row.setParentId(parentId);
        row.setSpecies(batch.getSpecies());
        row.setCategoryId(batch.getSampleCategoryId());
        row.setCategoryValue(batch.getSampleCategoryValue());
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        rows.add(row);
        this.addFrequencies(id, batch.getId(), frequencyRows);
        this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.BATCH, attachmentRows);
        for (SpeciesBatch child : batch.getChildBatchs()) {
            this.createSpeciesRow(child, id, rows, frequencyRows, attachmentRows);
        }
    }

    protected void createBenthosRow(BenthosBatch batch, String parentId, List<CatchRow> rows, List<CatchFrequencyRow> frequencyRows, List<AttachmentRow> attachmentRows) {
        CatchRow row = new CatchRow();
        String id = UUID.randomUUID().toString();
        row.setId(id);
        row.setParentId(parentId);
        row.setSpecies(batch.getSpecies());
        row.setCategoryId(batch.getSampleCategoryId());
        row.setCategoryValue(batch.getSampleCategoryValue());
        row.setCategoryWeight(batch.getSampleCategoryWeight());
        row.setWeight(batch.getWeight());
        row.setNumber(batch.getNumber());
        row.setComment(batch.getComment());
        row.setToConfirm(batch.isSpeciesToConfirm());
        rows.add(row);
        this.addFrequencies(id, batch.getId(), frequencyRows);
        this.addAttachments(id, batch.getIdAsInt(), AttachementObjectTypeEnum.BATCH, attachmentRows);
        for (BenthosBatch child : batch.getChildBatchs()) {
            this.createBenthosRow(child, id, rows, frequencyRows, attachmentRows);
        }
    }

    protected void exportOperation(AbstractFishingOperationRow afoRow, FishingOperation operation) {
        afoRow.setStationNumber(operation.getStationNumber());
        afoRow.setOperationNumber(operation.getFishingOperationNumber());
        afoRow.setMultirigAggregation(operation.getMultirigAggregation());
        afoRow.setDate(operation.getGearShootingStartDate());
    }

    protected void exportAttachments(File directory, List<File> file2zip, List<AttachmentRow> attachmentRows) {
        AttachmentRowModel csvAttachmentModel = new AttachmentRowModel(this.csvSeparator);
        File attachmentDirectory = new File(directory, ATTACHMENTS_DIRECTORY);
        attachmentDirectory.mkdir();
        file2zip.add(attachmentDirectory);
        for (AttachmentRow attachmentRow : attachmentRows) {
            File attachmentFile = attachmentRow.getFile();
            File destFile = new File(attachmentDirectory, attachmentFile.getName());
            TuttiIOUtil.copyFile((File)attachmentFile, (File)destFile, (String)I18n._((String)"tutti.service.multipost.attachment.copy.error", (Object[])new Object[]{attachmentFile}));
            file2zip.add(destFile);
        }
        File attachmentFile = new File(directory, ATTACHMENTS_FILE);
        file2zip.add(attachmentFile);
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)attachmentFile, (Charset)Charsets.UTF_8);
            Export export = Export.newExport((ExportModel)csvAttachmentModel, attachmentRows);
            export.write((Writer)writer);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.export.attachments.error", (Object[])new Object[]{attachmentFile}), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected void addFrequencies(String rowId, String batchId, List<CatchFrequencyRow> frequencyRows) {
        List<SpeciesBatchFrequency> frequencies = this.persistenceService.getAllSpeciesBatchFrequency(batchId);
        for (SpeciesBatchFrequency frequency : frequencies) {
            CatchFrequencyRow frequencyRow = new CatchFrequencyRow();
            frequencyRow.setBatchId(rowId);
            frequencyRow.setLengthStepCaracteristic(frequency.getLengthStepCaracteristic());
            frequencyRow.setLengthStep(frequency.getLengthStep());
            frequencyRow.setNumber(frequency.getNumber());
            frequencyRow.setWeight(frequency.getWeight());
            frequencyRows.add(frequencyRow);
        }
    }

    protected void addAttachments(String batchId, int objectId, AttachementObjectTypeEnum objectType, List<AttachmentRow> attachmentRows) {
        List<Attachment> attachments = this.persistenceService.getAllAttachments(objectType, objectId);
        for (Attachment attachment : attachments) {
            AttachmentRow attachmentRow = new AttachmentRow();
            attachmentRow.setBatchId(batchId);
            attachmentRow.setName(attachment.getName());
            attachmentRow.setComment(attachment.getComment());
            attachmentRow.setFile(this.persistenceService.getAttachmentFile(attachment.getId()));
            attachmentRows.add(attachmentRow);
        }
    }

    protected Pair<Integer, Serializable> getValueAndCategoryType(CatchRow row) {
        Serializable value = row.getCategoryValue();
        Integer categoryId = row.getCategoryId();
        return Pair.of((Object)categoryId, (Object)value);
    }

    protected void importAttachments(File directory, Function<AttachmentRow, Integer> getObjetcIdFunction, AttachementObjectTypeEnum objectType) {
        BufferedReader reader;
        File attachmentFile = new File(directory, ATTACHMENTS_FILE);
        File attachmentDirectory = new File(directory, ATTACHMENTS_DIRECTORY);
        try {
            reader = Files.newReader((File)attachmentFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.attachments.error", (Object[])new Object[]{attachmentFile}), (Throwable)e);
        }
        AttachmentRowModel attachmentModel = new AttachmentRowModel(this.csvSeparator, attachmentDirectory);
        Import attachmentImporter = Import.newImport((ImportModel)attachmentModel, (Reader)reader);
        for (AttachmentRow row : attachmentImporter) {
            Integer objectId = (Integer)getObjetcIdFunction.apply((Object)row);
            if (objectId == null) continue;
            Attachment attachment = TuttiBeanFactory.newAttachment();
            attachment.setName(row.getName());
            attachment.setComment(row.getComment());
            attachment.setObjectType(objectType);
            attachment.setObjectId(objectId);
            this.persistenceService.createAttachment(attachment, row.getFile());
        }
    }

    protected void checkSameOperation(File directory, AbstractFishingOperationRowModel fishingOperationRowModel, FishingOperation operation) {
        AbstractFishingOperationRow row;
        BufferedReader reader;
        File operationFile = new File(directory, WEIGHTS_FILE);
        try {
            reader = Files.newReader((File)operationFile, (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new TuttiTechnicalException(I18n._((String)"tutti.service.multipost.import.operation.error", (Object[])new Object[]{operationFile}), (Throwable)e);
        }
        Import fishingOperationImporter = Import.newImport((ImportModel)fishingOperationRowModel, (Reader)reader);
        Iterator iterator = fishingOperationImporter.iterator();
        if (iterator.hasNext() && (ObjectUtils.notEqual((Object)(row = (AbstractFishingOperationRow)iterator.next()).getStationNumber(), (Object)operation.getStationNumber()) || ObjectUtils.notEqual((Object)row.getOperationNumber(), (Object)operation.getFishingOperationNumber()) || ObjectUtils.notEqual((Object)row.getMultirigAggregation(), (Object)operation.getMultirigAggregation()) || ObjectUtils.notEqual((Object)row.getDate(), (Object)operation.getGearShootingStartDate()))) {
            throw new TuttiBusinessException(I18n._((String)"tutti.service.multipost.import.wrongOperation.error", (Object[])new Object[]{this.decoratorService.getDecoratorByType(FishingOperation.class).toString((Object)operation)}));
        }
    }
}

