/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.namespace;

import java.io.InputStream;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.ComponentContainer;
import org.andromda.core.common.Merger;
import org.andromda.core.common.ResourceFinder;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.XmlObjectFactory;
import org.andromda.core.configuration.Namespaces;
import org.andromda.core.namespace.Component;
import org.andromda.core.namespace.NamespaceComponent;
import org.andromda.core.namespace.NamespaceComponentsException;
import org.andromda.core.namespace.NamespaceRegistry;
import org.andromda.core.profile.Profile;
import org.apache.commons.lang.StringUtils;

public class NamespaceComponents {
    private static NamespaceComponents instance;
    private static final String CONFIGURATION_URI = "META-INF/andromda/namespace-components.xml";
    private Collection registeredNamespaceResources = new ArrayList();
    private Collection registeredRegistries = new ArrayList();
    private String path;
    private final Map components = new LinkedHashMap();
    static /* synthetic */ Class class$org$andromda$core$namespace$NamespaceComponents;
    static /* synthetic */ Class class$org$andromda$core$namespace$NamespaceRegistry;

    public static final NamespaceComponents instance() {
        if (instance == null) {
            XmlObjectFactory factory = XmlObjectFactory.getInstance(class$org$andromda$core$namespace$NamespaceComponents == null ? (class$org$andromda$core$namespace$NamespaceComponents = NamespaceComponents.class$("org.andromda.core.namespace.NamespaceComponents")) : class$org$andromda$core$namespace$NamespaceComponents);
            instance = (NamespaceComponents)factory.getObject(ResourceUtils.getResource(CONFIGURATION_URI));
        }
        return instance;
    }

    public void discover() {
        AndroMDALogger.info("- discovering namespaces -");
        XmlObjectFactory registryFactory = XmlObjectFactory.getInstance(class$org$andromda$core$namespace$NamespaceRegistry == null ? (class$org$andromda$core$namespace$NamespaceRegistry = NamespaceComponents.class$("org.andromda.core.namespace.NamespaceRegistry")) : class$org$andromda$core$namespace$NamespaceRegistry);
        ComponentContainer container = ComponentContainer.instance();
        Map registryMap = this.discoverAllRegistries();
        ArrayList registries = new ArrayList(registryMap.keySet());
        Collections.sort(registries, new NamespaceRegistryComparator());
        Iterator iterator = registries.iterator();
        while (iterator.hasNext()) {
            NamespaceRegistry registry = (NamespaceRegistry)iterator.next();
            URL resource = (URL)registryMap.get(registry);
            String registryName = registry.getName();
            if (!this.registeredNamespaceResources.contains(resource)) {
                NamespaceRegistry existingRegistry;
                Namespaces namespaces = Namespaces.instance();
                String namespace = registry.isShared() ? "default" : registry.getName();
                Merger merger = Merger.instance();
                boolean requiresMerge = merger.requiresMerge(namespace);
                if (requiresMerge) {
                    registry = (NamespaceRegistry)registryFactory.getObject(merger.getMergedString(ResourceUtils.getContents(resource), namespace), resource);
                }
                registry.addResourceRoot(this.getNamespaceResourceRoot(resource));
                if (!this.registeredRegistries.contains(registryName)) {
                    AndroMDALogger.info("found namespace --> '" + registryName + "'");
                    this.registeredRegistries.add(registryName);
                }
                if ((existingRegistry = namespaces.getRegistry(registryName)) != null) {
                    registry.copy(existingRegistry);
                }
                namespaces.addRegistry(registry);
                String[] components = registry.getRegisteredComponents();
                int componentNumber = components.length;
                for (int componentCtr = 0; componentCtr < componentNumber; ++componentCtr) {
                    String componentName = components[componentCtr];
                    Component component = this.getComponent(componentName);
                    if (component == null) {
                        throw new NamespaceComponentsException("'" + componentName + "' is not a valid namespace component");
                    }
                    component.addPaths(registry.getPaths(component.getName()));
                    if (container.isRegisteredByNamespace(registryName, component.getType())) continue;
                    AndroMDALogger.info("  +  registering component '" + componentName + "'");
                    XmlObjectFactory componentFactory = XmlObjectFactory.getInstance(component.getType());
                    URL componentResource = this.getNamespaceResource(registry.getResourceRoots(), component.getPaths());
                    if (componentResource == null) {
                        throw new NamespaceComponentsException("'" + componentName + "' is not a valid component within namespace '" + namespace + "' (the " + componentName + "'s descriptor can not be found)");
                    }
                    NamespaceComponent namespaceComponent = (NamespaceComponent)componentFactory.getObject(componentResource);
                    if (requiresMerge) {
                        namespaceComponent = (NamespaceComponent)componentFactory.getObject(merger.getMergedString(ResourceUtils.getContents(componentResource), namespace));
                    }
                    namespaceComponent.setNamespace(registryName);
                    namespaceComponent.setResource(componentResource);
                    container.registerComponentByNamespace(registryName, component.getType(), namespaceComponent);
                }
            }
            this.registeredNamespaceResources.add(resource);
        }
        Profile.instance().initialize();
    }

    private Map discoverAllRegistries() {
        HashMap<NamespaceRegistry, URL> registries = new HashMap<NamespaceRegistry, URL>();
        URL[] resources = ResourceFinder.findResources(this.getPath());
        XmlObjectFactory registryFactory = XmlObjectFactory.getInstance(class$org$andromda$core$namespace$NamespaceRegistry == null ? (class$org$andromda$core$namespace$NamespaceRegistry = NamespaceComponents.class$("org.andromda.core.namespace.NamespaceRegistry")) : class$org$andromda$core$namespace$NamespaceRegistry);
        if (resources != null && resources.length > 0) {
            int numberOfResources = resources.length;
            for (int ctr = 0; ctr < numberOfResources; ++ctr) {
                URL resource = resources[ctr];
                NamespaceRegistry registry = (NamespaceRegistry)registryFactory.getObject(resource);
                registries.put(registry, resource);
            }
        }
        return registries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getNamespaceResource(URL[] resourceRoots, String[] paths) {
        URL namespaceResource = null;
        if (resourceRoots != null) {
            int numberOfResourceRoots = resourceRoots.length;
            for (int ctr = 0; ctr < numberOfResourceRoots; ++ctr) {
                URL resource = resourceRoots[ctr];
                int pathNumber = paths.length;
                for (int ctr2 = 0; ctr2 < pathNumber; ++ctr2) {
                    String path = paths[ctr2];
                    InputStream stream = null;
                    try {
                        namespaceResource = new URL(ResourceUtils.normalizePath(resource + path));
                        stream = namespaceResource.openStream();
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        namespaceResource = null;
                    }
                    finally {
                        stream = null;
                    }
                    if (namespaceResource != null) break;
                }
                if (namespaceResource != null) break;
            }
        }
        return namespaceResource;
    }

    private URL getNamespaceResourceRoot(URL resource) {
        String resourcePath = resource != null ? resource.toString().replace('\\', '/') : null;
        return ResourceUtils.toURL(StringUtils.replace((String)resourcePath, (String)this.path, (String)""));
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addComponent(Component component) {
        if (component != null) {
            this.components.put(component.getName(), component);
        }
    }

    public void shutdown() {
        this.components.clear();
        this.registeredNamespaceResources.clear();
        this.registeredRegistries.clear();
        instance = null;
    }

    private Component getComponent(String name) {
        return (Component)this.components.get(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class NamespaceRegistryComparator
    implements Comparator {
        private final Collator collator = Collator.getInstance();

        NamespaceRegistryComparator() {
            this.collator.setStrength(0);
        }

        public int compare(Object objectA, Object objectB) {
            NamespaceRegistry a = (NamespaceRegistry)objectA;
            NamespaceRegistry b = (NamespaceRegistry)objectB;
            return this.collator.compare(a.getName(), b.getName());
        }
    }
}

