package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveBenthosSubBatchAction.java 1170 2013-09-13 16:21:34Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/benthos/RemoveBenthosSubBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import org.jdesktop.swingx.JXTable;

import javax.swing.JOptionPane;
import java.util.Set;

import static org.nuiton.i18n.I18n._;

/**
 * To remove a species batch children.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 */
public class RemoveBenthosSubBatchAction extends AbstractTuttiAction<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {

    public RemoveBenthosSubBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();

        if (result) {
            int answer = JOptionPane.showConfirmDialog(getContext().getActionUI(),
                                                       _("tutti.editBenthosBatch.action.removeSubBatch.confirm.message"),
                                                       _("tutti.editBenthosBatch.action.removeSubBatch.confirm.title"),
                                                       JOptionPane.YES_NO_OPTION);
            result = answer == JOptionPane.YES_OPTION;
        }

        return result;
    }

    @Override
    public void doAction() throws Exception {

        TuttiPersistence persistenceService =
                getContext().getPersistenceService();

        JXTable table = handler.getTable();

        int rowIndex = table.getSelectedRow();

        Preconditions.checkState(rowIndex != -1,
                                 "Cant remove sub batch if no batch selected");

        BenthosBatchRowModel parentBatch = handler.getTableModel().getEntry(rowIndex);

        Preconditions.checkState(!TuttiEntities.isNew(parentBatch),
                                 "Can't remove sub batch if batch is not persisted");

        // save parent batch (will destroy all his childs from db)
        persistenceService.deleteSpeciesSubBatch(parentBatch.getId());

        // collect of rows to remove from model
        Set<BenthosBatchRowModel> rowToRemove = Sets.newHashSet();

        handler.collectChildren(parentBatch, rowToRemove);

        table.clearSelection();

        // remove all rows from the model
        getModel().getRows().removeAll(rowToRemove);

        // remove childs from parent batch
        parentBatch.setChildBatch(null);

        // refresh table from parent batch row index to the end
        handler.getTableModel().fireTableDataChanged();

        // select parent batch row
        AbstractSelectTableAction.doSelectCell(table, rowIndex, 0);

        if (table.isEditing()) {

            // but no edit it
            table.getCellEditor().stopCellEditing();
        }
    }

}
