/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.core.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.andromda.core.common.ClassUtils;
import org.andromda.core.common.ComponentContainerException;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.ResourceUtils;
import org.apache.log4j.Logger;

public class ComponentContainer {
    private static Logger logger = Logger.getLogger((Class)(class$org$andromda$core$common$ComponentContainer == null ? (class$org$andromda$core$common$ComponentContainer = ComponentContainer.class$("org.andromda.core.common.ComponentContainer")) : class$org$andromda$core$common$ComponentContainer));
    private static final String SERVICES = "META-INF/services/";
    private final Map container = new LinkedHashMap();
    private static ComponentContainer instance = null;
    static /* synthetic */ Class class$org$andromda$core$common$ComponentContainer;

    public static ComponentContainer instance() {
        if (instance == null) {
            instance = new ComponentContainer();
        }
        return instance;
    }

    public Object findComponent(Object key) {
        return this.container.get(key);
    }

    public Object newComponent(String implementation, Class type) {
        implementation = implementation != null ? implementation.trim() : "";
        Object component = implementation.length() == 0 ? this.newDefaultComponent(type) : ClassUtils.newInstance(implementation);
        return component;
    }

    public Object newComponent(Class implementation, Class type) {
        Object component = implementation == null ? this.newDefaultComponent(type) : ClassUtils.newInstance(implementation);
        return component;
    }

    public Object newDefaultComponent(Class type) {
        Object component;
        ExceptionUtils.checkNull("type", type);
        try {
            String implementation = this.getDefaultImplementation(type);
            if (implementation.trim().length() == 0) {
                throw new ComponentContainerException("Default configuration file '" + this.getComponentDefaultConfigurationPath(type) + "' could not be found");
            }
            component = ClassUtils.loadClass(implementation).newInstance();
        }
        catch (Throwable throwable) {
            throw new ComponentContainerException(throwable);
        }
        return component;
    }

    protected final String getComponentDefaultConfigurationPath(Class type) {
        ExceptionUtils.checkNull("type", type);
        return SERVICES + type.getName();
    }

    public Object findComponent(Class key) {
        ExceptionUtils.checkNull("key", key);
        return this.findComponent(null, key);
    }

    public Object findRequiredComponent(Class key) {
        Object component = this.findComponent(key);
        if (component == null) {
            throw new ComponentContainerException("No implementation could be found for component '" + key.getName() + "', please make sure you have a '" + this.getComponentDefaultConfigurationPath(key) + "' file on your classpath");
        }
        return component;
    }

    public Object findComponent(String key, Class type) {
        ExceptionUtils.checkNull("type", type);
        try {
            String typeName;
            Object component = this.findComponent(key);
            if (component == null && (component = this.findComponent(typeName = type.getName())) == null) {
                String defaultImplementation = this.getDefaultImplementation(type);
                if (defaultImplementation.trim().length() > 0) {
                    component = this.registerDefaultComponent(ClassUtils.loadClass(typeName), ClassUtils.loadClass(defaultImplementation));
                } else {
                    logger.warn((Object)("WARNING! Component's default configuration file '" + this.getComponentDefaultConfigurationPath(type) + "' could not be found"));
                }
            }
            return component;
        }
        catch (Throwable throwable) {
            throw new ComponentContainerException(throwable);
        }
    }

    private String getDefaultImplementation(Class type) {
        String contents = ResourceUtils.getContents(this.getComponentDefaultConfigurationPath(type));
        return contents != null ? contents.trim() : "";
    }

    public Collection findComponentsOfType(Class type) {
        ArrayList components = new ArrayList(this.container.values());
        Collection containerInstances = this.container.values();
        Iterator iterator = containerInstances.iterator();
        while (iterator.hasNext()) {
            Object component = iterator.next();
            if (!(component instanceof ComponentContainer)) continue;
            components.addAll(((ComponentContainer)component).container.values());
        }
        ArrayList componentsOfType = new ArrayList();
        Iterator iterator2 = components.iterator();
        while (iterator2.hasNext()) {
            Object component = iterator2.next();
            if (!type.isInstance(component)) continue;
            componentsOfType.add(component);
        }
        return componentsOfType;
    }

    public Object unregisterComponent(String key) {
        ExceptionUtils.checkEmpty("key", key);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("unregistering component with key --> '" + key + "'"));
        }
        return this.container.remove(key);
    }

    public Object findComponentByNamespace(String namespace, Object key) {
        ExceptionUtils.checkEmpty("namespace", namespace);
        ExceptionUtils.checkNull("key", key);
        Object component = null;
        ComponentContainer namespaceContainer = this.getNamespaceContainer(namespace);
        if (namespaceContainer != null) {
            component = namespaceContainer.findComponent(key);
        }
        return component;
    }

    private ComponentContainer getNamespaceContainer(String namespace) {
        return (ComponentContainer)this.findComponent(namespace);
    }

    public boolean isRegisteredByNamespace(String namespace, Object key) {
        ExceptionUtils.checkEmpty("namespace", namespace);
        ExceptionUtils.checkNull("key", key);
        ComponentContainer namespaceContainer = this.getNamespaceContainer(namespace);
        return namespaceContainer != null && namespaceContainer.isRegistered(key);
    }

    public boolean isRegistered(Object key) {
        return this.findComponent(key) != null;
    }

    public void registerComponentByNamespace(String namespace, Object key, Object component) {
        ComponentContainer namespaceContainer;
        ExceptionUtils.checkEmpty("namespace", namespace);
        ExceptionUtils.checkNull("component", component);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registering component '" + component + "' with key --> '" + key + "'"));
        }
        if ((namespaceContainer = this.getNamespaceContainer(namespace)) == null) {
            namespaceContainer = new ComponentContainer();
            this.registerComponent(namespace, namespaceContainer);
        }
        namespaceContainer.registerComponent(key, component);
    }

    public Object registerComponent(Object key, Object component) {
        ExceptionUtils.checkNull("component", component);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registering component '" + component + "' with key --> '" + key + "'"));
        }
        return this.container.put(key, component);
    }

    public void registerDefaultComponent(Class componentInterface, String defaultTypeName) {
        ExceptionUtils.checkNull("componentInterface", componentInterface);
        ExceptionUtils.checkEmpty("defaultTypeName", defaultTypeName);
        try {
            this.registerDefaultComponent(componentInterface, ClassUtils.loadClass(defaultTypeName));
        }
        catch (Throwable throwable) {
            throw new ComponentContainerException(throwable);
        }
    }

    public Object registerDefaultComponent(Class componentInterface, Class defaultType) {
        ExceptionUtils.checkNull("componentInterface", componentInterface);
        ExceptionUtils.checkNull("defaultType", defaultType);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("registering default for component '" + componentInterface + "' as type --> '" + defaultType + "'"));
        }
        try {
            String interfaceName = componentInterface.getName();
            if (this.isRegistered(interfaceName)) {
                this.unregisterComponent(interfaceName);
            }
            Object component = defaultType.newInstance();
            this.container.put(interfaceName, component);
            return component;
        }
        catch (Throwable throwable) {
            throw new ComponentContainerException(throwable);
        }
    }

    public void registerComponentType(Class type) {
        ExceptionUtils.checkNull("type", type);
        try {
            this.container.put(type, type.newInstance());
        }
        catch (Throwable throwable) {
            throw new ComponentContainerException(throwable);
        }
    }

    public Object registerComponentType(String type) {
        ExceptionUtils.checkNull("type", type);
        try {
            return this.registerComponent(type, ClassUtils.loadClass(type).newInstance());
        }
        catch (Throwable throwable) {
            throw new ComponentContainerException(throwable);
        }
    }

    public void shutdown() {
        this.container.clear();
        instance = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

