package fr.ifremer.tutti.ui.swing.content.config;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.model.JaxxDefaultListModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class SampleOrderEditorUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTQU8TQRR+rW2xVFQkIEQ0IBpPbL1DFFNAIAWMxYTYgw7doQxOd8bZt7KEYPwJ/gS9ezHx5sl48OzBi/EvGOPBq/HNbtstUoHEJp0289773vfefN+b75D1DYxvszB0TOChaHBn6c76+urGNq/hLPdrRmhUBuJPKg3pKhTc9r2PMFEt2/Jis7xYUg2tPO51VE+VodfHXcn9Lc4R4fLBiprvFyvt8FSoA9NCbZPqhvrq54/0S/fF6zRAqIldD40ydlxVMkmmDGnhIlygTs9YUTKvTjSM8OrEt8/elSTz/RXW4E/hOfSUIaeZITCEqycfOcKI6kONMOKzhpbUYtW43My5glJnBZOqjjC9aRyxaXiDGwcDROEEwvF3KNmpKQ8J3v5uirpTsSC8A+LBotZRkxxCZoMzD+GsHcAJUEinLHxM4j1bzHMlNwil/2m4EKMkuHlJbZaVyyXC5IFXiCEbNuQsUWCWb7JAYrmVn2DE6+lstKb0PeZZzHFl6s42Se8JKh1jhs7S+ppAyd0ox4Lk21h915YqNaOktLGbCBftQsImmY6QTR9MtmenQOg/kGyZ2viwJoVdOjAbaddJtJuIK1WFrAnoGmG4elju9ykUC334L6FbwCj6e2jgy/tv7+Zb6s5Q78GuqR3mJNVpozS9rrCtz8XStiooLjM9VYW8zyU5O3LuaBdilWaYyFG//kREC8zfIohsz9cPH4cefz4F6XnolYq588zmL0IetwxtQUk31LdnIkZndk7TeZ6+aYRC4Lm8pgxDTqbLoAloXwUmd9iuv+rROzcvQ1rKaJeltJlt5D/9Gqi8nWktJkVER/6Zniwn+xBywiPz8cj4TU93NXpB+zxwVeLdbm6Go+ysm6KeiM4bhxaSQsiilS7Cldh7Tat1OMCJEsLAIkxGg9p/RTjKJ8f1pYfINmKTFvbajt0nu8TCEMqzNwjX96zqK52X0qksrtwtzz2qzJXnSmuLqyv73chFFjrB/DnJdhWNDmenXYZsbEN4Lq3y1iHMlD17CfEP4/fydK8GAAA=";
    private static final Log log = LogFactory.getLog(SampleOrderEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Caracteristic> bean;
    protected SampleOrderEditorUIHandler handler;
    protected JList list;
    protected JaxxDefaultListModel<Caracteristic> listModel;
    protected JXTitledPanel sampleOrderEditorTopPanel;
    protected SampleOrderEditorUI samplingOrderEditorDialog = this;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        getHandler().afterInitUI();
    }
    
    public void openEditor(JComponent component) {
       handler.openEditor(component);
    }
    
    public void closeEditor() {
       handler.closeEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SampleOrderEditorUI(TuttiUIContext context) {
        super(context.getMainUI());
            setContextValue(context);
            SampleOrderEditorUIHandler handler = new SampleOrderEditorUIHandler(context, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SampleOrderEditorUI(Window param0) {
        super(param0);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI() {
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SampleOrderEditorUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public SampleOrderEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public List<Caracteristic> getBean() {
        return bean;
    }

    public SampleOrderEditorUIHandler getHandler() {
        return handler;
    }

    public JList getList() {
        return list;
    }

    public JaxxDefaultListModel<Caracteristic> getListModel() {
        return listModel;
    }

    public JXTitledPanel getSampleOrderEditorTopPanel() {
        return sampleOrderEditorTopPanel;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(List<Caracteristic> bean) {
        List<Caracteristic> oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSampleOrderEditorTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        sampleOrderEditorTopPanel.add($JScrollPane0);
    }

    protected void addChildrenToSamplingOrderEditorDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(sampleOrderEditorTopPanel, BorderLayout.CENTER);
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SampleOrderEditorUIHandler.class));
    }

    protected void createList() {
        $objectMap.put("list", list = new JList());
        
        list.setName("list");
    }

    protected void createListModel() {
        $objectMap.put("listModel", listModel = new JaxxDefaultListModel<Caracteristic>());
    }

    protected void createSampleOrderEditorTopPanel() {
        $objectMap.put("sampleOrderEditorTopPanel", sampleOrderEditorTopPanel = new JXTitledPanel());
        
        sampleOrderEditorTopPanel.setName("sampleOrderEditorTopPanel");
        sampleOrderEditorTopPanel.setTitle(_("tutti.config.sampleOrder.title"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSamplingOrderEditorDialog();
        addChildrenToSampleOrderEditorTopPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        
        // apply 3 property setters
        list.setModel(listModel);
        list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        // late initializer
        samplingOrderEditorDialog.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("samplingOrderEditorDialog", samplingOrderEditorDialog);
        createBean();
        createHandler();
        createListModel();
        createSampleOrderEditorTopPanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        // inline creation of samplingOrderEditorDialog
        setName("samplingOrderEditorDialog");
        samplingOrderEditorDialog.getContentPane().setLayout(new BorderLayout());
        setUndecorated(true);
        setAlwaysOnTop(true);
        
        $completeSetup();
    }

}