/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.vessel.feature.physical;

import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.data.measure.GearPhysicalMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeaturesDaoBase;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeaturesExtendDao;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.gear.GearImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import java.io.Serializable;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository(value="gearPhysicalFeaturesDao")
@Lazy
public class GearPhysicalFeaturesDaoImpl
extends GearPhysicalFeaturesDaoBase
implements GearPhysicalFeaturesExtendDao {
    @Autowired
    public GearPhysicalFeaturesDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public GearPhysicalFeatures getGearPhysicalfeatures(FishingTrip fishingTrip, Integer gearId) {
        return this.getGearPhysicalfeatures(fishingTrip, gearId, false);
    }

    @Override
    public GearPhysicalFeatures getGearPhysicalfeatures(FishingTrip fishingTrip, Integer gearId, boolean createIfNotExists) {
        if (fishingTrip.getGearPhysicalFeatures() != null && fishingTrip.getGearPhysicalFeatures().size() >= 0) {
            for (GearPhysicalFeatures guf : fishingTrip.getGearPhysicalFeatures()) {
                if (!gearId.equals(guf.getGear().getId())) continue;
                return guf;
            }
        }
        if (!createIfNotExists) {
            return null;
        }
        GearPhysicalFeatures gearPhysicalFeature = GearPhysicalFeatures.Factory.newInstance();
        gearPhysicalFeature.setFishingTrip(fishingTrip);
        Gear gear = this.load(GearImpl.class, (Serializable)gearId);
        gearPhysicalFeature.setGear(gear);
        if (fishingTrip.getGearPhysicalFeatures() == null) {
            fishingTrip.setGearPhysicalFeatures(Lists.newArrayList((Object[])new GearPhysicalFeatures[]{gearPhysicalFeature}));
        } else {
            fishingTrip.getGearPhysicalFeatures().add(gearPhysicalFeature);
        }
        return gearPhysicalFeature;
    }

    @Override
    public GearPhysicalMeasurement getGearPhysicalMeasurement(GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId) {
        return this.getGearPhysicalMeasurement(null, gearPhysicalFeatures, pmfmId, false);
    }

    protected GearPhysicalMeasurement getGearPhysicalMeasurement(ScientificCruise scientificCruise, GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId, boolean createIfNotExists) {
        GearPhysicalMeasurement gearPhysicalMeasurement = null;
        if (gearPhysicalFeatures.getGearPhysicalMeasurements() != null) {
            for (GearPhysicalMeasurement vum : gearPhysicalFeatures.getGearPhysicalMeasurements()) {
                if (!pmfmId.equals(vum.getPmfm().getId())) continue;
                gearPhysicalMeasurement = vum;
                break;
            }
        }
        if (gearPhysicalMeasurement == null) {
            if (!createIfNotExists) {
                return null;
            }
            gearPhysicalMeasurement = GearPhysicalMeasurement.Factory.newInstance();
            gearPhysicalMeasurement.setGearPhysicalFeatures(gearPhysicalFeatures);
            if (gearPhysicalFeatures.getGearPhysicalMeasurements() == null) {
                gearPhysicalFeatures.setGearPhysicalMeasurements(Lists.newArrayList((Object[])new GearPhysicalMeasurement[]{gearPhysicalMeasurement}));
            } else {
                gearPhysicalFeatures.getGearPhysicalMeasurements().add(gearPhysicalMeasurement);
            }
            gearPhysicalMeasurement.setQualityFlag(this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
            gearPhysicalMeasurement.setDepartment(scientificCruise.getRecorderDepartment());
            Pmfm pmfm = this.load(PmfmImpl.class, (Serializable)pmfmId);
            gearPhysicalMeasurement.setPmfm(pmfm);
        }
        return gearPhysicalMeasurement;
    }

    @Override
    public void removeGearPhysicalMeasurement(GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId) {
        GearPhysicalMeasurement gearPhysicalMeasurement = this.getGearPhysicalMeasurement(null, gearPhysicalFeatures, pmfmId, false);
        if (gearPhysicalMeasurement == null) {
            return;
        }
        gearPhysicalFeatures.getGearPhysicalMeasurements().remove(gearPhysicalMeasurement);
    }

    @Override
    public GearPhysicalMeasurement setGearPhysicalMeasurement(ScientificCruise scientificCruise, GearPhysicalFeatures gearPhysicalFeatures, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        GearPhysicalMeasurement gearPhysicalMeasurement = this.getGearPhysicalMeasurement(scientificCruise, gearPhysicalFeatures, pmfmId, true);
        if (alphanumericalValue != null) {
            gearPhysicalMeasurement.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            gearPhysicalMeasurement.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            QualitativeValue qv = this.load(QualitativeValueImpl.class, (Serializable)qualitativevalueId);
            gearPhysicalMeasurement.setQualitativeValue(qv);
        }
        return gearPhysicalMeasurement;
    }
}

