package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: CloseableUI.java 556 2013-03-06 22:07:26Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/CloseableUI.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

/**
 * Contract to close an ui.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.2
 */
public interface CloseableUI {

    /**
     * Try to quit UI.
     *
     * @return {@code true} if ui is safe to quit, {@code false} otherwise
     *         (means must stay on it).
     */
    boolean quitUI();
}
