package fr.ifremer.tutti.ui.swing.content.referential;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.help.JAXXHelpUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class ManageTemporaryReferentialUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<TuttiUIContext, ManageTemporaryReferentialUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVYzW8bRRQfu4nTfAAlpiFtU6lNg5RQdd2kF6T0K99xvprWSVWRQxnbY2fKfrE7bh1FRfwJ/Alw54LEjRPiwJkDF8S/gBCHXhFvduz1znrHu7GdHqxm5r3f+715b3/zdn/4Gw26Drr5CtfrmlMzGTWItrX04sWT4itSYqvELTnUZpaDxL9UGqWP0GjZX3cZunW0w91zDffcimXYlknMgPfiDhpx2YlO3GNCGEPXZY+S6+YK/vZi3a45TVSfVBTqd//+k/62/M33aYTqNrCbhFRuxHm1MhnYQWlaZmgcIr3GOR2bVaDhULMKfN/jays6dt09bJCv0NdoaAdlbOwAGEPTyVP2MDz/ug2OBjZxlRwQcHCwc/KMVAiHpFg/sOx9bBKdoa2Ko9GKQwziaKzGGNVqVHPfADGtZJkMzDWn5aftKiEP87btxc4wNHSMzbJOHIae9g9+U2C2ogwaVpmnMKuOccD/PMyv8FB11nLNFB3rS85vLsZ3k+j2smcbyG7mABd1cpehSakBGm58j1sO+w5jrk1KlLg7uMj5jvNy1xvmW94iN7zs21+c2fKqczds663KtldJHc6KFUSEtTo2bJ0sA3VIGWUlb7HK/a757llqBNxbFjdks7GZrQKBhsTQbcBqQsL1d2Rmo6+J6xLdz+9qdJLz/O/r8t4VkdRzD0DKyec26xuPixSEsdIqmIEX8hM55HCVYCeO60IE148F1w1wj2a64JteEky5qdImyHMhgueoTRzXMuOY3lOf6r4HEM31fvhUhXG7lYOuSb0Psqq1ZLWle6kjNOjUYBkelqN2JX4GW0KDJ0MazAG93f8msn/8/NdP603hzULsy5GmgXsDBNF2LDgqRnnoD4Tq1hjVc7vYXjxCw9ArcOl4l8pUBLFCYxvIQbwPubvG3bVN7B4DxODQn7/8OvHF7xdQeh2N6BYur2Nun0fD7NiBU7D0ct1+9NhjNPbmIvxe4txAtV4eg6aA8pxOC8FRq7TGLaff1uF4piKOx+dYHP7tXbbw4+PmEaWA8hWleeuYBj9HGWrq1CTe7dS4eCJvo1HbJbWy1bpgoq4clOjOsRtKuuH9bredUZqhAa7WDC3HHhA1K5YmOlVjTYPgjcLQCNSFWmaeXzdolDs4BuYr9RqP/8Q7L/6/p0jej+N5AXhSD3X+tMCV8JD3R8khmJG8AYx5yNlpEf5O4wrQqrQyPffWT1GLTbFCiV7WGu7AkFmWfkDtA8994WzuGqN2VNrSBRWXd8YnvxYbXSSvCeHxLeTLKlSijDAGUi89+CVvj6Hbp2udUISZVuLtCMc7Ruc/M3dNYlgmLTG01xemmuEDymXI9wceqtPSh70E+pAItSki7WXvMDskb4KHSVmKxzTMMlx9YdVW/ZnTfKR757Jv9MZNWe94YeqMKxV6I3mhFXDqCkeNd0l0TZT2TkJ1EYNeuJLNVfno5s+EqRKs4GyZvFVXu3ygpDk0oVx9GpYrCaRz2+72g6eyeTf7gi618G7XWiWDqhtZ/UaQvPwPunzMnke2t0KoboWFSnh3Lvh6T8yUlV7qDVYq8XrXKtVAU9c24gUuuUbdTqgn/PUuVMIBsSafWe4MeCp1ar1LJm/OxFdK6AEKvHcmVKbZsDIFIDq36XbvHJW9mvgR6IAtNex215oUhFR3req9P3nJF7t8oDbaW1mlRjfDasR9Oxc58SUZwUpZ3Ue9gEplXe1ahzwsdT3bPs70f04Sn27CpWuudjcnCW/lnBT4WnT+c5L0ZanbOUkCOZ85SQrR9zlJRu/TnCSDxs5JEd/4zn9O2o9s76RzkvA+nzlJYPd9Ttr3n71+zEkNtNg5KfhJNq6oKSiAjk8sMEbv3y9jhm8UqVmmZvVhW4QU/x2JRYTlVJb/fBSNMNUzwlzPCPd6RngACP8DFLm9VrEcAAA=";
    private static final Log log = LogFactory.getLog(ManageTemporaryReferentialUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton exportGearExampleButton;
    protected JButton exportPersonExampleButton;
    protected JButton exportSpeciesExampleButton;
    protected JButton exportVesselExampleButton;
    protected JLabel gearLabel;
    protected ManageTemporaryReferentialUIHandler handler;
    protected JButton importGearButton;
    protected JButton importPersonButton;
    protected JButton importSpeciesButton;
    protected JButton importVesselButton;
    protected ManageTemporaryReferentialUI manageTemporaryReferentialTopPanel = this;
    protected TuttiUIContext model;
    protected JLabel personLabel;
    protected JLabel speciesLabel;
    protected JLabel vesselLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private JSeparator $JSeparator0;
    private JSeparator $JSeparator1;
    private JSeparator $JSeparator2;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ManageTemporaryReferentialUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                ManageTemporaryReferentialUIHandler handler =
                               new ManageTemporaryReferentialUIHandler(parentUI.getHandler().getContext(), this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public ManageTemporaryReferentialUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public ManageTemporaryReferentialUI() {
        $initialize();
    }

    public ManageTemporaryReferentialUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getExportGearExampleButton() {
        return exportGearExampleButton;
    }

    public JButton getExportPersonExampleButton() {
        return exportPersonExampleButton;
    }

    public JButton getExportSpeciesExampleButton() {
        return exportSpeciesExampleButton;
    }

    public JButton getExportVesselExampleButton() {
        return exportVesselExampleButton;
    }

    public JLabel getGearLabel() {
        return gearLabel;
    }

    public ManageTemporaryReferentialUIHandler getHandler() {
        return handler;
    }

    public JButton getImportGearButton() {
        return importGearButton;
    }

    public JButton getImportPersonButton() {
        return importPersonButton;
    }

    public JButton getImportSpeciesButton() {
        return importSpeciesButton;
    }

    public JButton getImportVesselButton() {
        return importVesselButton;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public JLabel getPersonLabel() {
        return personLabel;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected JSeparator get$JSeparator1() {
        return $JSeparator1;
    }

    protected JSeparator get$JSeparator2() {
        return $JSeparator2;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToManageTemporaryReferentialTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.manageTemporaryReferential.help"));
    }

    protected void createExportGearExampleButton() {
        $objectMap.put("exportGearExampleButton", exportGearExampleButton = new JButton());
        
        exportGearExampleButton.setName("exportGearExampleButton");
        exportGearExampleButton.setText(_("tutti.manageTemporaryReferential.action.exportTemporaryGearExample"));
        exportGearExampleButton.setToolTipText(_("tutti.manageTemporaryReferential.action.exportTemporaryGearExample.tip"));
        exportGearExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryGearExample.help");
        exportGearExampleButton.putClientProperty("tuttiAction", ExportTemporaryGearExampleAction.class);
    }

    protected void createExportPersonExampleButton() {
        $objectMap.put("exportPersonExampleButton", exportPersonExampleButton = new JButton());
        
        exportPersonExampleButton.setName("exportPersonExampleButton");
        exportPersonExampleButton.setText(_("tutti.manageTemporaryReferential.action.exportTemporaryPersonExample"));
        exportPersonExampleButton.setToolTipText(_("tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.tip"));
        exportPersonExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.help");
        exportPersonExampleButton.putClientProperty("tuttiAction", ExportTemporaryPersonExampleAction.class);
    }

    protected void createExportSpeciesExampleButton() {
        $objectMap.put("exportSpeciesExampleButton", exportSpeciesExampleButton = new JButton());
        
        exportSpeciesExampleButton.setName("exportSpeciesExampleButton");
        exportSpeciesExampleButton.setText(_("tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample"));
        exportSpeciesExampleButton.setToolTipText(_("tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.tip"));
        exportSpeciesExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.help");
        exportSpeciesExampleButton.putClientProperty("tuttiAction", ExportTemporarySpeciesExampleAction.class);
    }

    protected void createExportVesselExampleButton() {
        $objectMap.put("exportVesselExampleButton", exportVesselExampleButton = new JButton());
        
        exportVesselExampleButton.setName("exportVesselExampleButton");
        exportVesselExampleButton.setText(_("tutti.manageTemporaryReferential.action.exportTemporaryVesselExample"));
        exportVesselExampleButton.setToolTipText(_("tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.tip"));
        exportVesselExampleButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.help");
        exportVesselExampleButton.putClientProperty("tuttiAction", ExportTemporaryVesselExampleAction.class);
    }

    protected void createGearLabel() {
        $objectMap.put("gearLabel", gearLabel = new JLabel());
        
        gearLabel.setName("gearLabel");
        gearLabel.setText(_("tutti.manageTemporaryReferential.field.gear"));
        gearLabel.setToolTipText(_("tutti.manageTemporaryReferential.field.gear.tip"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(ManageTemporaryReferentialUIHandler.class));
    }

    protected void createImportGearButton() {
        $objectMap.put("importGearButton", importGearButton = new JButton());
        
        importGearButton.setName("importGearButton");
        importGearButton.setText(_("tutti.manageTemporaryReferential.action.importTemporaryGear"));
        importGearButton.setToolTipText(_("tutti.manageTemporaryReferential.action.importTemporaryGear.tip"));
        importGearButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryGear.help");
        importGearButton.putClientProperty("tuttiAction", ImportTemporaryGearAction.class);
    }

    protected void createImportPersonButton() {
        $objectMap.put("importPersonButton", importPersonButton = new JButton());
        
        importPersonButton.setName("importPersonButton");
        importPersonButton.setText(_("tutti.manageTemporaryReferential.action.importTemporaryPerson"));
        importPersonButton.setToolTipText(_("tutti.manageTemporaryReferential.action.importTemporaryPerson.tip"));
        importPersonButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryPerson.help");
        importPersonButton.putClientProperty("tuttiAction", ImportTemporaryPersonAction.class);
    }

    protected void createImportSpeciesButton() {
        $objectMap.put("importSpeciesButton", importSpeciesButton = new JButton());
        
        importSpeciesButton.setName("importSpeciesButton");
        importSpeciesButton.setText(_("tutti.manageTemporaryReferential.action.importTemporarySpecies"));
        importSpeciesButton.setToolTipText(_("tutti.manageTemporaryReferential.action.importTemporarySpecies.tip"));
        importSpeciesButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporarySpecies.help");
        importSpeciesButton.putClientProperty("tuttiAction", ImportTemporarySpeciesAction.class);
    }

    protected void createImportVesselButton() {
        $objectMap.put("importVesselButton", importVesselButton = new JButton());
        
        importVesselButton.setName("importVesselButton");
        importVesselButton.setText(_("tutti.manageTemporaryReferential.action.importTemporaryVessel"));
        importVesselButton.setToolTipText(_("tutti.manageTemporaryReferential.action.importTemporaryVessel.tip"));
        importVesselButton.putClientProperty("help", "tutti.manageTemporaryReferential.action.importTemporaryVessel.help");
        importVesselButton.putClientProperty("tuttiAction", ImportTemporaryVesselAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    protected void createPersonLabel() {
        $objectMap.put("personLabel", personLabel = new JLabel());
        
        personLabel.setName("personLabel");
        personLabel.setText(_("tutti.manageTemporaryReferential.field.person"));
        personLabel.setToolTipText(_("tutti.manageTemporaryReferential.field.person.tip"));
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.manageTemporaryReferential.field.species"));
        speciesLabel.setToolTipText(_("tutti.manageTemporaryReferential.field.species.tip"));
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(_("tutti.manageTemporaryReferential.field.vessel"));
        vesselLabel.setToolTipText(_("tutti.manageTemporaryReferential.field.vessel.tip"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToManageTemporaryReferentialTopPanel();
        // inline complete setup of $Table0
        $Table0.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator1, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(gearLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator2, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(personLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(exportSpeciesExampleButton);
        $JPanel0.add(importSpeciesButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(exportVesselExampleButton);
        $JPanel1.add(importVesselButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(exportGearExampleButton);
        $JPanel2.add(importGearButton);
        // inline complete setup of $JPanel3
        $JPanel3.add(exportPersonExampleButton);
        $JPanel3.add(importPersonButton);
        
        // apply 25 property setters
        speciesLabel.setIcon(SwingUtil.createImageIcon("action-species.gif"));
        exportSpeciesExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        exportSpeciesExampleButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.mnemonic"),'Z'));
        importSpeciesButton.setIcon(SwingUtil.createActionIcon("import"));
        importSpeciesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.manageTemporaryReferential.action.importTemporarySpecies.mnemonic"),'Z'));
        vesselLabel.setIcon(SwingUtil.createActionIcon("vessel"));
        exportVesselExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        exportVesselExampleButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.mnemonic"),'Z'));
        importVesselButton.setIcon(SwingUtil.createActionIcon("import"));
        importVesselButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.manageTemporaryReferential.action.importTemporaryVessel.mnemonic"),'Z'));
        gearLabel.setIcon(SwingUtil.createActionIcon("gear"));
        exportGearExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        exportGearExampleButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.manageTemporaryReferential.action.exportTemporaryGearExample.mnemonic"),'Z'));
        importGearButton.setIcon(SwingUtil.createActionIcon("import"));
        importGearButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.manageTemporaryReferential.action.importTemporaryGear.mnemonic"),'Z'));
        personLabel.setIcon(SwingUtil.createActionIcon("person"));
        exportPersonExampleButton.setIcon(SwingUtil.createActionIcon("export"));
        exportPersonExampleButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.mnemonic"),'Z'));
        importPersonButton.setIcon(SwingUtil.createActionIcon("import"));
        importPersonButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.manageTemporaryReferential.action.importTemporaryPerson.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, manageTemporaryReferentialTopPanel, "tutti.manageTemporaryReferential.help");
        registerHelpId(_broker, exportSpeciesExampleButton, "tutti.manageTemporaryReferential.action.exportTemporarySpeciesExample.help");
        registerHelpId(_broker, importSpeciesButton, "tutti.manageTemporaryReferential.action.importTemporarySpecies.help");
        registerHelpId(_broker, exportVesselExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryVesselExample.help");
        registerHelpId(_broker, importVesselButton, "tutti.manageTemporaryReferential.action.importTemporaryVessel.help");
        registerHelpId(_broker, exportGearExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryGearExample.help");
        registerHelpId(_broker, importGearButton, "tutti.manageTemporaryReferential.action.importTemporaryGear.help");
        registerHelpId(_broker, exportPersonExampleButton, "tutti.manageTemporaryReferential.action.exportTemporaryPersonExample.help");
        registerHelpId(_broker, importPersonButton, "tutti.manageTemporaryReferential.action.importTemporaryPerson.help");
        _broker.prepareUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("manageTemporaryReferentialTopPanel", manageTemporaryReferentialTopPanel);
        createHandler();
        createModel();
        createBroker();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createSpeciesLabel();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createExportSpeciesExampleButton();
        createImportSpeciesButton();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createVesselLabel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createExportVesselExampleButton();
        createImportVesselButton();
        // inline creation of $JSeparator1
        $objectMap.put("$JSeparator1", $JSeparator1 = new JSeparator());
        
        $JSeparator1.setName("$JSeparator1");
        createGearLabel();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createExportGearExampleButton();
        createImportGearButton();
        // inline creation of $JSeparator2
        $objectMap.put("$JSeparator2", $JSeparator2 = new JSeparator());
        
        $JSeparator2.setName("$JSeparator2");
        createPersonLabel();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createExportPersonExampleButton();
        createImportPersonButton();
        // inline creation of manageTemporaryReferentialTopPanel
        setName("manageTemporaryReferentialTopPanel");
        setLayout(new BorderLayout());
        manageTemporaryReferentialTopPanel.putClientProperty("help", "tutti.manageTemporaryReferential.help");
        
        $completeSetup();
    }

}