package fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.create;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class CreateAccidentalBatchUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<CreateAccidentalBatchUIModel, CreateAccidentalBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCIDENTAL_DEAD_OR_ALIVE_COMBO_BOX_SELECTED_ITEM = "accidentalDeadOrAliveComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_GENDER_COMBO_BOX_SELECTED_ITEM = "accidentalGenderComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "accidentalLengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_SIZE_FIELD_NUMBER_PATTERN = "accidentalSizeField.numberPattern";
    public static final String BINDING_ACCIDENTAL_SPECIES_COMBO_BOX_SELECTED_ITEM = "accidentalSpeciesComboBox.selectedItem";
    public static final String BINDING_ACCIDENTAL_WEIGHT_FIELD_NUMBER_PATTERN = "accidentalWeightField.numberPattern";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(CreateAccidentalBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "deadOrAlive",  editorName = "accidentalDeadOrAliveComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> accidentalDeadOrAliveComboBox;
    protected JLabel accidentalDeadOrAliveLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "gender",  editorName = "accidentalGenderComboBox")
    protected BeanFilterableComboBox<CaracteristicQualitativeValue> accidentalGenderComboBox;
    protected JLabel accidentalGenderLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "accidentalLengthStepCaracteristicComboBox")
    protected BeanFilterableComboBox<Caracteristic> accidentalLengthStepCaracteristicComboBox;
    protected JLabel accidentalLengthStepCaracteristicLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "size",  editorName = "accidentalSizeField")
    protected NumberEditor accidentalSizeField;
    protected JLabel accidentalSizeLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "accidentalSpeciesComboBox")
    protected BeanFilterableComboBox<Species> accidentalSpeciesComboBox;
    protected JLabel accidentalSpeciesLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "weight",  editorName = "accidentalWeightField")
    protected NumberEditor accidentalWeightField;
    protected JLabel accidentalWeightLabel;
    protected TuttiHelpBroker broker;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected CreateAccidentalBatchUI createAccidentalBatchTopPanel = this;
    protected CreateAccidentalBatchUIHandler handler;
    protected CreateAccidentalBatchUIModel model;
    protected JButton saveButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateAccidentalBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateAccidentalBatchUI(EditCatchesUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateAccidentalBatchUIHandler handler = new CreateAccidentalBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateAccidentalBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateAccidentalBatchUI() {
        $initialize();
    }

    public CreateAccidentalBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getAccidentalDeadOrAliveComboBox() {
        return accidentalDeadOrAliveComboBox;
    }

    public JLabel getAccidentalDeadOrAliveLabel() {
        return accidentalDeadOrAliveLabel;
    }

    public BeanFilterableComboBox<CaracteristicQualitativeValue> getAccidentalGenderComboBox() {
        return accidentalGenderComboBox;
    }

    public JLabel getAccidentalGenderLabel() {
        return accidentalGenderLabel;
    }

    public BeanFilterableComboBox<Caracteristic> getAccidentalLengthStepCaracteristicComboBox() {
        return accidentalLengthStepCaracteristicComboBox;
    }

    public JLabel getAccidentalLengthStepCaracteristicLabel() {
        return accidentalLengthStepCaracteristicLabel;
    }

    public NumberEditor getAccidentalSizeField() {
        return accidentalSizeField;
    }

    public JLabel getAccidentalSizeLabel() {
        return accidentalSizeLabel;
    }

    public BeanFilterableComboBox<Species> getAccidentalSpeciesComboBox() {
        return accidentalSpeciesComboBox;
    }

    public JLabel getAccidentalSpeciesLabel() {
        return accidentalSpeciesLabel;
    }

    public NumberEditor getAccidentalWeightField() {
        return accidentalWeightField;
    }

    public JLabel getAccidentalWeightLabel() {
        return accidentalWeightLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public CreateAccidentalBatchUIHandler getHandler() {
        return handler;
    }

    public CreateAccidentalBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public SwingValidator<CreateAccidentalBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(accidentalSpeciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalSpeciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalGenderLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalGenderComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalWeightField), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalSizeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalSizeField), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalLengthStepCaracteristicLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalLengthStepCaracteristicComboBox), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(accidentalDeadOrAliveLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(accidentalDeadOrAliveComboBox), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCreateAccidentalBatchTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(configurationPanel, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalDeadOrAliveComboBox() {
        $objectMap.put("accidentalDeadOrAliveComboBox", accidentalDeadOrAliveComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        accidentalDeadOrAliveComboBox.setName("accidentalDeadOrAliveComboBox");
        accidentalDeadOrAliveComboBox.setI18nPrefix("tutti.property.");
        accidentalDeadOrAliveComboBox.setProperty("deadOrAlive");
        accidentalDeadOrAliveComboBox.setShowReset(true);
    }

    protected void createAccidentalDeadOrAliveLabel() {
        $objectMap.put("accidentalDeadOrAliveLabel", accidentalDeadOrAliveLabel = new JLabel());
        
        accidentalDeadOrAliveLabel.setName("accidentalDeadOrAliveLabel");
        accidentalDeadOrAliveLabel.setText(_("tutti.createAccidentalBatch.field.accidentalDeadOrAlive"));
        accidentalDeadOrAliveLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalDeadOrAlive.tip"));
        accidentalDeadOrAliveLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalDeadOrAlive.help");
    }

    protected void createAccidentalGenderComboBox() {
        $objectMap.put("accidentalGenderComboBox", accidentalGenderComboBox = new BeanFilterableComboBox<CaracteristicQualitativeValue>(this));
        
        accidentalGenderComboBox.setName("accidentalGenderComboBox");
        accidentalGenderComboBox.setI18nPrefix("tutti.property.");
        accidentalGenderComboBox.setProperty("gender");
        accidentalGenderComboBox.setShowReset(true);
    }

    protected void createAccidentalGenderLabel() {
        $objectMap.put("accidentalGenderLabel", accidentalGenderLabel = new JLabel());
        
        accidentalGenderLabel.setName("accidentalGenderLabel");
        accidentalGenderLabel.setText(_("tutti.createAccidentalBatch.field.accidentalGender"));
        accidentalGenderLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalGender.tip"));
        accidentalGenderLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalGender.help");
    }

    protected void createAccidentalLengthStepCaracteristicComboBox() {
        $objectMap.put("accidentalLengthStepCaracteristicComboBox", accidentalLengthStepCaracteristicComboBox = new BeanFilterableComboBox<Caracteristic>(this));
        
        accidentalLengthStepCaracteristicComboBox.setName("accidentalLengthStepCaracteristicComboBox");
        accidentalLengthStepCaracteristicComboBox.setI18nPrefix("tutti.property.");
        accidentalLengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        accidentalLengthStepCaracteristicComboBox.setShowReset(true);
    }

    protected void createAccidentalLengthStepCaracteristicLabel() {
        $objectMap.put("accidentalLengthStepCaracteristicLabel", accidentalLengthStepCaracteristicLabel = new JLabel());
        
        accidentalLengthStepCaracteristicLabel.setName("accidentalLengthStepCaracteristicLabel");
        accidentalLengthStepCaracteristicLabel.setText(_("tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic"));
        accidentalLengthStepCaracteristicLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.tip"));
        accidentalLengthStepCaracteristicLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.help");
    }

    protected void createAccidentalSizeField() {
        $objectMap.put("accidentalSizeField", accidentalSizeField = new NumberEditor(this));
        
        accidentalSizeField.setName("accidentalSizeField");
        accidentalSizeField.setProperty("size");
        accidentalSizeField.setUseFloat(true);
        accidentalSizeField.setShowReset(true);
    }

    protected void createAccidentalSizeLabel() {
        $objectMap.put("accidentalSizeLabel", accidentalSizeLabel = new JLabel());
        
        accidentalSizeLabel.setName("accidentalSizeLabel");
        accidentalSizeLabel.setText(_("tutti.createAccidentalBatch.field.accidentalSize"));
        accidentalSizeLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalSize.tip"));
        accidentalSizeLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalSize.help");
    }

    protected void createAccidentalSpeciesComboBox() {
        $objectMap.put("accidentalSpeciesComboBox", accidentalSpeciesComboBox = new BeanFilterableComboBox<Species>(this));
        
        accidentalSpeciesComboBox.setName("accidentalSpeciesComboBox");
        accidentalSpeciesComboBox.setI18nPrefix("tutti.property.");
        accidentalSpeciesComboBox.setProperty("species");
        accidentalSpeciesComboBox.setShowReset(true);
    }

    protected void createAccidentalSpeciesLabel() {
        $objectMap.put("accidentalSpeciesLabel", accidentalSpeciesLabel = new JLabel());
        
        accidentalSpeciesLabel.setName("accidentalSpeciesLabel");
        accidentalSpeciesLabel.setText(_("tutti.createAccidentalBatch.field.accidentalSpecies"));
        accidentalSpeciesLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalSpecies.tip"));
        accidentalSpeciesLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalSpecies.help");
    }

    protected void createAccidentalWeightField() {
        $objectMap.put("accidentalWeightField", accidentalWeightField = new NumberEditor(this));
        
        accidentalWeightField.setName("accidentalWeightField");
        accidentalWeightField.setProperty("weight");
        accidentalWeightField.setUseFloat(true);
        accidentalWeightField.setShowReset(true);
    }

    protected void createAccidentalWeightLabel() {
        $objectMap.put("accidentalWeightLabel", accidentalWeightLabel = new JLabel());
        
        accidentalWeightLabel.setName("accidentalWeightLabel");
        accidentalWeightLabel.setText(_("tutti.createAccidentalBatch.field.accidentalWeight"));
        accidentalWeightLabel.setToolTipText(_("tutti.createAccidentalBatch.field.accidentalWeight.tip"));
        accidentalWeightLabel.putClientProperty("help", "tutti.createAccidentalBatch.field.accidentalWeight.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.createAccidentalBatch.help"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.createAccidentalBatch.action.cancel"));
        cancelButton.setToolTipText(_("tutti.createAccidentalBatch.action.cancel.tip"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
        cancelButton.putClientProperty("help", "tutti.createAccidentalBatch.action.cancel.help");
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateAccidentalBatchUIHandler.class));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateAccidentalBatchUIModel.class));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.createAccidentalBatch.action.save"));
        saveButton.setToolTipText(_("tutti.createAccidentalBatch.action.save.tip"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
        saveButton.putClientProperty("help", "tutti.createAccidentalBatch.action.save.help");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateAccidentalBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToCreateAccidentalBatchTopPanel();
        addChildrenToValidator();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 26 property setters
        accidentalSpeciesComboBox.setBeanType(Species.class);
        accidentalGenderComboBox.setBeanType(CaracteristicQualitativeValue.class);
        accidentalLengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        accidentalDeadOrAliveComboBox.setBeanType(CaracteristicQualitativeValue.class);
        accidentalSpeciesLabel.setLabelFor(accidentalSpeciesComboBox);
        accidentalSpeciesComboBox.setBean(model);
        accidentalGenderLabel.setLabelFor(accidentalGenderComboBox);
        accidentalGenderComboBox.setBean(model);
        accidentalWeightLabel.setLabelFor(accidentalWeightField);
        accidentalWeightField.setBean(model);
        accidentalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        accidentalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        accidentalSizeLabel.setLabelFor(accidentalSizeField);
        accidentalSizeField.setBean(model);
        accidentalSizeField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        accidentalSizeField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        accidentalLengthStepCaracteristicLabel.setLabelFor(accidentalLengthStepCaracteristicComboBox);
        accidentalLengthStepCaracteristicComboBox.setBean(model);
        accidentalDeadOrAliveLabel.setLabelFor(accidentalDeadOrAliveComboBox);
        accidentalDeadOrAliveComboBox.setBean(model);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        cancelButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createAccidentalBatch.action.cancel.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.createAccidentalBatch.action.save.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, createAccidentalBatchTopPanel, "tutti.createIndividualObservationBatch.help");
        registerHelpId(_broker, accidentalSpeciesLabel, "tutti.createAccidentalBatch.field.accidentalSpecies.help");
        registerHelpId(_broker, accidentalGenderLabel, "tutti.createAccidentalBatch.field.accidentalGender.help");
        registerHelpId(_broker, accidentalWeightLabel, "tutti.createAccidentalBatch.field.accidentalWeight.help");
        registerHelpId(_broker, accidentalSizeLabel, "tutti.createAccidentalBatch.field.accidentalSize.help");
        registerHelpId(_broker, accidentalLengthStepCaracteristicLabel, "tutti.createAccidentalBatch.field.accidentalLengthStepCaracteristic.help");
        registerHelpId(_broker, accidentalDeadOrAliveLabel, "tutti.createAccidentalBatch.field.accidentalDeadOrAlive.help");
        registerHelpId(_broker, cancelButton, "tutti.createAccidentalBatch.action.cancel.help");
        registerHelpId(_broker, saveButton, "tutti.createAccidentalBatch.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("createAccidentalBatchTopPanel", createAccidentalBatchTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createConfigurationPanel();
        createAccidentalSpeciesLabel();
        createAccidentalSpeciesComboBox();
        createAccidentalGenderLabel();
        createAccidentalGenderComboBox();
        createAccidentalWeightLabel();
        createAccidentalWeightField();
        createAccidentalSizeLabel();
        createAccidentalSizeField();
        createAccidentalLengthStepCaracteristicLabel();
        createAccidentalLengthStepCaracteristicComboBox();
        createAccidentalDeadOrAliveLabel();
        createAccidentalDeadOrAliveComboBox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        // inline creation of createAccidentalBatchTopPanel
        setName("createAccidentalBatchTopPanel");
        setLayout(new BorderLayout());
        createAccidentalBatchTopPanel.putClientProperty("help", "tutti.createIndividualObservationBatch.help");
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalSpeciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_GENDER_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("gender", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalGenderComboBox.setSelectedItem(model.getGender());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("gender", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ACCIDENTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                accidentalWeightField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ACCIDENTAL_SIZE_FIELD_NUMBER_PATTERN, true ,"DECIMAL3_PATTERN") {
        
            @Override
            public void processDataBinding() {
                accidentalSizeField.setNumberPattern(DECIMAL3_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalLengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ACCIDENTAL_DEAD_OR_ALIVE_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("deadOrAlive", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    accidentalDeadOrAliveComboBox.setSelectedItem(model.getDeadOrAlive());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("deadOrAlive", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}