package fr.ifremer.tutti.ui.swing.content;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractChangeScreenAction.java 682 2013-03-26 16:47:05Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.4/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/AbstractChangeScreenAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiScreen;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.JAXXContextEntryDef;

/**
 * Action to change the screen.
 * <p/>
 * Will just check that the current screen can be quit via
 * the {@link MainUIHandler#quitCurrentScreen()}.
 * <p/>
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public abstract class AbstractChangeScreenAction extends AbstractMainUITuttiAction {

    /**
     * Context entry to keep previous screen.
     *
     * @since 1.1
     */
    protected static final JAXXContextEntryDef<TuttiScreen> PREVIOUS_SCREEN =
            SwingUtil.newContextEntryDef("previousScreen", TuttiScreen.class);

    /**
     * Screen where to go.
     *
     * @since 1.0
     */
    protected final TuttiScreen screen;

    /**
     * Flag to skip the check of current screen.
     *
     * @since 1.1
     */
    protected boolean skipCheckCurrentScreen;

    protected AbstractChangeScreenAction(MainUIHandler handler,
                                         boolean hideBody,
                                         TuttiScreen screen) {
        super(handler, hideBody);
        this.screen = screen;
    }

    public void setSkipCheckCurrentScreen(boolean skipCheckCurrentScreen) {
        this.skipCheckCurrentScreen = skipCheckCurrentScreen;
    }

    @Override
    protected boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        result &= skipCheckCurrentScreen || getHandler().quitCurrentScreen();
        return result;
    }

    @Override
    protected void doAction() throws Exception {

        TuttiUIContext context = getContext();

        try {

            TuttiScreen previousScreen = context.getScreen();
            if (getUI() != null) {
                if (previousScreen == null) {
                    PREVIOUS_SCREEN.removeContextValue(getUI());
                } else {
                    PREVIOUS_SCREEN.setContextValue(getUI(), previousScreen);
                }
            }

            // clean current screen
            context.setScreen(null);

            // change screen
            context.setScreen(screen);

        } catch (Exception e) {
            throw e;
        }
    }

    @Override
    public void postFailedAction(Throwable error) {
        TuttiUIContext context = getContext();
        if (error != null) {
            if (context.isDbLoaded()) {
                context.setScreen(TuttiScreen.SELECT_CRUISE);
            } else {
                context.setScreen(TuttiScreen.MANAGE_DB);
            }
        }
    }

}
