/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.operation;

import fr.ifremer.adagio.core.dao.data.operation.OperationImpl;
import fr.ifremer.adagio.core.dao.data.operation.OperationVesselAssociation;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.GearUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.use.VesselUseFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.position.VesselPosition;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class Operation
implements Serializable {
    private static final long serialVersionUID = 4065992805884536005L;
    private Integer id;
    private String name;
    private Short rankOrderOnPeriod;
    private Date startDateTime;
    private Date endDateTime;
    private Boolean isMainOperation;
    private String position;
    private String comments;
    private Date controlDate;
    private Date validationDate;
    private Date qualificationDate;
    private String qualificationComments;
    private FishingTrip fishingTrip;
    private QualityFlag qualityFlag;
    private Vessel vessel;
    private Collection<OperationVesselAssociation> operationVesselAssociations = new HashSet<OperationVesselAssociation>();
    private Collection<VesselPosition> vesselPositions = new HashSet<VesselPosition>();
    private GearPhysicalFeatures gearPhysicalFeatures;
    private Collection<VesselUseFeatures> vesselUseFeatures = new HashSet<VesselUseFeatures>();
    private Collection<GearUseFeatures> gearUseFeatures = new HashSet<GearUseFeatures>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Short getRankOrderOnPeriod() {
        return this.rankOrderOnPeriod;
    }

    public void setRankOrderOnPeriod(Short rankOrderOnPeriod) {
        this.rankOrderOnPeriod = rankOrderOnPeriod;
    }

    public Date getStartDateTime() {
        return this.startDateTime;
    }

    public void setStartDateTime(Date startDateTime) {
        this.startDateTime = startDateTime;
    }

    public Date getEndDateTime() {
        return this.endDateTime;
    }

    public void setEndDateTime(Date endDateTime) {
        this.endDateTime = endDateTime;
    }

    public Boolean getIsMainOperation() {
        return this.isMainOperation;
    }

    public void setIsMainOperation(Boolean isMainOperation) {
        this.isMainOperation = isMainOperation;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getControlDate() {
        return this.controlDate;
    }

    public void setControlDate(Date controlDate) {
        this.controlDate = controlDate;
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public Date getQualificationDate() {
        return this.qualificationDate;
    }

    public void setQualificationDate(Date qualificationDate) {
        this.qualificationDate = qualificationDate;
    }

    public String getQualificationComments() {
        return this.qualificationComments;
    }

    public void setQualificationComments(String qualificationComments) {
        this.qualificationComments = qualificationComments;
    }

    public FishingTrip getFishingTrip() {
        return this.fishingTrip;
    }

    public void setFishingTrip(FishingTrip fishingTrip) {
        this.fishingTrip = fishingTrip;
    }

    public QualityFlag getQualityFlag() {
        return this.qualityFlag;
    }

    public void setQualityFlag(QualityFlag qualityFlag) {
        this.qualityFlag = qualityFlag;
    }

    public Vessel getVessel() {
        return this.vessel;
    }

    public void setVessel(Vessel vessel) {
        this.vessel = vessel;
    }

    public Collection<OperationVesselAssociation> getOperationVesselAssociations() {
        return this.operationVesselAssociations;
    }

    public void setOperationVesselAssociations(Collection<OperationVesselAssociation> operationVesselAssociations) {
        this.operationVesselAssociations = operationVesselAssociations;
    }

    public Collection<VesselPosition> getVesselPositions() {
        return this.vesselPositions;
    }

    public void setVesselPositions(Collection<VesselPosition> vesselPositions) {
        this.vesselPositions = vesselPositions;
    }

    public GearPhysicalFeatures getGearPhysicalFeatures() {
        return this.gearPhysicalFeatures;
    }

    public void setGearPhysicalFeatures(GearPhysicalFeatures gearPhysicalFeatures) {
        this.gearPhysicalFeatures = gearPhysicalFeatures;
    }

    public Collection<VesselUseFeatures> getVesselUseFeatures() {
        return this.vesselUseFeatures;
    }

    public void setVesselUseFeatures(Collection<VesselUseFeatures> vesselUseFeatures) {
        this.vesselUseFeatures = vesselUseFeatures;
    }

    public Collection<GearUseFeatures> getGearUseFeatures() {
        return this.gearUseFeatures;
    }

    public void setGearUseFeatures(Collection<GearUseFeatures> gearUseFeatures) {
        this.gearUseFeatures = gearUseFeatures;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Operation)) {
            return false;
        }
        Operation that = (Operation)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Operation newInstance() {
            OperationImpl entity = new OperationImpl();
            return entity;
        }

        public static Operation newInstance(QualityFlag qualityFlag, Vessel vessel) {
            Operation entity = Factory.newInstance();
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            return entity;
        }

        public static Operation newInstance(String name, Short rankOrderOnPeriod, Date startDateTime, Date endDateTime, Boolean isMainOperation, String position, String comments, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, FishingTrip fishingTrip, QualityFlag qualityFlag, Vessel vessel, Collection<OperationVesselAssociation> operationVesselAssociations, Collection<VesselPosition> vesselPositions, GearPhysicalFeatures gearPhysicalFeatures, Collection<VesselUseFeatures> vesselUseFeatures, Collection<GearUseFeatures> gearUseFeatures) {
            Operation entity = Factory.newInstance();
            entity.setName(name);
            entity.setRankOrderOnPeriod(rankOrderOnPeriod);
            entity.setStartDateTime(startDateTime);
            entity.setEndDateTime(endDateTime);
            entity.setIsMainOperation(isMainOperation);
            entity.setPosition(position);
            entity.setComments(comments);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setFishingTrip(fishingTrip);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setOperationVesselAssociations(operationVesselAssociations);
            entity.setVesselPositions(vesselPositions);
            entity.setGearPhysicalFeatures(gearPhysicalFeatures);
            entity.setVesselUseFeatures(vesselUseFeatures);
            entity.setGearUseFeatures(gearUseFeatures);
            return entity;
        }
    }
}

