
package fr.ifremer.tutti.ui.swing.util;

/*
 * #%L
 * Tutti :: UI
 * $Id: TabHandler.java 308 2013-02-03 13:06:27Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/TabHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

/**
 * Interface describing UI contained in a tab.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 0.3
 */
public interface TabHandler {

    /**
     * Method called when the tab is hidden
     *
     * @param currentIndex
     * @param newIndex
     * @return <code>false</code> to prevent the tab to be hidden,
     *         <code>true</code> otherwise.
     */
    boolean onHideTab(int currentIndex, int newIndex);

    /**
     * Method called when the tab is shown
     *
     * @param currentIndex
     * @param newIndex
     */
    void onShowTab(int currentIndex, int newIndex);
}
