package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditFishingOperationUIModel.java 629 2013-03-15 09:48:31Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/EditFishingOperationUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.spatial.SexagecimalPosition;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import org.nuiton.util.DateUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import static org.nuiton.i18n.I18n.n_;

/**
 * Model for UI {@link EditFishingOperationUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditFishingOperationUIModel extends AbstractTuttiBeanUIModel<FishingOperation, EditFishingOperationUIModel> implements AttachmentModelAware {

    private static final long serialVersionUID = 1L;

    public static final String TITLE = n_("tutti.editFishingOperation.tab.general");

    public static final String PROPERTY_PERSISTED = "persisted";

    public static final String PROPERTY_EMPTY = "empty";

    public static final String PROPERTY_STATION_NUMBER = "stationNumber";

    public static final String PROPERTY_FISHING_OPERATION_NUMBER = "fishingOperationNumber";

    public static final String PROPERTY_STRATA = "strata";

    public static final String PROPERTY_SUB_STRATA = "subStrata";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE = "gearShootingStartLatitude";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DEGREE = "gearShootingStartLatitudeDegree";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_MINUTE = "gearShootingStartLatitudeMinute";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DECIMAL_MINUTE = "gearShootingStartLatitudeDecimalMinute";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_SECOND = "gearShootingStartLatitudeSecond";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE = "gearShootingStartLongitude";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DEGREE = "gearShootingStartLongitudeDegree";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_MINUTE = "gearShootingStartLongitudeMinute";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DECIMAL_MINUTE = "gearShootingStartLongitudeDecimalMinute";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_SECOND = "gearShootingStartLongitudeSecond";

    public static final String PROPERTY_GEAR_SHOOTING_START_DATE = "gearShootingStartDate";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE = "gearShootingEndLatitude";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DEGREE = "gearShootingEndLatitudeDegree";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_MINUTE = "gearShootingEndLatitudeMinute";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DECIMAL_MINUTE = "gearShootingEndLatitudeDecimalMinute";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_SECOND = "gearShootingEndLatitudeSecond";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE = "gearShootingEndLongitude";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DEGREE = "gearShootingEndLongitudeDegree";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_MINUTE = "gearShootingEndLongitudeMinute";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DECIMAL_MINUTE = "gearShootingEndLongitudeDecimalMinute";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_SECOND = "gearShootingEndLongitudeSecond";

    public static final String PROPERTY_GEAR_SHOOTING_END_DATE = "gearShootingEndDate";

    public static final String PROPERTY_FISHING_OPERATION_RECTILIGNE = "fishingOperationRectiligne";

    public static final String PROPERTY_TRAWL_DISTANCE = "trawlDistance";

    public static final String PROPERTY_MULTIRIG_AGGREGATION = "multirigAggregation";

    public static final String PROPERTY_FISHING_OPERATION_VALID = "fishingOperationValid";

    public static final String PROPERTY_LOCATION = "location";

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_RECORDER_PERSON = "recorderPerson";

    public static final String PROPERTY_VESSEL = "vessel";

    public static final String PROPERTY_GEAR = "gear";

//    public static final String PROPERTY_ATTACHMENT = "attachment";

    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";

    /**
     * Flag when there is no fishing operation selected.
     *
     * @since 0.2
     */
    protected boolean empty;

    protected Cruise cruise;

    protected String stationNumber;

    protected Integer fishingOperationNumber;

    protected FishingOperationLocation strata;

    protected FishingOperationLocation subStrata;

    protected SexagecimalPosition gearShootingStartLatitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingStartLongitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingEndLatitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingEndLongitudeAsSexagecimal;

    protected Float gearShootingStartLatitude;

    protected Float gearShootingStartLongitude;

    protected Date gearShootingStartDate;

    protected Float gearShootingEndLatitude;

    protected Float gearShootingEndLongitude;

    protected Date gearShootingEndDate;

    protected boolean fishingOperationRectiligne;

    protected Float trawlDistance;

    protected Boolean fishingOperationValid;

    protected FishingOperationLocation location;

    protected String comment;

    protected List<Person> recorderPerson = Lists.newArrayList();

    protected final List<Attachment> attachment = Lists.newArrayList();

    protected FishingOperation fishingOperation;

    protected String validationContext;

    protected Gear gear;

    protected Vessel vessel;

    protected String multirigAggregation;

    protected CoordinateEditorType coordinateEditorType;

    protected List<FishingOperation> existingOperations;

    protected static Binder<EditFishingOperationUIModel, FishingOperation> toBeanBinder =
            BinderFactory.newBinder(EditFishingOperationUIModel.class,
                                    FishingOperation.class);

    protected static Binder<FishingOperation, EditFishingOperationUIModel> fromBeanBinder =
            BinderFactory.newBinder(FishingOperation.class, EditFishingOperationUIModel.class);

    public EditFishingOperationUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
        gearShootingStartLatitudeAsSexagecimal = SexagecimalPosition.valueOf(gearShootingStartLatitude);
        gearShootingStartLongitudeAsSexagecimal = SexagecimalPosition.valueOf(gearShootingStartLongitude);
        gearShootingEndLatitudeAsSexagecimal = SexagecimalPosition.valueOf(gearShootingEndLatitude);
        gearShootingEndLongitudeAsSexagecimal = SexagecimalPosition.valueOf(gearShootingEndLongitude);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
        firePropertyChange(PROPERTY_PERSISTED, null, isPersisted());
    }

    public boolean isPersisted() {
        return fishingOperation != null && !TuttiEntities.isNew(fishingOperation);
    }

    public boolean isEmpty() {
        return empty;
    }

    public void setEmpty(boolean empty) {
        Object oldValue = isEmpty();
        this.empty = empty;
        firePropertyChange(PROPERTY_EMPTY, oldValue, empty);
    }

    public Cruise getCruise() {
        return cruise;
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.OPERATION;
    }

    @Override
    public String getObjectId() {
        return getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        firePropertyChange(PROPERTY_ATTACHMENT, null, getAttachment());
    }

    public String getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        Object oldValue = getStationNumber();
        this.stationNumber = stationNumber;
        firePropertyChange(PROPERTY_STATION_NUMBER, oldValue, stationNumber);
    }

    public Integer getFishingOperationNumber() {
        return fishingOperationNumber;
    }

    public void setFishingOperationNumber(Integer fishingOperationNumber) {
        Object oldValue = getFishingOperationNumber();
        this.fishingOperationNumber = fishingOperationNumber;
        firePropertyChange(PROPERTY_FISHING_OPERATION_NUMBER, oldValue, fishingOperationNumber);
    }

    public FishingOperationLocation getStrata() {
        return strata;
    }

    public void setStrata(FishingOperationLocation strata) {
        Object oldValue = getStrata();
        this.strata = strata;
        firePropertyChange(PROPERTY_STRATA, oldValue, strata);
    }

    public FishingOperationLocation getSubStrata() {
        return subStrata;
    }

    public void setSubStrata(FishingOperationLocation subStrata) {
        Object oldValue = getSubStrata();
        this.subStrata = subStrata;
        firePropertyChange(PROPERTY_SUB_STRATA, oldValue, subStrata);
    }

    public Float getGearShootingStartLatitude() {
        return gearShootingStartLatitude;
    }

    public void setGearShootingStartLatitude(Float gearShootingStartLatitude) {
        Object oldValue = getGearShootingStartLatitude();
        this.gearShootingStartLatitude = gearShootingStartLatitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE, oldValue, gearShootingStartLatitude);
    }

    public Integer getGearShootingStartLatitudeDegree() {
        Integer result = gearShootingStartLatitudeAsSexagecimal.getDegre();
        if (gearShootingStartLatitudeAsSexagecimal.isSign()) {
            result *= -1;
        }
        return result;
    }

    public Integer getGearShootingStartLatitudeDecimalDegree() {
        return getGearShootingStartLatitudeDegree();
    }

    public void setGearShootingStartLatitudeDegree(Integer degree) {
        Object oldValue = getGearShootingStartLatitudeDegree();
        boolean sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        gearShootingStartLatitudeAsSexagecimal.setSign(sign);
        gearShootingStartLatitudeAsSexagecimal.setDegre(degree);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingStartLatitudeDecimalDegree(Integer degree) {
        setGearShootingStartLatitudeDegree(degree);
    }

    public Integer getGearShootingStartLatitudeMinute() {
        return gearShootingStartLatitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingStartLatitudeMinute(Integer minute) {
        Object oldValue = getGearShootingStartLatitudeMinute();
        gearShootingStartLatitudeAsSexagecimal.setMinute(minute);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingStartLatitudeDecimalMinute() {
        return gearShootingStartLatitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingStartLatitudeDecimalMinute(Float decimalMinute) {
        gearShootingStartLatitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        // 2013-01-22 kmorin: pass null as previous value, 
        // otherwise the filed is not filled with the value (I cannot explain why... :()
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingStartLatitudeSecond() {
        return gearShootingStartLatitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingStartLatitudeSecond(Integer second) {
        Object oldValue = getGearShootingStartLatitudeSecond();
        gearShootingStartLatitudeAsSexagecimal.setSeconde(second);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_SECOND, oldValue, second);
    }

    public Float getGearShootingStartLongitude() {
        return gearShootingStartLongitude;
    }

    public void setGearShootingStartLongitude(Float gearShootingStartLongitude) {
        Object oldValue = getGearShootingStartLongitude();
        this.gearShootingStartLongitude = gearShootingStartLongitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE, oldValue, gearShootingStartLongitude);
    }


    public Integer getGearShootingStartLongitudeDegree() {
        Integer result = gearShootingStartLongitudeAsSexagecimal.getDegre();
        if (gearShootingStartLongitudeAsSexagecimal.isSign()) {
            result *= -1;
        }
        return result;
    }

    public Integer getGearShootingStartLongitudeDecimalDegree() {
        return getGearShootingStartLongitudeDegree();
    }

    public void setGearShootingStartLongitudeDegree(Integer degree) {
        Object oldValue = getGearShootingStartLongitudeDegree();
        boolean sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        gearShootingStartLongitudeAsSexagecimal.setSign(sign);
        gearShootingStartLongitudeAsSexagecimal.setDegre(degree);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingStartLongitudeDecimalDegree(Integer degree) {
        setGearShootingStartLongitudeDegree(degree);
    }

    public Integer getGearShootingStartLongitudeMinute() {
        return gearShootingStartLongitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingStartLongitudeMinute(Integer minute) {
        Object oldValue = getGearShootingStartLongitudeMinute();
        gearShootingStartLongitudeAsSexagecimal.setMinute(minute);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingStartLongitudeDecimalMinute() {
        return gearShootingStartLongitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingStartLongitudeDecimalMinute(Float decimalMinute) {
        gearShootingStartLongitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        // 2013-01-22 kmorin: pass null as previous value, 
        // otherwise the filed is not filled with the value (I cannot explain why... :()
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingStartLongitudeSecond() {
        return gearShootingStartLongitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingStartLongitudeSecond(Integer second) {
        Object oldValue = getGearShootingStartLongitudeSecond();
        gearShootingStartLongitudeAsSexagecimal.setSeconde(second);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_SECOND, oldValue, second);
    }

    public Date getGearShootingStartDate() {
        return gearShootingStartDate;
    }

    public void setGearShootingStartDate(Date gearShootingStartDate) {
        Object oldValue = getGearShootingStartDate();
        if (gearShootingStartDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar(gearShootingStartDate);
            calendar.set(Calendar.SECOND, 0);
            this.gearShootingStartDate = calendar.getTime();

        } else {
            this.gearShootingStartDate = null;
        }
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_DATE, oldValue, this.gearShootingStartDate);
    }

    public void setGearShootingStartTime(Date gearShootingStartDate) {
        Object oldValue = getGearShootingStartDate();
        if (oldValue != null) {
            setGearShootingStartDate(gearShootingStartDate);
        }
    }

    public Float getGearShootingEndLatitude() {
        return gearShootingEndLatitude;
    }

    public void setGearShootingEndLatitude(Float gearShootingEndLatitude) {
        Object oldValue = getGearShootingEndLatitude();
        this.gearShootingEndLatitude = gearShootingEndLatitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE, oldValue, gearShootingEndLatitude);
    }

    public Integer getGearShootingEndLatitudeDegree() {
        Integer result = gearShootingEndLatitudeAsSexagecimal.getDegre();
        if (gearShootingEndLatitudeAsSexagecimal.isSign()) {
            result *= -1;
        }
        return result;
    }

    public Integer getGearShootingEndLatitudeDecimalDegree() {
        return getGearShootingEndLatitudeDegree();
    }

    public void setGearShootingEndLatitudeDegree(Integer degree) {
        Object oldValue = getGearShootingEndLatitudeDegree();
        boolean sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        gearShootingEndLatitudeAsSexagecimal.setSign(sign);
        gearShootingEndLatitudeAsSexagecimal.setDegre(degree);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingEndLatitudeDecimalDegree(Integer degree) {
        setGearShootingEndLatitudeDegree(degree);
    }

    public Integer getGearShootingEndLatitudeMinute() {
        return gearShootingEndLatitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingEndLatitudeMinute(Integer minute) {
        Object oldValue = getGearShootingEndLatitudeMinute();
        gearShootingEndLatitudeAsSexagecimal.setMinute(minute);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingEndLatitudeDecimalMinute() {
        return gearShootingEndLatitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingEndLatitudeDecimalMinute(Float decimalMinute) {
        gearShootingEndLatitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        // 2013-01-22 kmorin: pass null as previous value, 
        // otherwise the filed is not filled with the value (I cannot explain why... :()
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingEndLatitudeSecond() {
        return gearShootingEndLatitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingEndLatitudeSecond(Integer second) {
        Object oldValue = getGearShootingEndLatitudeSecond();
        gearShootingEndLatitudeAsSexagecimal.setSeconde(second);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_SECOND, oldValue, second);
    }

    public Float getGearShootingEndLongitude() {
        return gearShootingEndLongitude;
    }

    public void setGearShootingEndLongitude(Float gearShootingEndLongitude) {
        Object oldValue = getGearShootingEndLongitude();
        this.gearShootingEndLongitude = gearShootingEndLongitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE, oldValue, gearShootingEndLongitude);
    }

    public Integer getGearShootingEndLongitudeDegree() {
        Integer result = gearShootingEndLongitudeAsSexagecimal.getDegre();
        if (gearShootingEndLongitudeAsSexagecimal.isSign()) {
            result *= -1;
        }
        return result;
    }

    public Integer getGearShootingEndLongitudeDecimalDegree() {
        return getGearShootingEndLongitudeDegree();
    }

    public void setGearShootingEndLongitudeDegree(Integer degree) {
        Object oldValue = getGearShootingEndLongitudeDegree();
        boolean sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        gearShootingEndLongitudeAsSexagecimal.setSign(sign);
        gearShootingEndLongitudeAsSexagecimal.setDegre(degree);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingEndLongitudeDecimalDegree(Integer degree) {
        setGearShootingEndLongitudeDegree(degree);
    }

    public Integer getGearShootingEndLongitudeMinute() {
        return gearShootingEndLongitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingEndLongitudeMinute(Integer minute) {
        Object oldValue = getGearShootingEndLongitudeMinute();
        gearShootingEndLongitudeAsSexagecimal.setMinute(minute);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingEndLongitudeDecimalMinute() {
        return gearShootingEndLongitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingEndLongitudeDecimalMinute(Float decimalMinute) {
        gearShootingEndLongitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        // 2013-01-22 kmorin: pass null as previous value, 
        // otherwise the filed is not filled with the value (I cannot explain why... :()
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingEndLongitudeSecond() {
        return gearShootingEndLongitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingEndLongitudeSecond(Integer second) {
        Object oldValue = getGearShootingEndLongitudeSecond();
        gearShootingEndLongitudeAsSexagecimal.setSeconde(second);
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_SECOND, oldValue, second);
    }

    public Date getGearShootingEndDate() {
        return gearShootingEndDate;
    }

    public void setGearShootingEndDate(Date gearShootingEndDate) {
        Object oldValue = getGearShootingEndDate();
        if (gearShootingEndDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar(gearShootingEndDate);
            calendar.set(Calendar.SECOND, 0);
            this.gearShootingEndDate = calendar.getTime();

        } else {
            this.gearShootingEndDate = null;
        }
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_DATE, oldValue, this.gearShootingEndDate);
    }

    public void setGearShootingEndTime(Date gearShootingEndDate) {
        Object oldValue = getGearShootingEndDate();
        if (oldValue != null) {
            setGearShootingEndDate(gearShootingEndDate);
        }
    }

    public boolean isFishingOperationRectiligne() {
        return fishingOperationRectiligne;
    }

    public void setFishingOperationRectiligne(boolean fishingOperationRectiligne) {
        Object oldValue = isFishingOperationRectiligne();
        this.fishingOperationRectiligne = fishingOperationRectiligne;
        firePropertyChange(PROPERTY_FISHING_OPERATION_RECTILIGNE, oldValue, fishingOperationRectiligne);
    }

    public Float getTrawlDistance() {
        return trawlDistance;
    }

    public void setTrawlDistance(Float trawlDistance) {
        Object oldValue = getTrawlDistance();
        this.trawlDistance = trawlDistance;
        firePropertyChange(PROPERTY_TRAWL_DISTANCE, oldValue, trawlDistance);
    }

    public Boolean getFishingOperationValid() {
        return fishingOperationValid;
    }

    public void setFishingOperationValid(Boolean fishingOperationValid) {
        Object oldValue = getFishingOperationValid();
        this.fishingOperationValid = fishingOperationValid;
        firePropertyChange(PROPERTY_FISHING_OPERATION_VALID, oldValue, fishingOperationValid);
    }

    public FishingOperationLocation getLocation() {
        return location;
    }

    public void setLocation(FishingOperationLocation location) {
        Object oldValue = getLocation();
        this.location = location;
        firePropertyChange(PROPERTY_LOCATION, oldValue, location);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<Person> getRecorderPerson() {
        return recorderPerson;
    }

    public void setRecorderPerson(List<Person> recorderPerson) {
        Object oldValue = Lists.newArrayList(getRecorderPerson());
        this.recorderPerson = Lists.newArrayList();
        if (recorderPerson != null) {
            this.recorderPerson.addAll(recorderPerson);
        }
        firePropertyChange(PROPERTY_RECORDER_PERSON, oldValue, recorderPerson);
    }

    public String getValidationContext() {
        return validationContext;
    }

    public void setValidationContext(String validationContext) {
        Object oldValue = getValidationContext();
        this.validationContext = validationContext;
        firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public Gear getGear() {
        return gear;
    }

    public void setGear(Gear gear) {
        Object oldValue = getGear();
        this.gear = gear;
        firePropertyChange(PROPERTY_GEAR, oldValue, gear);
    }

    public Vessel getVessel() {
        return vessel;
    }

    public void setVessel(Vessel vessel) {
        Object oldValue = getVessel();
        this.vessel = vessel;
        firePropertyChange(PROPERTY_VESSEL, oldValue, vessel);
    }

    public String getMultirigAggregation() {
        return multirigAggregation;
    }

    public void setMultirigAggregation(String multirigAggregation) {
        Object oldValue = getMultirigAggregation();
        this.multirigAggregation = multirigAggregation;
        firePropertyChange(PROPERTY_MULTIRIG_AGGREGATION, oldValue, multirigAggregation);
    }

    public CoordinateEditorType getCoordinateEditorType() {
        return coordinateEditorType;
    }

    public void setCoordinateEditorType(CoordinateEditorType coordinateEditorType) {
        this.coordinateEditorType = coordinateEditorType;
    }

    @Override
    protected FishingOperation newEntity() {
        return fishingOperation;
    }

    public boolean isDateInCruise(Date date) {
        return DateUtil.between(date, cruise.getBeginDate(), cruise.getEndDate());
    }

    public boolean isValidDuration() {
        int minutes = DateUtil.getDifferenceInMinutes(gearShootingStartDate, gearShootingEndDate);
        return minutes <= 45 && minutes >= 20;
    }

    public List<FishingOperation> getExistingOperations() {
        return existingOperations;
    }

    public void setExistingOperations(List<FishingOperation> existingOperations) {
        this.existingOperations = existingOperations;
    }

    public void convertGearShootingCoordinatesDDToDMS() {
        SexagecimalPosition position;
        Integer degree;

        position = SexagecimalPosition.valueOf(gearShootingStartLatitude);
        degree = position.getDegre();
        if (degree != null) {
            degree *= position.isSign() ? -1 : 1;
        }
        setGearShootingStartLatitudeDegree(degree);
        setGearShootingStartLatitudeMinute(position.getMinute());
        setGearShootingStartLatitudeSecond(position.getSeconde());
        setGearShootingStartLatitudeDecimalMinute(position.getMinuteDecimale());

        position = SexagecimalPosition.valueOf(gearShootingStartLongitude);
        degree = position.getDegre();
        if (degree != null) {
            degree *= position.isSign() ? -1 : 1;
        }
        setGearShootingStartLongitudeDegree(degree);
        setGearShootingStartLongitudeMinute(position.getMinute());
        setGearShootingStartLongitudeSecond(position.getSeconde());
        setGearShootingStartLongitudeDecimalMinute(position.getMinuteDecimale());

        position = SexagecimalPosition.valueOf(gearShootingEndLatitude);
        degree = position.getDegre();
        if (degree != null) {
            degree *= position.isSign() ? -1 : 1;
        }
        if (position.getDegre() != null) {

        }
        setGearShootingEndLatitudeDegree(degree);
        setGearShootingEndLatitudeMinute(position.getMinute());
        setGearShootingEndLatitudeSecond(position.getSeconde());
        setGearShootingEndLatitudeDecimalMinute(position.getMinuteDecimale());

        position = SexagecimalPosition.valueOf(gearShootingEndLongitude);
        degree = position.getDegre();
        if (degree != null) {
            degree *= position.isSign() ? -1 : 1;
        }
        setGearShootingEndLongitudeDegree(degree);
        setGearShootingEndLongitudeMinute(position.getMinute());
        setGearShootingEndLongitudeSecond(position.getSeconde());
        setGearShootingEndLongitudeDecimalMinute(position.getMinuteDecimale());
    }

    public void convertGearShootingCoordinatesDMSToDD() {
        Float decimalValue = gearShootingStartLatitudeAsSexagecimal.toDecimal();
        setGearShootingStartLatitude(decimalValue);

        decimalValue = gearShootingStartLongitudeAsSexagecimal.toDecimal();
        setGearShootingStartLongitude(decimalValue);

        decimalValue = gearShootingEndLatitudeAsSexagecimal.toDecimal();
        setGearShootingEndLatitude(decimalValue);

        decimalValue = gearShootingEndLongitudeAsSexagecimal.toDecimal();
        setGearShootingEndLongitude(decimalValue);
    }

    public void computeDistance() {
        if (coordinateEditorType != CoordinateEditorType.DD) {
            convertGearShootingCoordinatesDMSToDD();
        }
        if (gearShootingStartLatitude != null && gearShootingStartLongitude != null
            && gearShootingEndLatitude != null && gearShootingEndLongitude != null) {
            Integer distance = TuttiUIUtil.computeDistanceInMeters(gearShootingStartLatitude, gearShootingStartLongitude, gearShootingEndLatitude, gearShootingEndLongitude);
            setTrawlDistance(distance.floatValue());
        }
    }

}