/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.comment;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.comment.CommentEditorUI;
import fr.ifremer.tutti.ui.swing.util.comment.CommentModelAware;
import java.awt.Point;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.runtime.SwingUtil;
import org.nuiton.i18n.I18n;

public class ButtonComment
extends JToggleButton {
    private static final long serialVersionUID = 1L;
    protected final CommentEditorUI popup;
    protected Point popupPosition = null;
    protected boolean popupMoving;

    public ButtonComment(TuttiUIContext context, CommentModelAware model) {
        this.setIcon(SwingUtil.createActionIcon((String)"edit-comment"));
        this.setToolTipText(I18n._((String)"tutti.commentEditor.action.tip", (Object[])new Object[0]));
        this.popup = new CommentEditorUI(context);
        this.popup.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ButtonComment.this.setSelected(true);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                ButtonComment.this.setSelected(false);
            }

            @Override
            public void windowClosed(WindowEvent e) {
                ButtonComment.this.setSelected(false);
            }
        });
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (ButtonComment.this.isSelected()) {
                    ButtonComment.this.popup.openEditor(ButtonComment.this);
                } else {
                    ButtonComment.this.popup.closeEditor();
                }
            }
        });
        this.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void ancestorMoved(HierarchyEvent e) {
                if (ButtonComment.this.popup.isShowing()) {
                    Point point = new Point(ButtonComment.this.getLocationOnScreen());
                    point.translate(-ButtonComment.this.popup.getWidth() + ButtonComment.this.getWidth(), ButtonComment.this.getHeight());
                    ButtonComment.this.popupMoving = true;
                    try {
                        ButtonComment.this.popup.setLocation(point);
                    }
                    finally {
                        ButtonComment.this.popupMoving = false;
                    }
                }
            }
        });
        this.setBean(model);
    }

    public void init() {
        this.popup.getHandler().init();
    }

    public void init(CommentModelAware model) {
        this.setBean(model);
        this.init();
    }

    public void onCloseUI() {
        this.setSelected(false);
    }

    public CommentModelAware getBean() {
        return this.popup.getBean();
    }

    protected void setBean(CommentModelAware model) {
        this.popup.setBean(model);
        this.init();
    }
}

