/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.UpdateApplicationAction;
import fr.ifremer.tutti.ui.swing.util.TuttiExceptionHandler;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunTutti {
    private static final Log log = LogFactory.getLog(RunTutti.class);
    public static final int UPATE_EXIT_CODE = 88;

    public static void main(String ... args) {
        TuttiUIContext context;
        TuttiApplicationConfig config;
        block6: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting Tutti with arguments: " + Arrays.toString(args)));
            }
            Thread.setDefaultUncaughtExceptionHandler(new TuttiExceptionHandler());
            config = new TuttiApplicationConfig("tutti.config", args);
            context = TuttiUIContext.newContext(config);
            context.init();
            try {
                SwingUtil.initNimbusLoookAndFeel();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn((Object)"Failed to init nimbus look and feel");
            }
        }
        UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(Color.BLACK));
        if (config.isFullLaunchMode()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Full launch mode, try to update.");
            }
            MainUIHandler handler = new MainUIHandler(context);
            AbstractTuttiAction.runAction(new UpdateApplicationAction(handler));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Will start Tutti...");
        }
        RunTutti.startTutti(context, true);
    }

    public static void startTutti(TuttiUIContext context, boolean openContext) {
        if (openContext) {
            context.open();
        }
        MainUI mainUI = new MainUI(context);
        context.addMessageNotifier(mainUI.getHandler());
        mainUI.setVisible(true);
    }

    public static void closeTutti(MainUI ui, boolean exit) {
        TuttiUIContext context = ui.getHandler().getContext();
        ui.getHandler().onCloseUI();
        context.getSwingSession().save();
        context.close();
        if (exit) {
            System.exit(0);
        }
    }
}

