/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.administration.user;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.user.ManagedData;
import fr.ifremer.adagio.core.dao.administration.user.ManagedDataTransfer;
import fr.ifremer.adagio.core.dao.administration.user.ManagedDataTransferDao;
import fr.ifremer.adagio.core.dao.administration.user.ManagedDataTransferImpl;
import fr.ifremer.adagio.core.dao.administration.user.ManagedDataTransferPK;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public abstract class ManagedDataTransferDaoBase
extends HibernateDaoSupport
implements ManagedDataTransferDao {
    @Override
    public Object load(int transform, ManagedData managedData, Person newManagerUser) {
        ManagedDataTransferPK entityPk = new ManagedDataTransferPK();
        if (managedData == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.load - 'managedData' can not be null");
        }
        if (newManagerUser == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.load - 'newManagerUser' can not be null");
        }
        entityPk.setManagedData(managedData);
        entityPk.setNewManagerUser(newManagerUser);
        Object entity = this.getHibernateTemplate().get(ManagedDataTransferImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (ManagedDataTransfer)entity);
    }

    @Override
    public ManagedDataTransfer load(ManagedData managedData, Person newManagerUser) {
        return (ManagedDataTransfer)this.load(0, managedData, newManagerUser);
    }

    @Override
    public Collection<ManagedDataTransfer> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(ManagedDataTransferImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public ManagedDataTransfer create(ManagedDataTransfer managedDataTransfer) {
        return (ManagedDataTransfer)this.create(0, managedDataTransfer);
    }

    @Override
    public Object create(int transform, ManagedDataTransfer managedDataTransfer) {
        if (managedDataTransfer == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.create - 'managedDataTransfer' can not be null");
        }
        this.getHibernateTemplate().save((Object)managedDataTransfer);
        return this.transformEntity(transform, managedDataTransfer);
    }

    @Override
    public Collection<ManagedDataTransfer> create(Collection<ManagedDataTransfer> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<ManagedDataTransfer> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ManagedDataTransferDaoBase.this.create(transform, (ManagedDataTransfer)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public ManagedDataTransfer create(Date transferDate, ManagedData managedData, Person newManagerUser) {
        return (ManagedDataTransfer)this.create(0, transferDate, managedData, newManagerUser);
    }

    @Override
    public Object create(int transform, Date transferDate, ManagedData managedData, Person newManagerUser) {
        ManagedDataTransferImpl entity = new ManagedDataTransferImpl();
        ManagedDataTransferPK entityPk = new ManagedDataTransferPK();
        entity.setManagedDataTransferPk(entityPk);
        entity.setTransferDate(transferDate);
        entityPk.setManagedData(managedData);
        entityPk.setNewManagerUser(newManagerUser);
        return this.create(transform, entity);
    }

    @Override
    public void update(ManagedDataTransfer managedDataTransfer) {
        if (managedDataTransfer == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.update - 'managedDataTransfer' can not be null");
        }
        this.getHibernateTemplate().update((Object)managedDataTransfer);
    }

    @Override
    public void update(final Collection<ManagedDataTransfer> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ManagedDataTransferDaoBase.this.update((ManagedDataTransfer)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(ManagedDataTransfer managedDataTransfer) {
        if (managedDataTransfer == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.remove - 'managedDataTransfer' can not be null");
        }
        this.getHibernateTemplate().delete((Object)managedDataTransfer);
    }

    @Override
    public void remove(ManagedData managedData, Person newManagerUser) {
        ManagedDataTransferPK entityPk = new ManagedDataTransferPK();
        if (managedData == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.remove - 'managedData' can not be null");
        }
        entityPk.setManagedData(managedData);
        if (newManagerUser == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.remove - 'newManagerUser' can not be null");
        }
        entityPk.setNewManagerUser(newManagerUser);
        ManagedDataTransfer entity = this.load(managedData, newManagerUser);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<ManagedDataTransfer> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ManagedDataTransfer.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, ManagedDataTransfer entity) {
        ManagedDataTransfer target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected ManagedDataTransfer toEntity(Object[] row) {
        ManagedDataTransfer target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof ManagedDataTransfer)) continue;
                target = (ManagedDataTransfer)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ManagedDataTransferImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ManagedDataTransferImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<ManagedDataTransfer> search(Search search) {
        return this.search(0, search);
    }
}

